/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.css.linter.stylelint.StylelintInspection;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StylelintConfiguration", storages={@Storage(value="stylesheetLinters/stylelint.xml")})
public class StylelintConfiguration
extends JSLinterConfiguration<StylelintState> {
    private static final StylelintState DEFAULT_STATE = new StylelintState();
    private static final String NODE_INTERPRETER_REF = "stylesheet.stylelint.nodeInterpreter";
    private static final String STYLELINT_PACKAGE_PATH = "stylesheet.stylelint.stylelintPackage";

    public StylelintConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "<init>"));
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull StylelintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "savePrivateSettings"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.getProject());
        propertiesComponent.setValue(NODE_INTERPRETER_REF, state.getInterpreterRef().getReferenceName());
        propertiesComponent.setValue(STYLELINT_PACKAGE_PATH, state.getStylelintPackagePath());
    }

    @Override
    @NotNull
    protected StylelintState loadPrivateSettings(@NotNull StylelintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "loadPrivateSettings"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.getProject());
        String interpreterRefName = propertiesComponent.getValue(NODE_INTERPRETER_REF);
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRefName == null ? this.getDefaultState().getInterpreterRef() : NodeJsInterpreterRef.create(interpreterRefName);
        String stylelintPackagePath = propertiesComponent.getValue(STYLELINT_PACKAGE_PATH, "");
        StylelintState stylelintState = new StylelintState(nodeJsInterpreterRef, stylelintPackagePath);
        if (stylelintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "loadPrivateSettings"));
        }
        return stylelintState;
    }

    @Override
    @Nullable
    protected Element toXml(@NotNull StylelintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "toXml"));
        }
        return null;
    }

    @Override
    @NotNull
    protected StylelintState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "fromXml"));
        }
        StylelintState stylelintState = this.getDefaultState();
        if (stylelintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "fromXml"));
        }
        return stylelintState;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (StylelintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "getInspectionClass"));
        }
        return StylelintInspection.class;
    }

    @Override
    @NotNull
    protected StylelintState getDefaultState() {
        StylelintState stylelintState = DEFAULT_STATE;
        if (stylelintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "getDefaultState"));
        }
        return stylelintState;
    }

    @Nullable
    public NodeJsLocalInterpreter getLocalInterpreter() {
        NodeJsInterpreterRef interpreterRef = this.loadInterpreterRef();
        return NodeJsLocalInterpreter.tryCast(interpreterRef.resolve(this.getProject()));
    }

    @NotNull
    private NodeJsInterpreterRef loadInterpreterRef() {
        String interpreterRefName = PropertiesComponent.getInstance((Project)this.getProject()).getValue(NODE_INTERPRETER_REF);
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRefName != null ? NodeJsInterpreterRef.create(interpreterRefName) : NodeJsInterpreterRef.createProjectRef();
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintConfiguration", "loadInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }
}

