/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.css.CssBundle;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintView
extends JSLinterBaseView<StylelintState> {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myStylelintPackageField;
    private final JPanel myCenterPanel;

    public StylelintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintView", "<init>"));
        }
        super(fullModeDialog);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myStylelintPackageField = this.createStylelintPackageField(project);
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent(CssBundle.message((String)"css.stylelint.view.node.path.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(CssBundle.message((String)"css.stylelint.view.stylelintPackage.label", (Object[])new Object[0]), (JComponent)this.myStylelintPackageField).getPanel();
        this.myCenterPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        this.myCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createStylelintPackageField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintView", "createStylelintPackageField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)CssBundle.message((String)"css.stylelint.view.stylelintPackage.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintView", "lambda$createStylelintPackageField$0"));
            }
            NodeJsInterpreter interpreter = this.myNodeInterpreterField.getInterpreter();
            List<String> dirs = JSLinterUtil.detectAllPackageDirs(project, "stylelint", NodeJsLocalInterpreter.tryCast(interpreter));
            Collections.sort(dirs);
            return dirs;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintView", "createStylelintPackageField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintView", "createCenterComponent"));
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
    }

    @Override
    @NotNull
    protected StylelintState getState() {
        StylelintState stylelintState = new StylelintState(this.myNodeInterpreterField.getInterpreterRef(), this.myStylelintPackageField.getText());
        if (stylelintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintView", "getState"));
        }
        return stylelintState;
    }

    @Override
    protected void setState(@NotNull StylelintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/css/linter/stylelint/StylelintView", "setState"));
        }
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myStylelintPackageField.setTextAndAddToHistory(state.getStylelintPackagePath());
    }
}

