/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6ExportDefaultReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6ExportDefaultReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (JSResolveUtil.isConstructorFunction(element) && element.getParent() instanceof JSClass) {
            element = element.getParent();
        }
        if (!(element instanceof ES6ExportDefaultAssignment)) {
            element = element.getParent();
        }
        if (!(element instanceof ES6ExportDefaultAssignment)) {
            return;
        }
        PsiElement container = TypeScriptPsiUtil.getTopLevelContainer(element);
        if (container == null) {
            return;
        }
        Collection fileReferences = ReferencesSearch.search((PsiElement)container).findAll();
        if (fileReferences.isEmpty()) {
            return;
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        for (PsiReference fileReference : fileReferences) {
            ES6ImportedBinding[] importedBindings;
            PsiElement importDeclaration;
            PsiElement fileReferenceElement = fileReference.getElement();
            if (!(fileReferenceElement instanceof ES6FromClause) || !((importDeclaration = fileReferenceElement.getParent()) instanceof ES6ImportDeclaration)) continue;
            for (ES6ImportedBinding importedBinding : importedBindings = ((ES6ImportDeclaration)importDeclaration).getImportedBindings()) {
                if (importedBinding.isNamespaceImport()) continue;
                ReferencesSearch.search((PsiElement)importedBinding, (SearchScope)scope).forEach(consumer);
            }
        }
    }
}

