/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class BowerCommandRun {
    private static final Logger LOG = Logger.getInstance(BowerCommandRun.class);
    private final OSProcessHandler myProcessHandler;

    public BowerCommandRun(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/bower/BowerCommandRun", "<init>"));
        }
        this.myProcessHandler = processHandler;
    }

    @NotNull
    public ProcessOutput captureOutput(long timeoutMillis) throws ExecutionException {
        final ProcessOutput output = new ProcessOutput();
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDERR) {
                    output.appendStderr(event.getText());
                } else if (outputType != ProcessOutputTypes.SYSTEM) {
                    output.appendStdout(event.getText());
                }
            }
        });
        this.myProcessHandler.startNotify();
        if (this.myProcessHandler.waitFor(timeoutMillis)) {
            int exitCode = this.myProcessHandler.getProcess().exitValue();
            output.setExitCode(exitCode);
            if (exitCode != 0) {
                throw new ExecutionException("Exit code of '" + this.myProcessHandler.getCommandLine() + "' is " + exitCode + ". Stdout:\n" + output.getStdout() + "\n\nstderr:\n" + output.getStderr());
            }
            String stdout = output.getStdout();
            if (StringUtil.isEmptyOrSpaces((String)stdout)) {
                throw new ExecutionException("Got empty stdout, exit code: 0, stderr:\n" + output.getStderr());
            }
        } else {
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, (long)1000L, (String)this.myProcessHandler.getCommandLine());
            output.setTimeout();
            throw new ExecutionException("Command '" + this.myProcessHandler.getCommandLine() + "' is timed out.");
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandRun", "captureOutput"));
        }
        return processOutput;
    }

    public void terminate() {
        LOG.info("Terminating " + this.myProcessHandler.getCommandLine());
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, (long)1000L, (String)this.myProcessHandler.getCommandLine());
    }
}

