/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptErrorConsoleFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new TypeScriptErrorFinder();
    private static final String PREFIX = ">> ";

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "<init>"));
        }
        this(project, baseDir == null ? null : baseDir.getAbsolutePath());
    }

    public TypeScriptErrorConsoleFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "<init>"));
        }
        super(project, baseDir);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parse"));
        }
        List list = FINDER.find(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parse"));
        }
        return list;
    }

    @Nullable
    private static FileHyperlinkRawData parse(@NotNull String line, char openBracketChar, char closeBracketChar) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parse"));
        }
        int startInd = 0;
        int length = line.length();
        while (startInd < length) {
            int lineStartInd;
            int ind;
            int openParenthesesInd = line.indexOf(openBracketChar, startInd);
            if (openParenthesesInd == -1) {
                return null;
            }
            startInd = openParenthesesInd + 1;
            for (ind = lineStartInd = openParenthesesInd + 1; ind < length && Character.isDigit(line.charAt(ind)); ++ind) {
            }
            int lineEndInd = ind;
            if (lineStartInd == lineEndInd || lineEndInd < length && line.charAt(lineEndInd) != ',') continue;
            for (ind = lineEndInd + 1; ind < length && Character.isWhitespace(line.charAt(ind)); ++ind) {
            }
            int columnStartInd = ind;
            while (ind < length && Character.isDigit(line.charAt(ind))) {
                ++ind;
            }
            int columnEndInd = ind;
            if (columnStartInd == columnEndInd || columnEndInd + 1 >= length || line.charAt(columnEndInd) != closeBracketChar || line.charAt(columnEndInd + 1) != ':') continue;
            return TypeScriptErrorConsoleFilter.create(line, lineStartInd, lineEndInd, columnStartInd, columnEndInd);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkRawData create(@NotNull String line, int lineStartInd, int lineEndInd, int columnStartInd, int columnEndInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "create"));
        }
        int pathStartOffset = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, 0);
        if (pathStartOffset == -1) {
            return null;
        }
        if (line.startsWith(PREFIX, pathStartOffset)) {
            pathStartOffset += PREFIX.length();
        }
        if (lineStartInd - 1 <= pathStartOffset) {
            return null;
        }
        String path = line.substring(pathStartOffset, lineStartInd - 1);
        try {
            int lineNumber = Integer.parseInt(line.substring(lineStartInd, lineEndInd));
            int columnNumber = Integer.parseInt(line.substring(columnStartInd, columnEndInd));
            return new FileHyperlinkRawData(path, lineNumber - 1, columnNumber - 1, pathStartOffset, columnEndInd + 1);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int indexOfNonWhitespace(@NotNull String str, int startInd) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "indexOfNonWhitespace"));
        }
        for (int i = startInd; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static List<FileHyperlinkRawData> parseWebpackError(@NotNull String line) {
        FileHyperlinkRawData data;
        char ch;
        int pathEndInd;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parseWebpackError"));
        }
        int length = line.length();
        int startInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, 0);
        if (startInd == -1 || length <= startInd + 1 || line.charAt(startInd) != '@' || line.charAt(startInd + 1) != ' ') {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parseWebpackError"));
            }
            return list;
        }
        int pathStartInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, startInd + 2);
        for (pathEndInd = length; pathEndInd > 0 && (Character.isDigit(ch = line.charAt(pathEndInd - 1)) || Character.isWhitespace(ch) || ch == ':' || ch == '-'); --pathEndInd) {
        }
        if (pathStartInd == -1 || pathEndInd <= pathStartInd) {
            List<FileHyperlinkRawData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parseWebpackError"));
            }
            return list;
        }
        List result = null;
        int i = pathEndInd;
        while (i < length && (data = TypeScriptErrorConsoleFilter.parseWebpackLink(line, pathStartInd, pathEndInd, i)) != null) {
            if (result == null) {
                result = new SmartList();
            }
            result.add(data);
            i = data.getHyperlinkEndInd();
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parseWebpackError"));
        }
        return list;
    }

    @Nullable
    public static FileHyperlinkRawData parseWebpackLink(@NotNull String line, int pathStartInd, int pathEndInd, int startWhitespaceInd) {
        int nextColumnInd;
        int columnStartInd;
        int columnEndInd;
        int lineEndInd;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter", "parseWebpackLink"));
        }
        int length = line.length();
        int lineStartInd = TypeScriptErrorConsoleFilter.indexOfNonWhitespace(line, startWhitespaceInd);
        if (lineStartInd == -1 || lineStartInd == startWhitespaceInd) {
            return null;
        }
        for (lineEndInd = lineStartInd; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
        }
        if (lineStartInd == lineEndInd) {
            return null;
        }
        if (lineEndInd == length || line.charAt(lineEndInd) != ':') {
            return null;
        }
        for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
        }
        if (columnStartInd == columnEndInd) {
            return null;
        }
        if (columnEndInd + 1 >= length || line.charAt(columnEndInd) != '-' && Character.isDigit(line.charAt(columnEndInd + 1))) {
            return null;
        }
        for (nextColumnInd = columnEndInd + 1; nextColumnInd < length && Character.isDigit(line.charAt(nextColumnInd)); ++nextColumnInd) {
        }
        int hyperlinkEndInd = nextColumnInd;
        if (hyperlinkEndInd < length && !Character.isWhitespace(line.charAt(hyperlinkEndInd))) {
            return null;
        }
        String path = StringUtil.replace((String)line.substring(pathStartInd, pathEndInd).trim(), (String)"/~/", (String)"/node_modules/");
        String lineStr = line.substring(lineStartInd, lineEndInd);
        String columnStr = line.substring(columnStartInd, columnEndInd);
        try {
            int lineNumber = Integer.parseInt(lineStr);
            int columnNumber = Integer.parseInt(columnStr);
            return new FileHyperlinkRawData(path, lineNumber - 1, columnNumber, pathEndInd == startWhitespaceInd ? pathStartInd : lineStartInd, hyperlinkEndInd);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class TypeScriptErrorFinder
    implements FileHyperlinkRawDataFinder {
        private TypeScriptErrorFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter$TypeScriptErrorFinder", "find"));
            }
            FileHyperlinkRawData data = TypeScriptErrorConsoleFilter.parse(line, '(', ')');
            if (data == null) {
                data = TypeScriptErrorConsoleFilter.parse(line, '[', ']');
            }
            if (data == null) {
                List list = TypeScriptErrorConsoleFilter.parseWebpackError(line);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter$TypeScriptErrorFinder", "find"));
                }
                return list;
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)data);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptErrorConsoleFilter$TypeScriptErrorFinder", "find"));
            }
            return list;
        }
    }
}

