/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.codeInsight;

import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRequireDirCall {
    private final String myRelativeDirPath;

    public NodeRequireDirCall(@NotNull String relativeDirPath) {
        if (relativeDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeDirPath", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "<init>"));
        }
        this.myRelativeDirPath = relativeDirPath;
    }

    @Nullable
    public VirtualFile resolveRequiredDir(@NotNull VirtualFile callerFile) {
        if (callerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerFile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "resolveRequiredDir"));
        }
        VirtualFile baseDir = callerFile;
        if (!baseDir.isDirectory()) {
            baseDir = baseDir.getParent();
        }
        if (baseDir == null) {
            return null;
        }
        File dir = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (dir.isDirectory()) {
            File requiredDir = new File(dir, this.myRelativeDirPath);
            if (requiredDir.isDirectory()) {
                return VfsUtil.findFileByIoFile((File)requiredDir, (boolean)false);
            }
            requiredDir = new File(this.myRelativeDirPath);
            if (requiredDir.isDirectory() && requiredDir.isAbsolute()) {
                return VfsUtil.findFileByIoFile((File)requiredDir, (boolean)false);
            }
        }
        return null;
    }

    @Nullable
    public static NodeRequireDirCall build(@NotNull JSCallExpression expr, @NotNull Set<String> requireDirVarNames) {
        String relativeDir;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "build"));
        }
        if (requireDirVarNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireDirVarNames", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "build"));
        }
        if (NodeRequireDirCall.isRequireDirCall(expr, requireDirVarNames) && (relativeDir = JSPsiUtil.getFirstArgumentAsString(expr.getArgumentList())) != null) {
            return new NodeRequireDirCall(relativeDir);
        }
        return null;
    }

    private static boolean isRequireDirCall(@NotNull JSCallExpression expr, @NotNull Set<String> requireDirVarNames) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "isRequireDirCall"));
        }
        if (requireDirVarNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireDirVarNames", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "isRequireDirCall"));
        }
        JSCallExpression callExpr = (JSCallExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSCallExpression.class);
        if (callExpr != null) {
            return NodeRequireDirCall.isRequireDirRequireCall(callExpr);
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSReferenceExpression.class);
        if (refExpr != null && refExpr.getQualifier() == null) {
            return requireDirVarNames.contains(refExpr.getReferenceName());
        }
        return false;
    }

    public static boolean isRequireDirRequireCall(@Nullable JSCallExpression expr) {
        if (expr != null && expr.isRequireCall()) {
            JSLiteralExpression argExpr = JSPsiUtil.getFirstArgumentAsStringLiteral(expr.getArgumentList());
            return argExpr != null && NodeRequireDirCall.isRequireDirLiteralValue(argExpr.getText());
        }
        return false;
    }

    public static boolean isRequireDirLiteralValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall", "isRequireDirLiteralValue"));
        }
        return StringUtil.isQuotedString((String)value) && value.regionMatches(1, "require-dir", 0, value.length() - 2);
    }
}

