/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.beforeRun.GulpBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunConfigurationEditor
extends SettingsEditor<GulpRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(GulpRunConfigurationEditor.class);
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myGulpfileTextFieldWithBrowseButton;
    private final TextFieldWithHistory myTasksField;
    private final RawCommandLineEditor myArguments;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final TextFieldWithHistoryWithBrowseButton myGulpPackageTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public GulpRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.myGulpfileTextFieldWithBrowseButton = GulpRunConfigurationEditor.createGulpfileFieldWithBrowseButton(project);
        this.myTasksField = this.createTasksField();
        this.myArguments = GulpRunConfigurationEditor.createArgumentsEditor();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GulpRunConfigurationEditor.createNodeOptionsEditor();
        this.myGulpPackageTextFieldWithBrowseButton = GulpRunConfigurationEditor.createGulpPackageDirTextFieldWithBrowseButton(project, this.myNodeInterpreterField, null);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"gulp.rc.gulpfile.label", (Object[])new Object[0]), (JComponent)this.myGulpfileTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"gulp.rc.tasks.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myTasksField)).addLabeledComponent(JSBundle.message((String)"gulp.rc.arguments.label", (Object[])new Object[0]), (JComponent)this.myArguments).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(JSBundle.message((String)"gulp.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField), 8).addLabeledComponent(JSBundle.message((String)"gulp.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"gulp.rc.gulpPackage.label", (Object[])new Object[0]), (JComponent)this.myGulpPackageTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"gulp.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    public static RawCommandLineEditor createArgumentsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Task Arguments");
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createArgumentsEditor"));
        }
        return rawCommandLineEditor;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createGulpPackageDirTextFieldWithBrowseButton(@NotNull Project project, @NotNull NodeJsInterpreterField interpreterField, @Nullable VirtualFile contextGulpfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createGulpPackageDirTextFieldWithBrowseButton"));
        }
        if (interpreterField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterField", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createGulpPackageDirTextFieldWithBrowseButton"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"gulp.rc.gulpPackage.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "lambda$createGulpPackageDirTextFieldWithBrowseButton$0"));
            }
            if (interpreterField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterField", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "lambda$createGulpPackageDirTextFieldWithBrowseButton$0"));
            }
            GulpNonSharedSettingsManager manager = GulpNonSharedSettingsManager.getInstance(project);
            List<String> gulpExePaths = manager.detectAllGulpPackageDirs(interpreterField.getInterpreter(), contextGulpfile);
            Collections.sort(gulpExePaths);
            return gulpExePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createGulpPackageDirTextFieldWithBrowseButton"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static RawCommandLineEditor createNodeOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Node Options");
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createNodeOptionsEditor"));
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createGulpfileFieldWithBrowseButton(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createGulpfileFieldWithBrowseButton"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"gulp.rc.gulpfile.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "lambda$createGulpfileFieldWithBrowseButton$1"));
            }
            List<VirtualFile> gulpfiles = GulpService.getInstance().detectAllBuildfiles(project);
            ArrayList gulpfilePaths = ContainerUtil.newArrayList();
            for (VirtualFile gulpfile : gulpfiles) {
                gulpfilePaths.add(FileUtil.toSystemDependentName((String)gulpfile.getPath()));
            }
            Collections.sort(gulpfilePaths);
            return gulpfilePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createGulpfileFieldWithBrowseButton"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private TextFieldWithHistory createTasksField() {
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        final Ref lastGulpfileRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                final VirtualFile gulpfile = LocalFileSystem.getInstance().findFileByPath(((TextFieldWithHistory)GulpRunConfigurationEditor.this.myGulpfileTextFieldWithBrowseButton.getChildComponent()).getText());
                if (gulpfile == null || !gulpfile.isValid() || gulpfile.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastGulpfileRef.set(null);
                    return;
                }
                if (gulpfile.equals(lastGulpfileRef.get())) {
                    return;
                }
                lastGulpfileRef.set((Object)gulpfile);
                GulpfileManager gulpfileManager = GulpfileManager.getInstance(GulpRunConfigurationEditor.this.myProject);
                GulpfileStructure structure = gulpfileManager.getCachedStructure(gulpfile);
                if (structure != null) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                } else {
                    gulpfileManager.fetchStructure(gulpfile, new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

                        public void consume(JsbtFileStructure structure) {
                            field.setHistory(JsbtUtil.encodeNames(structure.getTaskNames()));
                        }

                        public void consume(JsbtTaskFetchException e) {
                            SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                            LOG.warn("Cannot load gulp tasks for " + gulpfile.getPath(), (Throwable)e);
                        }
                    });
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createTasksField"));
        }
        return textFieldWithHistory;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(GulpRunConfiguration gulpRc) {
        this.resetEditorFrom(gulpRc.getRunSettings());
    }

    public void resetEditorFrom(GulpRunSettings runSettings) {
        NodeJsInterpreterRef interpreterRef = runSettings.getInterpreterRef();
        GulpNonSharedSettings nonSharedSettings = GulpNonSharedSettingsManager.getInstance(this.myProject).get(interpreterRef.resolve(this.myProject), runSettings.getGulpfile());
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myGulpPackageTextFieldWithBrowseButton.setTextAndAddToHistory(nonSharedSettings.getGulpPackageDirPath());
        this.myGulpfileTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getGulpfilePath());
        this.myTasksField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getTasks()));
        this.myArguments.setText(runSettings.getArguments());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor || dialogWrapper instanceof GulpBeforeRunTaskDialog) {
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGulpfileTextFieldWithBrowseButton);
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGulpPackageTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    protected void applyEditorTo(GulpRunConfiguration gulpRc) throws ConfigurationException {
        gulpRc.setRunSettings(this.getCurrentSettings());
    }

    @NotNull
    public GulpRunSettings getCurrentSettings() {
        GulpNonSharedSettingsManager.getInstance(this.myProject).set(((TextFieldWithHistory)this.myGulpPackageTextFieldWithBrowseButton.getChildComponent()).getText());
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setGulpfilePath(((TextFieldWithHistory)this.myGulpfileTextFieldWithBrowseButton.getChildComponent()).getText());
        List tasks = Collections.emptyList();
        String tasksText = this.myTasksField.getText();
        if (!StringUtil.isEmptyOrSpaces((String)tasksText)) {
            tasks = ParametersListUtil.parse((String)tasksText);
        }
        builder.setTasks(tasks);
        builder.setArguments(this.myArguments.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GulpRunSettings gulpRunSettings = builder.build();
        if (gulpRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationEditor", "getCurrentSettings"));
        }
        return gulpRunSettings;
    }
}

