/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum NpmCommand {
    ACCESS,
    ADD_USER("adduser"),
    BIN,
    BUGS,
    BUILD,
    CACHE,
    COMPLETION,
    CONFIG,
    DEDUPE,
    DEPRECATE,
    DIST_TAG("dist-tag"),
    DOCS,
    EDIT,
    EXPLORE,
    HELP,
    HELP_SEARCH("help-search"),
    INIT,
    INSTALL,
    LINK,
    LOGOUT,
    LS,
    NPM,
    OUTDATED,
    OWNER,
    PACK,
    PING,
    PREFIX,
    PRUNE,
    PUBLISH,
    REBUILD,
    REPO,
    RESTART,
    ROOT,
    RUN_SCRIPT("run-script"),
    SEARCH,
    SHRINKWRAP,
    STAR,
    STARS,
    START,
    STOP,
    TAG,
    TEAM,
    TEST,
    UNINSTALL,
    UNPUBLISH,
    UPDATE,
    VERSION,
    VIEW,
    WHOAMI;

    private final String myCliOption;

    private NpmCommand() {
        this.myCliOption = this.name().toLowerCase(Locale.ENGLISH);
    }

    private NpmCommand(String cliOption) {
        if (cliOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cliOption", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "<init>"));
        }
        this.myCliOption = cliOption;
    }

    @NotNull
    public String getCliOption() {
        String string = this.myCliOption;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmCommand", "getCliOption"));
        }
        return string;
    }

    @Nullable
    public static NpmCommand find(@Nullable String cliOption) {
        for (NpmCommand command : NpmCommand.values()) {
            if (!command.getCliOption().equals(cliOption)) continue;
            return command;
        }
        return null;
    }
}

