/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private static final String NODE_DEBUG_OPTION = "NODE_DEBUG_OPTION";
    private final NpmRunSettings myRunSettings;
    private final NodeJsLocalInterpreter myNodeInterpreter;
    private final ExecutionEnvironment myEnvironment;

    public NpmRunProfileState(@NotNull NpmRunSettings runSettings, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "<init>"));
        }
        this.myNodeInterpreter = runSettings.getInterpreterRef().resolveAsLocal(environment.getProject());
        this.myRunSettings = runSettings;
        this.myEnvironment = environment;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        ConsoleView console;
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, true);
        if (debugPort != -1) {
            this.checkTasksNotConfiguredForDebug((ProcessHandler)processHandler);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        if (debugPort != -1) {
            console = null;
        } else {
            console = this.createConsole(commandLine.getWorkDirectory());
            console.attachToProcess((ProcessHandler)processHandler);
            this.foldCommandLine(console, (ProcessHandler)processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "execute"));
        }
        return defaultExecutionResult;
    }

    private void checkTasksNotConfiguredForDebug(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "checkTasksNotConfiguredForDebug"));
        }
        final List<String> tasksNotConfiguredForDebug = this.findTasksNotConfiguredForDebug();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                for (String task : tasksNotConfiguredForDebug) {
                    String variableRefName = SystemInfo.isWindows ? "%NODE_DEBUG_OPTION%" : "$NODE_DEBUG_OPTION";
                    processHandler.notifyTextAvailable("\nTo debug the \"" + task + "\" script, make sure " + variableRefName + " string is specified as the first argument for the node command you'd like to debug.\nFor example:\n { \"start\": \"node " + variableRefName + " server.js\" }\n", ProcessOutputTypes.SYSTEM);
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            }
        });
    }

    @NotNull
    private List<String> findTasksNotConfiguredForDebug() {
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getPackageJsonSystemIndependentPath());
        ArrayList result = ContainerUtil.newArrayList();
        if (packageJson != null) {
            for (String scriptName : this.myRunSettings.getScriptNames()) {
                JsonValue value;
                String text;
                JsonProperty property = NpmScriptsUtil.findScriptProperty(this.myEnvironment.getProject(), packageJson, scriptName);
                if (property == null || (text = (value = property.getValue()) == null ? null : value.getText()) == null || text.contains(NODE_DEBUG_OPTION)) continue;
                result.add(scriptName);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "findTasksNotConfiguredForDebug"));
        }
        return arrayList;
    }

    @NotNull
    private ConsoleView createConsole(@Nullable File cwd) {
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(this.myEnvironment.getProject());
        builder.setUsePredefinedMessageFilter(false);
        builder.addFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject()));
        builder.addFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = builder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "createConsole"));
        }
        return consoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws ExecutionException {
        String arguments;
        String nodeOptions;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        File workingDirectory = new File(this.myRunSettings.getPackageJsonSystemDependentPath()).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.setExePath(this.myNodeInterpreter.getInterpreterSystemDependentPath());
        if (debugPort > 0) {
            commandLine.getEnvironment().put(NODE_DEBUG_OPTION, "--debug-brk=" + debugPort + " --expose_debug_as=v8debug");
        }
        if (StringUtil.isNotEmpty((String)(nodeOptions = this.myRunSettings.getNodeOptions().trim()))) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        commandLine.addParameter(this.myNodeInterpreter.getValidNpmCliJsFilePath(this.myEnvironment.getProject()));
        NpmCommand command = this.getExecutionCommand();
        commandLine.addParameter(command.getCliOption());
        if (command == NpmCommand.RUN_SCRIPT) {
            commandLine.addParameters(this.myRunSettings.getScriptNames());
        }
        if (!(arguments = this.myRunSettings.getArguments().trim()).isEmpty()) {
            if (command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST) {
                commandLine.addParameter("--");
            }
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private NpmCommand getExecutionCommand() {
        List<String> scripts;
        if (this.myRunSettings.getCommand() == NpmCommand.RUN_SCRIPT && (scripts = this.myRunSettings.getScriptNames()).size() == 1 && "test".equals(ContainerUtil.getFirstItem(scripts))) {
            NpmCommand npmCommand = NpmCommand.TEST;
            if (npmCommand == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "getExecutionCommand"));
            }
            return npmCommand;
        }
        NpmCommand npmCommand = this.myRunSettings.getCommand();
        if (npmCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "getExecutionCommand"));
        }
        return npmCommand;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "foldCommandLine"));
        }
        BaseOSProcessHandler osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class);
        if (osProcessHandler != null) {
            String arguments;
            ArrayList commandLine = ContainerUtil.newArrayList((Object[])new String[]{"npm"});
            NpmCommand command = this.getExecutionCommand();
            commandLine.add(command.getCliOption());
            if (command == NpmCommand.RUN_SCRIPT) {
                commandLine.addAll(this.myRunSettings.getScriptNames());
            }
            if (!(arguments = this.myRunSettings.getArguments().trim()).isEmpty()) {
                if (command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST) {
                    commandLine.add("--");
                }
                commandLine.add(arguments);
            }
            NpmRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)commandLine));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        if (foldedCommandLineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedCommandLineText", "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState", "doFoldCommandLine"));
        }
        final String commandLine = processHandler.getCommandLine();
        if (commandLine != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(ProcessEvent event) {
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }
                });
            }
        }
    }
}

