/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof JSVariable) {
            parent = parent.getParent();
        }
        assert (parent instanceof JSDestructuringProperty) : "must be filtered in JSPatternBasedCompletionContributor";
        JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)parent;
        CompletionResultSink sink = new CompletionResultSink((PsiElement)destructuringProperty);
        PsiFile file = destructuringProperty.getContainingFile();
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)destructuringProperty).createCompletionItemProcessor(sink, file);
        JSTypeEvaluator.evaluateExpressionOrElementTypes(file, localProcessor, (PsiElement)destructuringProperty, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        List<PsiElement> results = localProcessor.getResults();
        if (results != null && !results.isEmpty()) {
            for (PsiElement resultElement : results) {
                result.addElement((LookupElement)JSLookupUtilImpl.createLookupElement(resultElement));
            }
            return;
        }
        VariantsProcessor processor = new VariantsProcessor(file, (PsiElement)destructuringProperty, BaseJSSymbolProcessor.MatchMode.Strict, true);
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<? extends LookupElement> variantProcessorResults = processor.getCurrentResults();
        result.addAllElements(variantProcessorResults);
    }
}

