/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.settings.JSRootConfigurable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        FlowJSConfigService service;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/flow/FlowJSConfigInspection", "checkFile"));
        }
        if (FlowJSAnnotation.isFlowAnnotation(file) && (service = FlowJSConfigService.getService(file.getProject())) != null && service.getConfigOfFile(file.getVirtualFile()).isEmpty()) {
            ArrayList descriptors = ContainerUtil.newArrayList();
            LocalQuickFix[] fixes = new LocalQuickFix[]{new FlowJSConfigQuickFix(file.getProject().getBaseDir(), JSBundle.message((String)"js.flowjs.config.inspection.to.project.path.name", (Object[])new Object[0])), new FlowJSConfigQuickFix(file.getContainingDirectory().getVirtualFile(), JSBundle.message((String)"js.flowjs.config.inspection.to.current.path.name", (Object[])new Object[0]))};
            descriptors.add(manager.createProblemDescriptor((PsiElement)file, JSBundle.message((String)"js.flowjs.config.inspection.description.name", (Object[])new Object[0]), fixes, HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)this.getDefaultLevel().getSeverity()), true, false));
            return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    private class FlowJSConfigQuickFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final VirtualFile dir;
        @NotNull
        private final String name;

        public FlowJSConfigQuickFix(@NotNull VirtualFile dir, String name) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "<init>"));
            }
            this.dir = dir;
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.inspection.group.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "getFamilyName"));
            }
            return string;
        }

        private void createConfigFile() {
            File file = new File(this.dir.getPath() + File.separator + ".flowconfig");
            FileUtil.createIfDoesntExist((File)file);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSConfigInspection$FlowJSConfigQuickFix", "applyFix"));
            }
            List<String> flowExecutableFiles = FlowSettingsManager.calcPossibleFlowExecutableFiles(project);
            if (flowExecutableFiles.isEmpty()) {
                this.createConfigFile();
            } else {
                for (String path : flowExecutableFiles) {
                    if (!JSRootConfigurable.isFlowServerAvailable(path, project)) continue;
                    GeneralCommandLine line = new GeneralCommandLine();
                    line.setExePath(path);
                    line.addParameter("init");
                    line.setWorkDirectory(this.dir.getCanonicalPath());
                    try {
                        OSProcessHandler handler = new OSProcessHandler(line);
                        handler.startNotify();
                        if (handler.waitFor()) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{this.dir});
                        }
                        return;
                    }
                    catch (ExecutionException executionException) {
                    }
                }
                this.createConfigFile();
            }
        }
    }
}

