/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.FlowSettings;
import com.intellij.lang.javascript.flow.FlowSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSAutocompleteCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckContentsCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCoverageCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSFindModuleCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSGetDefinitionCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSTypeInfoCommand;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerService
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    public static final long SMALL_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final long MIDDLE_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    public static final long LARGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    @NotNull
    protected final Project myProject;
    @Nullable
    private JSLanguageService myService;
    @NotNull
    private Set<VirtualFile> myServerPaths;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;

    public FlowJSServerService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "<init>"));
        }
        this.myProject = project;
        this.myServerPaths = ContainerUtil.newHashSet();
        this.myToolWindowManager = this.createToolWindow(project);
        this.initToolWindow();
    }

    @Nullable
    public JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return FlowJSToolWindowProvider.getToolWindow(project);
    }

    private void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isEnabled()) {
                this.myToolWindowManager.init();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }, this.myProject.getDisposed()));
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed();
    }

    @NotNull
    protected JSLanguageServiceImpl createService(boolean useConfig) {
        JSLanguageServiceImpl jSLanguageServiceImpl = new JSLanguageServiceImpl(this.myProject, new FlowJSStandardOutputProtocol(this.myProject, useConfig), null, new JSLanguageServiceCacheData(){

            public void dispose() {
            }

            public int hashCode() {
                return FlowJSServerService.this.myProject.hashCode();
            }

            @Override
            @Nullable
            public <T> T getValueFromCache(@NotNull JSLanguageServiceCacheableCommand<T> input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/flow/FlowJSServerService$1", "getValueFromCache"));
                }
                return null;
            }

            @Override
            @Nullable
            public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/flow/FlowJSServerService$1", "updateCacheAndGetServiceObject"));
                }
                return new TypeScriptReloadProjectsCommand().toSerializableObject();
            }

            @Override
            public <T> void putCacheValue(@NotNull JSLanguageServiceCacheableCommand<T> input, @Nullable JSLanguageServiceAnswer answer, @Nullable T value) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/flow/FlowJSServerService$1", "putCacheValue"));
                }
            }

            @Override
            public void clear() {
            }
        });
        if (jSLanguageServiceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "createService"));
        }
        return jSLanguageServiceImpl;
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "getService"));
        }
        String flowPath = FlowSettingsManager.getInstance(project).getFlowSettings().getFlowExecutablePath();
        if (flowPath == null || flowPath.isEmpty()) {
            return null;
        }
        FlowJSServerService service = (FlowJSServerService)ServiceManager.getService((Project)project, FlowJSServerService.class);
        if (service == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(flowPath);
        JSLanguageServiceToolWindowManager flowJSToolWindowProvider = FlowJSToolWindowProvider.getToolWindow(project);
        if (virtualFile == null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (flowJSToolWindowProvider != null) {
                    ImmutableList<JSLanguageServiceAnnotationResult> results = JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0]));
                    flowJSToolWindowProvider.logProjectErrors(results, true);
                }
            });
            return null;
        }
        return service;
    }

    public void restartService() {
        if (this.myService != null) {
            Disposer.dispose((Disposable)this.myService);
        }
        this.myService = this.createService(true);
    }

    public <T> Future<T> sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandResultProcessor<T> processor, @NotNull FlowJSConfig config) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (this.myService == null) {
            this.restartService();
        }
        this.myServerPaths.add(config.getConfigDirectory());
        return this.myService.execute(command, processor);
    }

    @Nullable
    public FlowJSConfig getConfig(@NotNull VirtualFile file) {
        Collection<FlowJSConfig> configCollection;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getConfig"));
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        if (configService != null && (configCollection = configService.getConfigOfFile(file)).size() >= 1) {
            return this.getClosestConfig(configCollection, file);
        }
        return null;
    }

    private FlowJSConfig getClosestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file) {
        if (configCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configCollection", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        HashSet filePathElements = ContainerUtil.newHashSet();
        this.addAllElements(file, filePathElements);
        int diffForFile = Integer.MAX_VALUE;
        int diffForConfig = Integer.MAX_VALUE;
        FlowJSConfig closestConfig = (FlowJSConfig)ContainerUtil.getFirstItem(configCollection);
        for (FlowJSConfig config : configCollection) {
            HashSet configPathElements = ContainerUtil.newHashSet();
            this.addAllElements(config.getConfigDirectory(), configPathElements);
            HashSet configPathElementsCopy = ContainerUtil.newHashSet();
            configPathElementsCopy.addAll(configPathElements);
            HashSet filePathElementsCopy = ContainerUtil.newHashSet();
            filePathElementsCopy.addAll(filePathElements);
            filePathElementsCopy.removeAll(configPathElements);
            configPathElementsCopy.removeAll(filePathElements);
            if (diffForConfig == 0) {
                if (diffForFile <= filePathElementsCopy.size()) continue;
                diffForFile = filePathElementsCopy.size();
                closestConfig = config;
                continue;
            }
            long currentSum = diffForConfig + diffForFile;
            long tempSum = filePathElementsCopy.size() + configPathElementsCopy.size();
            if (configPathElementsCopy.size() != 0 && currentSum <= tempSum) continue;
            diffForConfig = configPathElementsCopy.size();
            diffForFile = filePathElementsCopy.size();
            closestConfig = config;
        }
        return closestConfig;
    }

    private void addAllElements(@NotNull VirtualFile file, Set<String> filePathElements) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "addAllElements"));
        }
        for (String element : file.getPath().split("/")) {
            if (element.equals("") || element.equals(file.getName())) continue;
            filePathElements.add(element);
        }
    }

    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        this.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        FlowJSGetDefinitionCommand commandWithArgument = new FlowJSGetDefinitionCommand(request, document.getText(), virtualFile.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromDefinitionCommandAnswer(requestAnswer, virtualFile);
    }

    @Nullable
    private PsiElement getPsiElementFromDefinitionCommandAnswer(@NotNull List<JsonObject> answer, @NotNull VirtualFile currentFile) {
        JsonElement path;
        JsonObject answerJson;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (!answer.isEmpty() && (answerJson = answer.get(0)) != null && !(path = answerJson.get("path")).getAsString().isEmpty()) {
            VirtualFile virtualFile;
            int startLine = answerJson.get("line").getAsInt() - 1;
            int startColumn = answerJson.get("start").getAsInt() - 1;
            if (startLine >= 0 && startColumn >= 0 && (virtualFile = !path.getAsString().equals("-") ? LocalFileSystem.getInstance().findFileByPath(path.getAsString()) : currentFile) != null) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
                try {
                    Document document = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile).getDocument();
                    if (document != null) {
                        int offset = document.getLineStartOffset(startLine) + startColumn;
                        if (psiFile != null) {
                            return psiFile.findElementAt(offset);
                        }
                    }
                }
                catch (NullPointerException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public PsiElement findModuleOfElement(@NotNull VirtualFile file, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        this.setCommandLineParams(request, config);
        request.add(StringUtil.unquoteString((String)element.getText()));
        request.add(file.getPath());
        FlowJSFindModuleCommand commandWithArgument = new FlowJSFindModuleCommand(request, null, file.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromFindModuleCommandAnswer(requestAnswer);
    }

    @Nullable
    private PsiElement getPsiElementFromFindModuleCommandAnswer(List<JsonObject> answerList) {
        JsonObject answer;
        if (!answerList.isEmpty() && (answer = answerList.get(0)).has("file")) {
            String path = answer.get("file").getAsString();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            }
        }
        return null;
    }

    public String getTypeOfElement(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull FlowJSConfig config) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        this.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        FlowJSTypeInfoCommand commandWithArgument = new FlowJSTypeInfoCommand(request, document.getText(), virtualFile.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, SMALL_TIMEOUT);
        return this.getTypeFromAnswer(requestAnswer);
    }

    @NotNull
    private String getTypeFromAnswer(List<JsonObject> answer) {
        JsonObject answerJson;
        String type = "";
        if (!answer.isEmpty() && (answerJson = answer.get(0)).has("type")) {
            type = answerJson.get("type").getAsString();
        }
        String string = type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeFromAnswer"));
        }
        return string;
    }

    private void setCommandLineParams(List<String> request, FlowJSConfig config) {
        request.add("--root");
        request.add(config.getConfigDirectory().getPath());
        request.add("--json");
    }

    @NotNull
    public List<JsonObject> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull FlowJSConfig config, @NotNull CompletionParameters parameters, @NotNull String text) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        this.setCommandLineParams(request, config);
        request.add(originalFile.getVirtualFile().getCanonicalPath());
        PsiDirectory directory = originalFile.getContainingDirectory();
        String filePath = directory != null ? directory.getVirtualFile().getPath() : originalFile.getProject().getBasePath();
        int line = document.getLineNumber(parameters.getOffset());
        request.add(String.valueOf(line + 1));
        request.add(String.valueOf(parameters.getOffset() - document.getLineStartOffset(line) + "IntellijIdeaRulezzz ".length()));
        FlowJSAutocompleteCommand commandWithArgument = new FlowJSAutocompleteCommand(request, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        return arrayList;
    }

    @NotNull
    public List<JsonObject> checkContentOfFile(@NotNull FlowJSConfig config, @NotNull String text, @NotNull String fileName, @NotNull String filePath) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        this.setCommandLineParams(parameterList, config);
        parameterList.add(fileName);
        FlowJSCheckContentsCommand commandWithArgument = new FlowJSCheckContentsCommand(parameterList, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        return arrayList;
    }

    public List<JSLanguageServiceAnnotationResult> getAllErrors() {
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        com.intellij.util.containers.HashSet allErrors = new com.intellij.util.containers.HashSet();
        if (configService != null) {
            Collection<FlowJSConfig> configFiles = configService.getConfigFiles();
            FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
            if (fileIndexFacade != null) {
                configFiles.forEach(arg_0 -> this.lambda$getAllErrors$8((Set)allErrors, arg_0));
            }
        }
        return new ArrayList<JSLanguageServiceAnnotationResult>((Collection<JSLanguageServiceAnnotationResult>)allErrors);
    }

    public static List<JSLanguageServiceAnnotationResult> parseFlowErrors(@NotNull JsonObject json, String filePath) {
        JsonElement hasErrors;
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseFlowErrors"));
        }
        ArrayList<JSLanguageServiceAnnotationResult> listOfErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        VirtualFile currentVirtualFile = null;
        if (filePath != null) {
            currentVirtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if ((hasErrors = json.get("passed")) != null && !hasErrors.getAsBoolean()) {
            try {
                JsonArray errorArray = json.getAsJsonArray("errors");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    int line = 0;
                    int column = 0;
                    int lineEnd = 0;
                    int columnEnd = 0;
                    StringBuilder errorText = new StringBuilder();
                    String localFilePath = null;
                    String errorCategory = errorObject.get("level").getAsString();
                    JsonArray messageArray = errorObject.getAsJsonArray("message");
                    boolean isFirst = true;
                    for (JsonElement message : messageArray) {
                        JsonObject messageObject = message.getAsJsonObject();
                        if (messageObject.get("type").getAsString().equals("Blame")) {
                            String currentFilePath = messageObject.get("path").getAsString();
                            if (currentFilePath == null) continue;
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(currentFilePath);
                            if (currentVirtualFile != null && currentVirtualFile.equals(virtualFile)) {
                                localFilePath = currentFilePath;
                                JsonObject loc = messageObject.get("loc").getAsJsonObject();
                                JsonObject start = loc.get("start").getAsJsonObject();
                                JsonObject end = loc.get("end").getAsJsonObject();
                                if (line == 0) {
                                    line = start.get("line").getAsInt();
                                    column = start.get("column").getAsInt();
                                    lineEnd = end.get("line").getAsInt();
                                    columnEnd = end.get("column").getAsInt();
                                }
                            }
                        }
                        if (isFirst) {
                            errorText.append("Flow: ");
                        }
                        errorText.append(messageObject.get("descr").getAsString());
                        if (!isFirst) {
                            errorText.append(" ");
                        }
                        if (!isFirst || messageArray.size() <= 1) continue;
                        errorText.append(". ");
                        isFirst = false;
                    }
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(errorText.toString(), localFilePath != null && !localFilePath.isEmpty() ? localFilePath : filePath, errorCategory, line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    private List<JSLanguageServiceAnnotationResult> getErrorsFromDir(@NotNull FlowJSConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getErrorsFromDir"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add("--json");
        FlowJSCheckCommand commandWithArgument = new FlowJSCheckCommand(parameterList, config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList<JSLanguageServiceAnnotationResult> errors = new ArrayList<JSLanguageServiceAnnotationResult>();
        if (requestAnswer.size() > 0) {
            errors.addAll(FlowJSServerService.parseFlowErrors((JsonObject)requestAnswer.get(0), null));
        }
        return errors;
    }

    public List<JSLanguageServiceAnnotationResult> getCoverageOfFile(@NotNull FlowJSConfig config, @NotNull PsiFile originalFile) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        this.setCommandLineParams(parameterList, config);
        parameterList.add(originalFile.getVirtualFile().getPath());
        FlowJSCoverageCommand commandWithArgument = new FlowJSCoverageCommand(parameterList, originalFile.getText(), config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList errors = ContainerUtil.newArrayList();
        if (!requestAnswer.isEmpty()) {
            errors.addAll(this.parseCoverageError((JsonObject)requestAnswer.get(0)));
        }
        return errors;
    }

    private List<JSLanguageServiceAnnotationResult> parseCoverageError(@NotNull JsonObject json) {
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseCoverageError"));
        }
        ArrayList listOfErrors = ContainerUtil.newArrayList();
        JsonElement expression = json.get("expressions");
        if (expression != null) {
            try {
                JsonArray errorArray = expression.getAsJsonObject().getAsJsonArray("uncovered_locs");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    String source = errorObject.get("source").getAsString();
                    JsonObject start = errorObject.get("start").getAsJsonObject();
                    JsonObject end = errorObject.get("end").getAsJsonObject();
                    int line = start.get("line").getAsInt();
                    int column = start.get("column").getAsInt();
                    int lineEnd = end.get("line").getAsInt();
                    int columnEnd = end.get("column").getAsInt();
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(JSBundle.message((String)"js.flowjs.coverage.inspection.error.text", (Object[])new Object[0]), source != null ? source : "", "Warning", line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    public static boolean awaitFuture(@NotNull Future<Boolean> future, long period) {
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/javascript/flow/FlowJSServerService", "awaitFuture"));
        }
        try {
            future.get(period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return future.isDone();
    }

    public void saveSyncAllUnsavedFiles() {
        Document[] unsavedDocuments = FileDocumentManager.getInstance().getUnsavedDocuments();
        if (unsavedDocuments.length > 0) {
            ApplicationManager.getApplication().invokeAndWait(() -> this.saveFiles(unsavedDocuments));
        }
    }

    private Document[] getFilesExceptThis(Document[] unsavedDocuments, Document myDocument) {
        HashSet allDocs = ContainerUtil.newHashSet();
        allDocs.addAll(Arrays.asList(unsavedDocuments));
        allDocs.remove(myDocument);
        return allDocs.toArray(new Document[0]);
    }

    private void saveFiles(Document[] unsavedDocuments) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (Document document : unsavedDocuments) {
            fileDocumentManager.saveDocument(document);
            psiDocumentManager.commitDocument(document);
        }
    }

    public void saveAsyncAllUnsavedFiles(@Nullable Runnable task, @Nullable Runnable restartService, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveAsyncAllUnsavedFiles"));
        }
        Document[] unsavedDocuments = this.getFilesExceptThis(FileDocumentManager.getInstance().getUnsavedDocuments(), document);
        if (unsavedDocuments.length > 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.saveFiles(unsavedDocuments);
                if (restartService != null) {
                    restartService.run();
                }
            });
        } else if (task != null) {
            task.run();
        }
    }

    public void dispose() {
        if (this.myService != null) {
            Disposer.dispose((Disposable)this.myService);
        }
        this.myServerPaths.forEach(this::stopFlowServer);
    }

    protected String getServiceExePath() {
        FlowSettings settings = FlowSettingsManager.getInstance(this.myProject).getFlowSettings();
        return settings.getFlowExecutablePath();
    }

    private void stopFlowServer(@NotNull VirtualFile directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/javascript/flow/FlowJSServerService", "stopFlowServer"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.getServiceExePath().isEmpty() || directory.getCanonicalPath() == null || directory.getCanonicalPath().isEmpty()) {
            return;
        }
        commandLine.setExePath(this.getServiceExePath());
        commandLine.withWorkDirectory(directory.getCanonicalPath());
        commandLine.addParameter("stop");
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$getAllErrors$8(Set allErrors, FlowJSConfig config) {
        allErrors.addAll(this.getErrorsFromDir(config));
    }
}

