/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public class FlowSettings {
    private final String myFlowPath;
    private final boolean isFlowResolveEnable;

    public FlowSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/flow/FlowSettings", "<init>"));
        }
        this.myFlowPath = FileUtil.toSystemIndependentName((String)builder.myFlowPath);
        this.isFlowResolveEnable = builder.isFlowResolveEnable;
    }

    public Builder createBuilder() {
        return new Builder().setFlowExecutablePath(this.myFlowPath).setFlowResolveEnable(this.isFlowResolveEnable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowSettings settings = (FlowSettings)o;
        if (!this.myFlowPath.equals(settings.myFlowPath)) {
            return false;
        }
        return this.isFlowResolveEnable == settings.isFlowResolveEnable;
    }

    public int hashCode() {
        int result = this.myFlowPath.hashCode();
        result = 31 * result + (this.isFlowResolveEnable ? 1 : 0);
        return result;
    }

    public String toString() {
        return "FlowSettings{myFlowPath='" + this.myFlowPath + '\'' + '}';
    }

    public String getFlowExecutablePath() {
        return this.myFlowPath;
    }

    public boolean getFlowResolveEnable() {
        return this.isFlowResolveEnable;
    }

    public static class Builder {
        private String myFlowPath = "";
        private boolean isFlowResolveEnable = false;

        @NotNull
        public Builder setFlowExecutablePath(@NotNull String flowPath) {
            if (flowPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowPath", "com/intellij/lang/javascript/flow/FlowSettings$Builder", "setFlowExecutablePath"));
            }
            this.myFlowPath = flowPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowSettings$Builder", "setFlowExecutablePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setFlowResolveEnable(boolean isFlowResolveEnable) {
            this.isFlowResolveEnable = isFlowResolveEnable;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowSettings$Builder", "setFlowResolveEnable"));
            }
            return builder;
        }

        @NotNull
        public FlowSettings build() {
            FlowSettings flowSettings = new FlowSettings(this);
            if (flowSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowSettings$Builder", "build"));
            }
            return flowSettings;
        }
    }
}

