/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowJSConfigService {
    @Nullable
    public static FlowJSConfigService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigService", "getService"));
        }
        return (FlowJSConfigService)ServiceManager.getService((Project)project, FlowJSConfigService.class);
    }

    @NotNull
    public static Collection<FlowJSConfig> getFileConfig(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigService", "getFileConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigService", "getFileConfig"));
        }
        FlowJSConfigService service = FlowJSConfigService.getService(project);
        Collection<Object> fileConfigCollection = ContainerUtil.emptyList();
        if (service != null) {
            fileConfigCollection = service.getConfigOfFile(file);
        }
        List list = fileConfigCollection;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigService", "getFileConfig"));
        }
        return list;
    }

    @Nullable
    public static Collection<FlowJSConfig> getConfigFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigService", "getConfigFiles"));
        }
        FlowJSConfigService service = FlowJSConfigService.getService(project);
        Collection<Object> configCollection = ContainerUtil.emptyList();
        if (service != null) {
            configCollection = service.getConfigFiles();
        }
        return configCollection;
    }

    @NotNull
    public Collection<FlowJSConfig> getConfigOfFile(@NotNull VirtualFile var1);

    @NotNull
    public Collection<FlowJSConfig> getConfigFiles();
}

