/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.ECMA4CodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCodeStyleSettings
extends CustomCodeStyleSettings {
    public int INDENT_PACKAGE_CHILDREN = 0;
    public boolean USE_SEMICOLON_AFTER_STATEMENT = true;
    public boolean SPACE_BEFORE_TYPE_COLON = false;
    public boolean SPACE_AFTER_TYPE_COLON = true;
    public static final String OLD_SPACES_NEAR_TYPE_FIELD = "SPACES_NEAR_TYPE";
    public static final int OLD_BOTH_SPACES = 1;
    public static final int OLD_SPACE_BEFORE_TYPE = 2;
    public static final int OLD_SPACE_BEFORE_TYPE_COLON = 3;
    public String FIELD_PREFIX = "_";
    public String PROPERTY_PREFIX = "";
    public static final int DO_NOT_INDENT = 0;
    public static final int INDENT = 1;
    public boolean SPACE_BEFORE_PROPERTY_COLON = false;
    public boolean SPACE_AFTER_PROPERTY_COLON = true;
    public int ALIGN_OBJECT_PROPERTIES = 0;
    public static final int DO_NOT_ALIGN = 0;
    public static final int ALIGN_ON_VALUE = 1;
    public static final int ALIGN_ON_COLON = 2;
    public boolean SPACE_AFTER_DOTS_IN_REST_PARAMETER = false;
    public boolean SPACE_BEFORE_FUNCTION_LEFT_PARENTH = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean REFORMAT_C_STYLE_COMMENTS = true;
    public boolean USE_PUBLIC_MODIFIER = false;
    public boolean ALIGN_MULTILINE_VAR_DECLARATION = false;
    public boolean ALIGN_MULTIPLE_ASSIGNMENTS = false;
    public boolean USE_DOUBLE_QUOTES = true;
    public boolean COMMA_ON_NEW_LINE = false;
    public int OBJECT_LITERAL_WRAP = 5;
    public int IMPORTS_WRAP = 5;
    public boolean SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
    public boolean SPACES_WITHIN_IMPORTS = false;
    public boolean INDENT_CHAINED_CALLS = true;
    public boolean USE_CHAINED_CALLS_GROUP_INDENTS = false;
    public boolean CHAINED_CALL_DOT_ON_NEW_LINE = true;
    public boolean SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;

    protected JSCodeStyleSettings(CodeStyleSettings container) {
        super("JSCodeStyleSettings", container);
    }

    protected JSCodeStyleSettings(String tagName, CodeStyleSettings container) {
        super(tagName, container);
    }

    public static String getSemicolon(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings", "getSemicolon"));
        }
        return JSCodeStyleSettings.getSettings((PsiFile)file, (Project)file.getProject()).USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
    }

    public static JSCodeStyleSettings getSettings(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings", "getSettings"));
        }
        PsiFile file = element.getContainingFile();
        return JSCodeStyleSettings.getSettings(file, file.getProject());
    }

    public static JSCodeStyleSettings getSettings(@Nullable PsiFile file, Project project) {
        DialectOptionHolder holder;
        Class<JSCodeStyleSettings> codeStyleSettingsClass = JSCodeStyleSettings.class;
        if (file instanceof JSFile && (holder = DialectDetector.dialectOfFile(file)) != null) {
            if (holder.isECMA4) {
                codeStyleSettingsClass = ECMA4CodeStyleSettings.class;
            }
            if (holder.isTypeScript) {
                codeStyleSettingsClass = TypeScriptCodeStyleSettings.class;
            }
        }
        return (JSCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCustomSettings(codeStyleSettingsClass);
    }

    @NotNull
    public static CommonCodeStyleSettings getCommonSettings(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings", "getCommonSettings"));
        }
        Project project = element.getProject();
        Language language = DialectDetector.languageOfElement(element);
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings", "getCommonSettings"));
        }
        return commonCodeStyleSettings;
    }

    public static Class<? extends JSCodeStyleSettings> getSettingsClass(@Nullable Language dialect) {
        Class<JSCodeStyleSettings> codeStyleSettingsClass = JSCodeStyleSettings.class;
        if (dialect != null) {
            if (JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(dialect)) {
                codeStyleSettingsClass = ECMA4CodeStyleSettings.class;
            }
            if (JavaScriptSupportLoader.TYPESCRIPT.is(dialect)) {
                codeStyleSettingsClass = TypeScriptCodeStyleSettings.class;
            }
        }
        return codeStyleSettingsClass;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        parentElement = parentElement.getChild(this.getTagName());
        if (parentElement != null) {
            int spacesNearTypeValue = -1;
            for (Object o : parentElement.getChildren("option")) {
                Element e = (Element)o;
                String fieldName = e.getAttributeValue("name");
                if ("SPACE_BEFORE_TYPE_COLON".equals(fieldName) || "SPACE_AFTER_TYPE_COLON".equals(fieldName)) {
                    return;
                }
                if (!OLD_SPACES_NEAR_TYPE_FIELD.equals(fieldName)) continue;
                String value = e.getAttributeValue("value");
                spacesNearTypeValue = Integer.parseInt(value);
            }
            if (spacesNearTypeValue >= 0) {
                this.SPACE_BEFORE_TYPE_COLON = spacesNearTypeValue == 1 || spacesNearTypeValue == 3;
                this.SPACE_AFTER_TYPE_COLON = spacesNearTypeValue == 1 || spacesNearTypeValue == 2;
            }
        }
    }

    public static String getQuote(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/formatter/JSCodeStyleSettings", "getQuote"));
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        return settings.USE_DOUBLE_QUOTES ? "\"" : "'";
    }
}

