/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSGenerateHandler
implements LanguageCodeInsightActionHandler {
    private boolean mySkipMemberChooserDialog = false;

    public void setSkipMemberChooserDialog(boolean skipMemberChooserDialog) {
        this.mySkipMemberChooserDialog = skipMemberChooserDialog;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<Object> selectedElements;
        JSClass jsClass;
        block17: {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/BaseJSGenerateHandler", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/generation/BaseJSGenerateHandler", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/generation/BaseJSGenerateHandler", "invoke"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            jsClass = BaseJSGenerateHandler.findClass(file, editor);
            if (jsClass == null) {
                return;
            }
            if (this.collectCandidatesAndShowDialog()) {
                ArrayList<JSNamedElementNode> candidates = new ArrayList<JSNamedElementNode>();
                this.collectCandidates(jsClass, candidates);
                if (candidates.isEmpty()) {
                    if (this.canHaveEmptySelectedElements()) {
                        selectedElements = Collections.emptyList();
                        break block17;
                    } else {
                        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            HintManager.getInstance().showErrorHint(editor, this.getNoCandidatesMessage());
                        }
                        return;
                    }
                }
                boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
                if (unitTestMode) {
                    Iterator i = candidates.iterator();
                    while (i.hasNext()) {
                        JSNamedElementNode next = (JSNamedElementNode)((Object)i.next());
                        PsiElement psiElement = ((JSNamedElementNode)next.getParentNodeDelegate()).getPsiElement();
                        if (!(psiElement instanceof JSClass) || !"Object".equals(((JSClass)psiElement).getQualifiedName())) continue;
                        i.remove();
                    }
                }
                if (this.mySkipMemberChooserDialog || unitTestMode) {
                    selectedElements = candidates;
                } else {
                    MemberChooser<JSNamedElementNode> chooser = this.createMemberChooserDialog(project, jsClass, candidates, this.canHaveEmptySelectedElements(), true, JSBundle.message((String)this.getTitleKey(), (Object[])new Object[0]));
                    chooser.show();
                    if (chooser.getExitCode() != 0) {
                        return;
                    }
                    List<Object> selected = chooser.getSelectedElements();
                    selectedElements = selected == null ? Collections.emptyList() : selected;
                }
            } else {
                selectedElements = Collections.emptyList();
            }
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        BaseCreateMethodsFix createMethodsFix = this.createFix(jsClass);
        this.doInvoke(project, editor, file, selectedElements, createMethodsFix);
    }

    protected void doInvoke(final Project project, final Editor editor, final PsiFile file, final Collection<JSNamedElementNode> selectedElements, final BaseCreateMethodsFix<JSNamedElement> createMethodsFix) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (JSNamedElementNode el : selectedElements) {
                    createMethodsFix.addElementToProcess((JSNamedElement)el.getPsiElement());
                }
                createMethodsFix.beforeInvoke(project, editor, file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            createMethodsFix.invoke(project, editor, file);
                        }
                        catch (IncorrectOperationException ex) {
                            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        };
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), null);
        } else {
            runnable.run();
        }
    }

    protected MemberChooser<JSNamedElementNode> createMemberChooserDialog(Project project, final JSClass jsClass, final Collection<JSNamedElementNode> candidates, final boolean allowEmptySelection, boolean allowMultipleSelection, String title) {
        MemberChooser<JSNamedElementNode> chooser = new MemberChooser<JSNamedElementNode>(candidates.toArray(new JSNamedElementNode[candidates.size()]), allowEmptySelection, allowMultipleSelection, project, false){

            protected void init() {
                super.init();
                if (!allowEmptySelection) {
                    this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            this.setOKActionEnabled(myTree.getSelectionCount() > 0);
                        }
                    });
                } else {
                    this.setOKActionEnabled(true);
                }
            }

            protected JComponent createCenterPanel() {
                JComponent superComponent = super.createCenterPanel();
                JComponent optionsComponent = BaseJSGenerateHandler.this.getOptionsComponent(jsClass, candidates);
                if (optionsComponent == null) {
                    return superComponent;
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)superComponent, "Center");
                panel.add((Component)optionsComponent, "South");
                return panel;
            }
        };
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        return chooser;
    }

    @Nullable
    protected JComponent getOptionsComponent(JSClass jsClass, Collection<JSNamedElementNode> candidates) {
        return null;
    }

    protected boolean canHaveEmptySelectedElements() {
        return false;
    }

    @Nullable
    public static JSClass findClass(PsiFile file, Editor editor) {
        if (file instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
        }
        if (!(file instanceof JSFile)) {
            return null;
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        if (at == null) {
            return null;
        }
        Object clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)at, JSClass.class);
        if (clazz == null) {
            PsiFile containingFile = at.getContainingFile();
            PsiElement element = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)containingFile);
            if (element instanceof JSClass) {
                clazz = (JSClass)element;
            }
        } else if (JSResolveUtil.isArtificialClassUsedForReferenceList(clazz)) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)clazz);
            clazz = context != null && context.getContainingFile() instanceof XmlFile ? XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)context.getContainingFile()) : null;
        }
        return clazz;
    }

    @NonNls
    protected abstract String getTitleKey();

    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.candidates", (Object[])new Object[0]);
    }

    protected abstract BaseCreateMethodsFix createFix(JSClass var1);

    protected boolean collectCandidatesAndShowDialog() {
        return true;
    }

    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
    }

    protected static void collectJSVariables(JSClass clazz, Collection<JSNamedElementNode> candidates, final boolean skipThatHaveGetters, final boolean skipThatHaveSetters, final boolean skipStatics, final boolean skipConstructorParameters) {
        final HashMap<String, JSPsiNamedElementBase> candidatesMap = new HashMap<String, JSPsiNamedElementBase>();
        final ArrayList constructorParameters = new ArrayList();
        final JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)clazz.getProject()).getCustomSettings(JSCodeStyleSettings.class);
        ResolveProcessor processor = new ResolveProcessor(null){
            {
                super(arg0);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                JSAttributeList attributeList;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/generation/BaseJSGenerateHandler$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/generation/BaseJSGenerateHandler$3", "execute"));
                }
                JSPsiNamedElementBase namedElement = (JSPsiNamedElementBase)element;
                if (skipStatics && element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    return true;
                }
                if (!(element instanceof JSVariable)) {
                    if (element instanceof JSFunction) {
                        JSFunction function = (JSFunction)element;
                        if (skipThatHaveGetters && function.isGetProperty() || skipThatHaveSetters && function.isSetProperty()) {
                            candidatesMap.put(function.getName(), function);
                        } else if (!skipConstructorParameters && function.isConstructor()) {
                            JSParameter[] parameters;
                            for (JSParameter parameter : parameters = function.getParameterVariables()) {
                                constructorParameters.add(parameter);
                            }
                        }
                    }
                    return true;
                }
                if (((JSVariable)element).isConst()) {
                    return true;
                }
                String name = namedElement.getName();
                String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                if (!candidatesMap.containsKey(accessorName)) {
                    candidatesMap.put(accessorName, namedElement);
                }
                return true;
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        if (!skipConstructorParameters) {
            for (JSPsiNamedElementBase parameter : constructorParameters) {
                String name = parameter.getName();
                String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                if (candidatesMap.containsKey(accessorName)) continue;
                candidatesMap.put(accessorName, parameter);
            }
        }
        for (JSPsiNamedElementBase n : candidatesMap.values()) {
            if (!(n instanceof JSVariable)) continue;
            candidates.add(new JSNamedElementNode(n));
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        JSClass jsClass = BaseJSGenerateHandler.findClass(file, editor);
        return jsClass != null && !jsClass.isInterface();
    }
}

