/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamespaceEvaluationResult
extends JSSymbolNamespaceImpl {
    @Nullable
    final JSElement mySource;
    private final boolean myInheritsFunction;

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, @Nullable JSElement source) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "<init>"));
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, false, source);
    }

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, boolean inheritsFunction, @Nullable JSElement source) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "<init>"));
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, false, inheritsFunction, source);
    }

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, boolean isLocal, boolean inheritsFunction, @Nullable JSElement source) {
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "<init>"));
        }
        super(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, isLocal);
        this.mySource = source;
        this.myInheritsFunction = inheritsFunction;
    }

    @Nullable
    public static JSNamespaceEvaluationResult fromType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if ((type = JSTypeUtils.getNamedType(type)) == null) {
            return null;
        }
        String typeText = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (typeText == null) {
            return null;
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(typeText);
        JSTypeContext typeContext = ((JSNamedType)type).getTypeContext();
        JSContext context = typeContext.toJSContext();
        boolean isDeclaration = typeContext != JSTypeContext.INSTANCE;
        PsiElement element = type.getSource().getSourceElement();
        JSElement source = element instanceof JSElement ? (JSElement)element : null;
        return new JSNamespaceEvaluationResult((JSQualifiedName)name, context, type.getSource().isExplicitlyDeclared(), isDeclaration, source);
    }

    @Nullable
    public static JSNamespaceEvaluationResult buildProvidedNamespace(@NotNull JSElementBase element, boolean isExplicitlyDeclared, @Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        JSQualifiedName qName;
        JSNamespace ns;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "buildProvidedNamespace"));
        }
        String name = element.getName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        Object object = ns = visited != null && element instanceof JSDefinitionExpressionImpl ? ((JSDefinitionExpressionImpl)element).calculateSymbolNamespace(visited) : element.getJSNamespace();
        if ("prototype".equals(name)) {
            qName = ns.getQualifiedName();
            jsContext = JSContext.INSTANCE;
        } else {
            qName = JSQualifiedNameImpl.create(name, ns.getQualifiedName());
            jsContext = JSContext.STATIC;
        }
        return new JSNamespaceEvaluationResult(qName, jsContext, ns.isExplicitlyDeclared() && isExplicitlyDeclared, true, ns.isLocal(), false, element instanceof JSElement ? (JSElement)element : null);
    }

    @Nullable
    public JSElement getSource() {
        return this.mySource;
    }

    @Override
    @NotNull
    public JSType toType(@NotNull PsiElement defaultSource) {
        if (defaultSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSource", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "toType"));
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)(this.mySource != null ? this.mySource : defaultSource), this.isExplicitlyDeclared());
        JSQualifiedName name = this.getQualifiedName();
        JSGlobalTypeImpl jSGlobalTypeImpl = name == null ? new JSGlobalTypeImpl(typeSource) : (this.myInheritsFunction ? JSNamedType.createFunctionBasedType(name.getQualifiedName(), typeSource, JSTypeContext.fromJSContext(this.getJSContext())) : JSNamedType.createType(name.getQualifiedName(), typeSource, this.getJSContext()));
        if (jSGlobalTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "toType"));
        }
        return jSGlobalTypeImpl;
    }

    @NotNull
    public JSNamespaceEvaluationResult withExplicitlyDeclared(boolean explicitlyDeclared) {
        JSNamespaceEvaluationResult jSNamespaceEvaluationResult = explicitlyDeclared == this.isExplicitlyDeclared() ? this : new JSNamespaceEvaluationResult(this.getQualifiedName(), this.getJSContext(), explicitlyDeclared, this.isDeclaration(), this.getSource());
        if (jSNamespaceEvaluationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "withExplicitlyDeclared"));
        }
        return jSNamespaceEvaluationResult;
    }

    @NotNull
    public JSNamespaceEvaluationResult withJSContext(@NotNull JSContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "withJSContext"));
        }
        JSNamespaceEvaluationResult jSNamespaceEvaluationResult = context == this.getJSContext() ? this : new JSNamespaceEvaluationResult(this.getQualifiedName(), context, this.isExplicitlyDeclared(), this.isDeclaration(), this.getSource());
        if (jSNamespaceEvaluationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult", "withJSContext"));
        }
        return jSNamespaceEvaluationResult;
    }

    @Nullable
    public static String getQualifiedName(@Nullable JSNamespaceEvaluationResult ns) {
        if (ns == null) {
            return null;
        }
        JSQualifiedName qName = ns.getQualifiedName();
        return qName != null ? qName.getQualifiedName() : null;
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }
}

