/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.ES6ImportIndex;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.modules.TypeScriptSimpleModuleReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathsResolver {
    private static final String[] INDEX_FILES = new String[]{"index.ts", "index.d.ts", "index.tsx"};
    public static final Key<ParameterizedCachedValue<VirtualFile[], PsiFile>> CACHED_VALUE_KEY = Key.create((String)"cache.es6.include");
    private final ParameterizedCachedValueProvider<VirtualFile[], PsiFile> myCacheProvider = new ParameterizedCachedValueProvider<VirtualFile[], PsiFile>(){

        public CachedValueProvider.Result<VirtualFile[]> compute(PsiFile psiFile) {
            PsiDirectory parent;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Object[] directIncludes = TypeScriptImportPathsResolver.this.getIncludingFilesImpl(psiFile.getName(), virtualFile);
            boolean isIndex = ArrayUtil.contains((String)psiFile.getName(), (String[])INDEX_FILES);
            ArrayList<Object> deps = new ArrayList<Object>(directIncludes.length);
            if (isIndex && (parent = psiFile.getParent()) != null) {
                Object[] additionalIncludes = TypeScriptImportPathsResolver.this.getIncludingFilesImpl(parent.getName(), psiFile.getVirtualFile());
                directIncludes = (VirtualFile[])ArrayUtil.mergeArrays((Object[])directIncludes, (Object[])additionalIncludes);
                if (additionalIncludes.length > 0) {
                    deps.add(parent);
                }
            }
            ContainerUtil.addAll(deps, (Object[])directIncludes);
            deps.add(psiFile);
            deps.add(VirtualFileManager.getInstance());
            return CachedValueProvider.Result.create((Object)directIncludes, deps);
        }
    };
    private final Project myProject;
    private final PsiFileFactory myPsiFileFactory;
    private PsiManager myPsiManager;

    public static TypeScriptImportPathsResolver getInstance(Project project) {
        return (TypeScriptImportPathsResolver)ServiceManager.getService((Project)project, TypeScriptImportPathsResolver.class);
    }

    public TypeScriptImportPathsResolver(Project project, PsiFileFactory psiFileFactory, PsiManager psiManager) {
        this.myProject = project;
        this.myPsiFileFactory = psiFileFactory;
        this.myPsiManager = psiManager;
    }

    @Nullable
    protected PsiFileSystemItem resolveIncludedFile(@NotNull ES6ImportIndex.ImportInfo info, @NotNull PsiFile context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "resolveIncludedFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "resolveIncludedFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String path = info.getPath();
        final boolean hasExtension = JSFileReference.findExtension(path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null;
        PsiFileImpl psiFile = (PsiFileImpl)this.myPsiFileFactory.createFileFromText("dummy.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)path);
        psiFile.setOriginalFile(context);
        return new FileReferenceSet((PsiElement)psiFile){

            public FileReference createFileReference(TextRange range, int index, String text) {
                return hasExtension ? super.createFileReference(range, index, text) : new TypeScriptSimpleModuleReference(text, index, range, this){

                    @Override
                    protected ResolveResult resolveDirectory(@NotNull PsiDirectory element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver$2$1", "resolveDirectory"));
                        }
                        PsiFile indexFile = ES6PsiUtil.findIndexFile(TypeScriptUtil.TYPESCRIPT_EXTENSIONS, element);
                        if (indexFile != null) {
                            return new JSResolveResult((PsiElement)indexFile);
                        }
                        return super.resolveDirectory(element);
                    }
                };
            }

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        }.resolve();
    }

    public VirtualFile[] getIncludingFiles(@NotNull VirtualFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/index/TypeScriptImportPathsResolver", "getIncludingFiles"));
        }
        PsiFile file = this.myPsiManager.findFile(context);
        if (file == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return (VirtualFile[])CachedValuesManager.getManager((Project)this.myProject).getParameterizedCachedValue((UserDataHolder)file, CACHED_VALUE_KEY, this.myCacheProvider, false, (Object)file);
    }

    private VirtualFile[] getIncludingFilesImpl(String name, @Nullable VirtualFile context) {
        if (context == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        String nameWithoutExtension = TypeScriptUtil.getFileNameWithoutExtension(name);
        MultiMap<VirtualFile, ES6ImportIndex.ImportInfo> infoList = ES6ImportIndex.getIncludingFileCandidates(nameWithoutExtension, GlobalSearchScope.allScope((Project)this.myProject));
        if (infoList.isEmpty()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile candidate : infoList.keySet()) {
            PsiFile candidatePsiFile;
            if (context.equals(candidate) || (candidatePsiFile = this.myPsiManager.findFile(candidate)) == null) continue;
            for (ES6ImportIndex.ImportInfo info : infoList.get((Object)candidate)) {
                PsiFileSystemItem item = this.resolveIncludedFile(info, candidatePsiFile);
                if (item == null || !context.equals(item.getVirtualFile())) continue;
                result.add(candidate);
            }
        }
        return (VirtualFile[])result.stream().toArray(VirtualFile[]::new);
    }
}

