/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSStringConcatenationToES6TemplateQuickFix;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class JSStringConcatenationToES6TemplateInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                super.visitJSBinaryExpression(node);
                this.installFix((JSExpression)node);
            }

            private void installFix(JSExpression node) {
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                if (new JSStringConcatenationToES6TemplateHelper.ExpressionIterator(true).iterateBinaryExpression(node)) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.replace.string.concatenation.with.es6.template.inspection.name", (Object[])new Object[0]), new LocalQuickFix[]{new JSStringConcatenationToES6TemplateQuickFix(node)});
                }
            }

            public void visitJSConditionalExpression(JSConditionalExpression node) {
                super.visitJSConditionalExpression(node);
                this.installFix((JSExpression)node);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

