/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportsWorker {
    public static final String DEFAULT = "default";

    @Nullable
    public static Trinity<String, PsiElement, ES6ImportDeclaration> getExistingImport(@NotNull PsiElement scope, @NotNull String from, @Nullable String specifier) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImport"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImport"));
        }
        Collection elements = PsiTreeUtil.findChildrenOfType((PsiElement)scope, ES6ImportDeclaration.class);
        for (ES6ImportDeclaration element : elements) {
            String source;
            if (element.getFromClause() == null || element.getFromClause().getReferenceText() == null || !from.equals(source = StringUtil.unquoteString((String)element.getFromClause().getReferenceText()))) continue;
            boolean isDefault = DEFAULT.equals(specifier);
            if (specifier != null && !isDefault) {
                ES6ImportSpecifier[] specifiers;
                for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
                    if (!specifier.equals(importSpecifier.getReferenceName())) continue;
                    if (importSpecifier.getAlias() != null) {
                        return Trinity.create((Object)importSpecifier.getAlias().getName(), (Object)importSpecifier.getAlias(), (Object)element);
                    }
                    return Trinity.create((Object)importSpecifier.getReferenceName(), (Object)importSpecifier, (Object)element);
                }
                Trinity<String, PsiElement, ES6ImportDeclaration> binding = ES6ImportsWorker.getImportedBinding(element, isDefault);
                if (binding != null) {
                    return binding;
                }
                if (specifiers.length > 0) {
                    return Trinity.create(null, null, (Object)element);
                }
            }
            return ES6ImportsWorker.getImportedBinding(element, isDefault);
        }
        return null;
    }

    @NotNull
    public static ExistingImports getExistingImports(@NotNull PsiElement scope, @NotNull String from) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImports"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImports"));
        }
        ExistingImports result = new ExistingImports();
        Collection elements = PsiTreeUtil.findChildrenOfType((PsiElement)scope, ES6ImportDeclaration.class);
        for (ES6ImportDeclaration element : elements) {
            ES6ImportedBinding[] bindings;
            ES6ImportSpecifier[] specifiers;
            String source;
            if (element.getFromClause() == null || element.getFromClause().getReferenceText() == null || !from.equals(source = StringUtil.unquoteString((String)element.getFromClause().getReferenceText()))) continue;
            for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
                result.myByReference.put(importSpecifier.getReferenceName(), importSpecifier);
            }
            for (ES6ImportedBinding binding : bindings = element.getImportedBindings()) {
                result.myBindings.add(binding);
            }
        }
        ExistingImports existingImports = result;
        if (existingImports == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getExistingImports"));
        }
        return existingImports;
    }

    @Nullable
    private static Trinity<String, PsiElement, ES6ImportDeclaration> getImportedBinding(ES6ImportDeclaration element, boolean isDefault) {
        ES6ImportedBinding[] bindings;
        for (ES6ImportedBinding binding : bindings = element.getImportedBindings()) {
            if (isDefault && binding.isNamespaceImport()) continue;
            return Trinity.create((Object)binding.getName(), (Object)binding, (Object)element);
        }
        return null;
    }

    @Nullable
    private static Trinity<String, ES6ImportSpecifier, ES6ImportDeclaration> getImportSpecifierByReferenceName(@NotNull ES6ImportDeclaration element, @NotNull String referenceName) {
        ES6ImportSpecifier[] specifiers;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getImportSpecifierByReferenceName"));
        }
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "getImportSpecifierByReferenceName"));
        }
        for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
            if (!referenceName.equals(importSpecifier.getReferenceName())) continue;
            String name = importSpecifier.getAlias() != null ? importSpecifier.getAlias().getName() : importSpecifier.getReferenceName();
            return Trinity.create((Object)name, (Object)importSpecifier, (Object)element);
        }
        return null;
    }

    public static ES6ImportSpecifier insertImportSpecifier(@NotNull ES6ImportDeclaration element, @NotNull String referenceText) {
        ES6FromClause current;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "insertImportSpecifier"));
        }
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/javascript/intentions/ES6ImportsWorker", "insertImportSpecifier"));
        }
        assert (referenceText.startsWith("{") && referenceText.endsWith("}")) : referenceText;
        ES6ImportDeclaration fictiveDeclaration = (ES6ImportDeclaration)JSChangeUtil.createStatementFromText(element.getProject(), "import " + referenceText + " from \"a\";").getPsi(ES6ImportDeclaration.class);
        ES6FromClause fromClause = (ES6FromClause)PsiTreeUtil.getChildOfType((PsiElement)element, ES6FromClause.class);
        if (fromClause == null) {
            return null;
        }
        for (current = fromClause; current != null && current.getNode().getElementType() != JSTokenTypes.RBRACE; current = current.getPrevSibling()) {
        }
        ES6FromClause anchor = fromClause;
        ArrayList<Object> toAdd = new ArrayList<Object>();
        if (current != null && current.getNode().getElementType() == JSTokenTypes.RBRACE) {
            anchor = current;
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)PsiTreeUtil.findChildOfType((PsiElement)fictiveDeclaration, ES6ImportSpecifier.class);
            assert (specifier != null);
            toAdd.add(JSChangeUtil.createCommaPsiElement(element.getProject()));
            toAdd.add(specifier);
        } else {
            toAdd.add(JSChangeUtil.createCommaPsiElement(element.getProject()));
            Iterator iterator = PsiTreeUtil.childIterator((PsiElement)fictiveDeclaration, PsiElement.class);
            while (iterator.hasNext()) {
                PsiElement psiElement = (PsiElement)iterator.next();
                IElementType type = psiElement.getNode().getElementType();
                if (type != JSTokenTypes.RBRACE && type != JSTokenTypes.LBRACE && !(psiElement instanceof ES6ImportSpecifier)) continue;
                toAdd.add(psiElement);
            }
            anchor = (PsiElement)JSChangeUtil.addWs(element.getNode(), anchor.getNode(), " ");
        }
        Collections.reverse(toAdd);
        for (PsiElement psiElement : toAdd) {
            anchor = element.addBefore(psiElement, (PsiElement)anchor);
        }
        String referenceName = referenceText.substring(1, referenceText.length() - 1);
        referenceName = referenceName.contains(" as ") ? referenceName.substring(0, referenceName.indexOf(" as ")) : referenceName;
        referenceName = referenceName.trim();
        Trinity<String, ES6ImportSpecifier, ES6ImportDeclaration> trinity = ES6ImportsWorker.getImportSpecifierByReferenceName(element, referenceName);
        return trinity == null || trinity.getFirst() == null ? null : (ES6ImportSpecifier)trinity.getSecond();
    }

    public static class ExistingImports {
        private final Map<String, ES6ImportSpecifier> myByReference = new HashMap<String, ES6ImportSpecifier>();
        private final List<ES6ImportedBinding> myBindings = new ArrayList<ES6ImportedBinding>();

        public boolean isEmpty() {
            return this.myByReference.isEmpty() && this.myBindings.isEmpty();
        }

        public Map<String, ES6ImportSpecifier> getByReference() {
            return this.myByReference;
        }

        public List<ES6ImportedBinding> getBindings() {
            return this.myBindings;
        }
    }
}

