/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.linter.eslint.EslintCheckstyleProblems;
import com.intellij.lang.javascript.linter.eslint.EslintPackage;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private boolean myIsFix;

    public EsLintExternalRunner(boolean isOnTheFly, boolean isFix) {
        this.myIsOnTheFly = isOnTheFly;
        this.myIsFix = isFix;
    }

    @Nullable
    public static EslintSessionData createSessionData(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter, @NotNull EslintPackage eslintPackage, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile, @Nullable File additionalRulesDir, @NotNull String extraOptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (eslintPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackage", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileContentToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContentToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        VirtualFile workingDir = EsLintExternalRunner.guessWorkingDirectory(project, fileToLint);
        if (workingDir == null) {
            LOG.info("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.warn("No parent directory");
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(interpreter, eslintPackage, workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile, additionalRulesDir, extraOptions);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        VirtualFile eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileToLint, ".eslintignore");
        VirtualFile eslintIgnoreFileDir = eslintIgnoreFile != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private JSLinterAnnotationResult<EslintState> eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData, @NotNull List<VirtualFile> configs) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        long startNanoTime = System.nanoTime();
        if (JSLinterUtil.isPureHtmlFile(input.getPsiFile()) && !EslintUtil.configAllowsHtml(input.getProject(), configs)) {
            return null;
        }
        JSLinterAnnotationResult<EslintState> result = this.runProcess(input, sessionData);
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNanoTime);
        String report = result == null ? "results skipped" : "found " + result.getErrors().size() + " problems";
        LOG.info(String.format("Done in %d ms, %s", durationMillis, report));
        return result;
    }

    @Nullable
    private JSLinterAnnotationResult<EslintState> runProcess(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData) {
        KillableColoredProcessHandler processHandler;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        GeneralCommandLine commandLine = this.createCommandLine(sessionData);
        EslintPackage eslintPackage = sessionData.getEslintPackage();
        VirtualFile fileToLint = sessionData.getFileToLint();
        LOG.info("Running eslint@" + eslintPackage.getVersionStr() + " at " + sessionData.getWorkingDirectory().getPath() + "$ " + commandLine.getCommandLineString());
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, false);
        }
        catch (ExecutionException e) {
            return input.createFileLevelWarningResult("ESLint failed: " + e.getMessage(), new IntentionAction[0]);
        }
        if (!this.myIsFix && sessionData.getEslintPackage().isStdinSupported()) {
            String content = FilesMirror.convertLineSeparatorsToFileOriginal(input.getFileContent(), input.getVirtualFile());
            byte[] bytes = content.getBytes(commandLine.getCharset());
            try {
                OutputStream stdin = (OutputStream)ObjectUtils.assertNotNull((Object)processHandler.getProcessInput());
                stdin.write(bytes);
                stdin.flush();
                stdin.close();
            }
            catch (IOException e) {
                String message = "Failed to write " + bytes.length + " bytes to stdin";
                LOG.warn(message, (Throwable)e);
                ProcessOutput output = EsLintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
                output.appendStderr("\n" + message + "\n");
                IntentionAction action = EsLintExternalRunner.createDetailsAction(input.getProject(), fileToLint, commandLine, (ProcessHandler)processHandler, output);
                return input.createFileLevelWarningResult("Failed to run ESLint", action);
            }
        }
        ProcessOutput output = EsLintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
        IntentionAction action = EsLintExternalRunner.createDetailsAction(input.getProject(), fileToLint, commandLine, (ProcessHandler)processHandler, output);
        String stderr = output.getStderr();
        if (!StringUtil.isEmptyOrSpaces((String)stderr)) {
            return input.createFileLevelWarningResult("ESLint failed: " + stderr, action);
        }
        String stdout = output.getStdout();
        if (input.getProject().isDisposed()) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)stdout)) {
            return input.createFileLevelWarningResult("Failed to run ESLint", action);
        }
        EslintCheckstyleProblems checkstyleProblems = EslintCheckstyleProblems.parse(stdout, eslintPackage.isOneBasedColumn());
        if (checkstyleProblems.getFailMessage() != null) {
            return input.createFileLevelWarningResult("ESLint failed: " + checkstyleProblems.getFailMessage(), action);
        }
        return JSLinterAnnotationResult.createLinterResult(input, checkstyleProblems.getErrors(), null);
    }

    @NotNull
    private static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler processHandler, @NotNull ProcessOutput output) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        JsqtViewProcessOutputAction jsqtViewProcessOutputAction = new JsqtViewProcessOutputAction("Failed to lint " + EslintUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint), JavaScriptLanguageIcons.FileTypes.Eslint, commandLine, processHandler, output);
        if (jsqtViewProcessOutputAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createDetailsAction"));
        }
        return jsqtViewProcessOutputAction;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull EslintSessionData sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        EnvironmentVariablesData.DEFAULT.configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDirectory()));
        commandLine.setExePath(sessionData.getInterpreter().getInterpreterSystemDependentPath());
        commandLine.addParameter(sessionData.getEslintPackage().getBin().getAbsolutePath());
        if (sessionData.getAdditionalRulesDir() != null) {
            commandLine.addParameter("--rulesdir=" + sessionData.getAdditionalRulesDir().getAbsolutePath());
        }
        commandLine.addParameter("--format=checkstyle");
        if (sessionData.getSpecifiedConfigFile() != null) {
            commandLine.addParameter("--config");
            commandLine.addParameter(FileUtil.toSystemDependentName((String)sessionData.getSpecifiedConfigFile().getPath()));
        }
        if (StringUtil.isNotEmpty((String)sessionData.getExtraOptions())) {
            commandLine.addParameters(ParametersList.parse((String)sessionData.getExtraOptions()));
        }
        if (this.myIsFix) {
            commandLine.addParameter("--fix");
        }
        if (!this.myIsFix && sessionData.getEslintPackage().isStdinSupported()) {
            commandLine.addParameter("--stdin");
            commandLine.addParameter("--stdin-filename");
            commandLine.addParameter(sessionData.getFileToLintRelativePath());
        } else if (FileDocumentManager.getInstance().isFileModified(sessionData.getFileToLint())) {
            File file;
            if (sessionData.getSpecifiedConfigFile() == null) {
                List<VirtualFile> configs = EslintUtil.findAllConfigsUpFileSystem(sessionData.getFileToLint());
                VirtualFile config = (VirtualFile)ContainerUtil.getFirstItem(configs);
                if (config == null) {
                    config = JSLinterConfigFileUtil.findFileUpFileSystemRoot(sessionData.getFileToLint(), "package.json");
                }
                if (config != null) {
                    commandLine.addParameter("--config");
                    commandLine.addParameter(FileUtil.toSystemDependentName((String)config.getPath()));
                }
            }
            if ((file = MirrorHolder.INSTANCE.getOrCreateFileWithActualContent(sessionData.getFileToLint(), sessionData.getFileToLintContent())) == null) {
                LOG.warn("Cannot mirror " + sessionData.getFileToLint().getPath());
                file = VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getFileToLint());
            }
            commandLine.addParameter(file.getAbsolutePath());
        } else {
            commandLine.addParameter(sessionData.getFileToLintRelativePath());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "captureOutput"));
        }
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        catcher.run();
        ProcessOutput processOutput = catcher.getOutput();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "captureOutput"));
        }
        return processOutput;
    }

    @Nullable
    static File getAdditionalRulesDir(@NotNull String additionalRulesDirPath) throws IOException {
        if (additionalRulesDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalRulesDirPath", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "getAdditionalRulesDir"));
        }
        if (additionalRulesDirPath.isEmpty()) {
            return null;
        }
        File dir = new File(additionalRulesDirPath);
        if (!dir.isDirectory() || !dir.isAbsolute()) {
            throw new IOException("ESLint: please correct path to additional rules directory");
        }
        return dir;
    }

    public JSLinterAnnotationResult<EslintState> execute(final @NotNull JSLinterInput<EslintState> input) {
        VirtualFile specifiedConfigFile;
        File additionalRulesDir;
        EslintPackage eslintPackage;
        NodeJsLocalInterpreter localInterpreter;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "execute"));
        }
        final VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid()) {
            return null;
        }
        VirtualFile fileDir = fileToLint.getParent();
        if (fileDir == null) {
            return null;
        }
        final EslintState state = input.getState();
        try {
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(input.getProject());
            localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException e) {
            return input.createFileLevelWarningResult("ESLint: " + StringUtil.decapitalize((String)e.getMessage()), new IntentionAction[0]);
        }
        try {
            eslintPackage = new EslintPackage(state.getEslintPackagePath());
            additionalRulesDir = EsLintExternalRunner.getAdditionalRulesDir(state.getAdditionalRulesDirPath());
        }
        catch (IOException e) {
            return input.createFileLevelWarningResult(e.getMessage(), new IntentionAction[0]);
        }
        if (state.isCustomConfigFileUsed()) {
            specifiedConfigFile = JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath());
            if (specifiedConfigFile == null || !specifiedConfigFile.isValid()) {
                return input.createFileLevelWarningResult("ESLint: please correct path to ESLint configuration file", new IntentionAction[0]);
            }
        } else {
            specifiedConfigFile = null;
        }
        final Project project = input.getProject();
        EslintSessionData sessionData = (EslintSessionData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<EslintSessionData>(){

            public EslintSessionData compute() {
                if (project.isDisposed()) {
                    return null;
                }
                if (EsLintExternalRunner.this.myIsOnTheFly) {
                    EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
                }
                return EsLintExternalRunner.createSessionData(project, localInterpreter, eslintPackage, fileToLint, input.getFileContent(), specifiedConfigFile, additionalRulesDir, state.getExtraOptions());
            }
        });
        if (sessionData == null) {
            return null;
        }
        boolean runGranted = true;
        final List<VirtualFile> configs = sessionData.findConfigs();
        if (this.myIsOnTheFly) {
            runGranted = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (project.isDisposed()) {
                        return false;
                    }
                    EslintUnsavedConfigManager unsavedConfigsManager = EslintUnsavedConfigManager.getInstance(project);
                    if (unsavedConfigsManager.requestRun(configs)) {
                        return true;
                    }
                    LOG.info("ESLint postponed because of unsaved configs");
                    return false;
                }
            });
        }
        if (runGranted) {
            return this.eslint(input, sessionData, configs);
        }
        return null;
    }

    private static class MirrorHolder {
        private static final FilesMirror INSTANCE = new FilesMirror("intellij-eslint-mirror");

        private MirrorHolder() {
        }
    }
}

