/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.config;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfigChangeTracker;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class EslintConfigFileChangeTracker
extends JSLinterConfigChangeTracker {
    public EslintConfigFileChangeTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigFileChangeTracker", "<init>"));
        }
        super(project, (Condition<VirtualFile>)((Condition)file -> EslintUtil.isEslintConfigFile(file)));
    }

    public static EslintConfigFileChangeTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigFileChangeTracker", "getInstance"));
        }
        return (EslintConfigFileChangeTracker)ServiceManager.getService((Project)project, EslintConfigFileChangeTracker.class);
    }

    @Override
    protected boolean isAnalyzerRestartNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        if (changedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFile", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        ExtendedLinterState extendedState = EslintConfiguration.getInstance(project).getExtendedState();
        EslintState state = (EslintState)extendedState.getState();
        if (!extendedState.isEnabled()) {
            return false;
        }
        if (state.isCustomConfigFileUsed()) {
            VirtualFile configVirtualFile = JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath());
            return changedFile.equals(configVirtualFile);
        }
        return true;
    }
}

