/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.jshint.JSHintConfiguration;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile fileAtElement = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (fileAtElement == null) {
            return null;
        }
        Project project = element.getProject();
        JSHintConfiguration configuration = JSHintConfiguration.getInstance(project);
        JSHintState state = (JSHintState)configuration.getExtendedState().getState();
        String path = fileAtElement.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)state.getCustomConfigFilePath());
        if (!configPath.equals(path)) {
            return null;
        }
        return new MyRefactoringElementListener(configuration);
    }

    private static class MyRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final JSHintConfiguration myConfiguration;

        public MyRefactoringElementListener(@NotNull JSHintConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/linter/jshint/JSHintRefactoringElementListenerProvider$MyRefactoringElementListener", "<init>"));
            }
            this.myConfiguration = configuration;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/JSHintRefactoringElementListenerProvider$MyRefactoringElementListener", "refactored"));
            }
            VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
            if (newFile != null) {
                ExtendedLinterState extendedState = this.myConfiguration.getExtendedState();
                JSHintState.Builder builder = new JSHintState.Builder((JSHintState)extendedState.getState());
                builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)newFile.getPath()));
                this.myConfiguration.setExtendedState(extendedState.isEnabled(), builder.build());
            }
        }
    }
}

