/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleFixCreator {
    private final List<FixDescriptor> myFixDescriptors;
    private final Set<VirtualFile> myPredefinedFiles;
    private boolean myNoFixesShouldBeSuggested;

    public ModuleFixCreator(Set<VirtualFile> predefinedFiles) {
        this.myPredefinedFiles = predefinedFiles;
        this.myFixDescriptors = new ArrayList<FixDescriptor>();
    }

    public void addFix(@NotNull FixDescriptor fixDescriptor) {
        if (fixDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixDescriptor", "com/intellij/lang/javascript/modules/ModuleFixCreator", "addFix"));
        }
        if (this.myNoFixesShouldBeSuggested) {
            return;
        }
        if (this.myPredefinedFiles.contains(fixDescriptor.getFromFile())) {
            this.myNoFixesShouldBeSuggested = true;
            this.myFixDescriptors.clear();
            return;
        }
        if (this.myFixDescriptors.contains(fixDescriptor)) {
            return;
        }
        this.myFixDescriptors.add(fixDescriptor);
    }

    public void checkResolve(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/ModuleFixCreator", "checkResolve"));
        }
        if (element.getContainingFile().isValid() && this.myPredefinedFiles.contains(element.getContainingFile().getVirtualFile()) && element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getNamespace() == null) {
            this.myNoFixesShouldBeSuggested = true;
            this.myFixDescriptors.clear();
        }
    }

    public boolean isNoFixesShouldBeSuggested() {
        return this.myNoFixesShouldBeSuggested;
    }

    public List<FixDescriptor> getFixDescriptors() {
        return this.myFixDescriptors;
    }

    public boolean isEmpty() {
        return this.myFixDescriptors.isEmpty();
    }

    public static enum ModuleType {
        nodejs,
        es6,
        amd;

    }

    public static class FixDescriptor {
        private boolean myTwoWordsMath;
        @NotNull
        private final ModuleType myModuleType;
        @NotNull
        private final String myFromPath;
        @NotNull
        private final VirtualFile myFromFile;
        @NotNull
        private final String myFirstWordInFile;
        @Nullable
        private final String myFirstWordInExportsName;
        @Nullable
        private SmartPsiElementPointer<JSReferenceExpression> myTailToReplaceReference;
        @Nullable
        private String[] myTail;
        private boolean myModuleElementIsMissing;
        private boolean myIsDefaultExport;

        public FixDescriptor(@NotNull ModuleType moduleType, @NotNull String fromPath, @NotNull VirtualFile file, @NotNull String firstWordInFile, @Nullable String firstWordInExportsName) {
            if (moduleType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (fromPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPath", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            if (firstWordInFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstWordInFile", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            this.myModuleType = moduleType;
            this.myFromPath = fromPath;
            this.myFromFile = file;
            this.myFirstWordInFile = firstWordInFile;
            this.myFirstWordInExportsName = firstWordInExportsName;
        }

        public FixDescriptor(@NotNull FixDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "<init>"));
            }
            this.myModuleType = descriptor.myModuleType;
            this.myFromPath = descriptor.myFromPath;
            this.myFromFile = descriptor.myFromFile;
            this.myFirstWordInFile = descriptor.myFirstWordInFile;
            this.myFirstWordInExportsName = descriptor.myFirstWordInExportsName;
        }

        public boolean isTwoWordsMath() {
            return this.myTwoWordsMath;
        }

        public void setTwoWordsMath(boolean twoWordsMath) {
            this.myTwoWordsMath = twoWordsMath;
        }

        public FixDescriptor moduleElementIsMissing() {
            this.myModuleElementIsMissing = true;
            return this;
        }

        public FixDescriptor withTail(@NotNull SmartPsiElementPointer<JSReferenceExpression> tailToReplaceReference, @NotNull String[] tail) {
            if (tailToReplaceReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailToReplaceReference", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "withTail"));
            }
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "withTail"));
            }
            this.myTailToReplaceReference = tailToReplaceReference;
            this.myTail = tail;
            return this;
        }

        public boolean isDefaultExport() {
            return this.myIsDefaultExport;
        }

        public void setDefaultExport(boolean defaultExport) {
            this.myIsDefaultExport = defaultExport;
        }

        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.myModuleType;
            if (moduleType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getModuleType"));
            }
            return moduleType;
        }

        @NotNull
        public String getFromPath() {
            String string = this.myFromPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFromPath"));
            }
            return string;
        }

        @NotNull
        public VirtualFile getFromFile() {
            VirtualFile virtualFile = this.myFromFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFromFile"));
            }
            return virtualFile;
        }

        @NotNull
        public String getFirstWordInFile() {
            String string = this.myFirstWordInFile;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ModuleFixCreator$FixDescriptor", "getFirstWordInFile"));
            }
            return string;
        }

        @Nullable
        public String getFirstWordInExportsName() {
            return this.myFirstWordInExportsName;
        }

        @Nullable
        public SmartPsiElementPointer<JSReferenceExpression> getTailToReplaceReference() {
            return this.myTailToReplaceReference;
        }

        public boolean hasTail() {
            return this.myTailToReplaceReference != null && this.myTailToReplaceReference.getElement() != null;
        }

        @Nullable
        public String[] getTail() {
            return this.myTail;
        }

        public boolean isModuleElementIsMissing() {
            return this.myModuleElementIsMissing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixDescriptor that = (FixDescriptor)o;
            if (this.myModuleElementIsMissing != that.myModuleElementIsMissing) {
                return false;
            }
            if (this.myModuleType != that.myModuleType) {
                return false;
            }
            if (!this.myFromPath.equals(that.myFromPath)) {
                return false;
            }
            if (!this.myFromFile.equals(that.myFromFile)) {
                return false;
            }
            if (!this.myFirstWordInFile.equals(that.myFirstWordInFile)) {
                return false;
            }
            if (this.myFirstWordInExportsName != null ? !this.myFirstWordInExportsName.equals(that.myFirstWordInExportsName) : that.myFirstWordInExportsName != null) {
                return false;
            }
            if (this.myTailToReplaceReference != null ? !this.myTailToReplaceReference.equals(that.myTailToReplaceReference) : that.myTailToReplaceReference != null) {
                return false;
            }
            if (!Arrays.equals(this.myTail, that.myTail)) {
                return false;
            }
            return this.myIsDefaultExport == that.myIsDefaultExport;
        }

        public int hashCode() {
            int result = this.myModuleType.hashCode();
            result = 31 * result + this.myFromPath.hashCode();
            result = 31 * result + this.myFromFile.hashCode();
            result = 31 * result + this.myFirstWordInFile.hashCode();
            result = 31 * result + (this.myFirstWordInExportsName != null ? this.myFirstWordInExportsName.hashCode() : 0);
            result = 31 * result + (this.myTailToReplaceReference != null ? this.myTailToReplaceReference.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.myTail);
            result = 31 * result + (this.myModuleElementIsMissing ? 1 : 0);
            result = 31 * result + (this.myIsDefaultExport ? 1 : 0);
            return result;
        }
    }
}

