/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecordModuleIntoPackageJsonQuickFix
implements LocalQuickFix,
HintAction,
HighPriorityAction {
    private final String myModuleName;
    private List<VirtualFile> myPackageJsonFiles;
    private final boolean myAsDevDependency;

    protected RecordModuleIntoPackageJsonQuickFix(String moduleName, @NotNull Collection<VirtualFile> virtualFiles, boolean asDevDependency) {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "<init>"));
        }
        this.myModuleName = moduleName;
        this.myPackageJsonFiles = new ArrayList<VirtualFile>(virtualFiles);
        this.myAsDevDependency = asDevDependency;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "showHint"));
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"node.js.quickfix.record.into.package.json.text", (Object[])new Object[]{this.myModuleName, this.myAsDevDependency ? PackageJsonField.devDependencies.getName() : PackageJsonField.dependencies.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "invoke"));
        }
        this.selectPackageJsonAndInvoke(project, file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.quickfix.record.into.package.json.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "applyFix"));
        }
        this.selectPackageJsonAndInvoke(project, descriptor.getPsiElement().getContainingFile());
    }

    private void selectPackageJsonAndInvoke(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "selectPackageJsonAndInvoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "selectPackageJsonAndInvoke"));
        }
        InstallNodeModuleQuickFix.selectPackageJson(project, this.myPackageJsonFiles, (Consumer<VirtualFile>)((Consumer)packageJson -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$selectPackageJsonAndInvoke$2"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$selectPackageJsonAndInvoke$2"));
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$null$1"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$null$1"));
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$null$0"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "lambda$null$0"));
                    }
                    this.invokeAction(project, file, (VirtualFile)packageJson);
                });
            }, this.getText(), null);
        }));
    }

    private void invokeAction(@NotNull Project project, PsiFile source, @Nullable VirtualFile packageJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "invokeAction"));
        }
        PsiFile psiFile = RecordModuleIntoPackageJsonQuickFix.ensurePackageJsonExist(project, packageJson);
        if (psiFile == null) {
            return;
        }
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
        if (file == null) {
            return;
        }
        PsiElement[] children = file.getChildren();
        if (children.length == 0) {
            return;
        }
        JsonObject topObject = (JsonObject)ObjectUtils.tryCast((Object)children[0], JsonObject.class);
        if (topObject == null) {
            return;
        }
        String propertyName = this.myAsDevDependency ? PackageJsonField.devDependencies.getName() : PackageJsonField.dependencies.getName();
        JsonProperty property = topObject.findProperty(propertyName);
        if (property == null ? this.createDependencyObject(project, topObject, propertyName) : this.addDependencyRecord(project, property)) {
            return;
        }
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        analyzer.restart(source);
        analyzer.restart((PsiFile)file);
    }

    @Nullable
    public static PsiFile ensurePackageJsonExist(@NotNull Project project, @Nullable VirtualFile packageJson) {
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "ensurePackageJsonExist"));
        }
        if (packageJson == null) {
            PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(project.getBaseDir());
            if (directory == null) {
                Messages.showErrorDialog((Project)project, (String)"Error when trying to create package.json.", (String)"Put Node.js Module into package.json");
                return null;
            }
            psiFile = PackageJsonUtil.createPackageJson(directory, false);
            if (psiFile == null) {
                return null;
            }
        } else {
            psiFile = PsiManager.getInstance((Project)project).findFile(packageJson);
        }
        return psiFile;
    }

    private boolean createDependencyObject(@NotNull Project project, JsonObject topObject, String propertyName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "createDependencyObject"));
        }
        JsonProperty depProperty = this.createDepProperty(project, propertyName);
        if (depProperty == null) {
            return true;
        }
        List list = topObject.getPropertyList();
        if (list.isEmpty()) {
            topObject.addAfter((PsiElement)depProperty, topObject.getFirstChild());
        } else {
            JsonProperty last = (JsonProperty)list.get(list.size() - 1);
            PsiElement added = topObject.addAfter(depProperty.getPrevSibling(), (PsiElement)last);
            topObject.addAfter((PsiElement)depProperty, added);
        }
        return false;
    }

    private boolean addDependencyRecord(@NotNull Project project, JsonProperty property) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "addDependencyRecord"));
        }
        JsonValue value = property.getValue();
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
        if (object == null) {
            return true;
        }
        PsiFile dummyFile = RecordModuleIntoPackageJsonQuickFix.createDummyFile(project, "{\"\":1,\"" + this.myModuleName + "\": \"latest\"}");
        PsiElement topElement = dummyFile.getFirstChild();
        JsonObject newTopObject = (JsonObject)ObjectUtils.tryCast((Object)topElement, JsonObject.class);
        if (newTopObject == null) {
            return true;
        }
        JsonProperty newDepProperty = newTopObject.findProperty(this.myModuleName);
        if (newDepProperty == null) {
            return true;
        }
        List innerProperties = object.getPropertyList();
        if (innerProperties.isEmpty()) {
            object.addAfter((PsiElement)newDepProperty, object.getFirstChild());
        } else {
            PsiElement added = object.addAfter(newDepProperty.getPrevSibling(), (PsiElement)innerProperties.get(innerProperties.size() - 1));
            object.addAfter((PsiElement)newDepProperty, added);
        }
        return false;
    }

    @Nullable
    private JsonProperty createDepProperty(@NotNull Project project, String propertyName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/RecordModuleIntoPackageJsonQuickFix", "createDepProperty"));
        }
        PsiFile dummyFile = RecordModuleIntoPackageJsonQuickFix.createDummyFile(project, "{\"\":1,\"" + propertyName + "\": {\"" + this.myModuleName + "\": \"latest\"}}");
        PsiElement topElement = dummyFile.getFirstChild();
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)topElement, JsonObject.class);
        if (object == null) {
            return null;
        }
        JsonProperty depProperty = object.findProperty(propertyName);
        if (depProperty == null) {
            return null;
        }
        return depProperty;
    }

    private static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy.json", (FileType)JsonFileType.INSTANCE, (CharSequence)text);
    }
}

