/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSRelatedFilesContributor
extends RelatedToHtmlFilesContributor {
    public void fillRelatedFiles(@NotNull XmlFile xmlFile, final @NotNull Set<PsiFile> resultSet) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/lang/javascript/navigation/JSRelatedFilesContributor", "fillRelatedFiles"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/lang/javascript/navigation/JSRelatedFilesContributor", "fillRelatedFiles"));
        }
        final PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/navigation/JSRelatedFilesContributor$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/navigation/JSRelatedFilesContributor$1", "visit"));
                }
                if (injectedPsi instanceof XmlFile) {
                    JSRelatedFilesContributor.this.fillRelatedFiles((XmlFile)injectedPsi, resultSet);
                }
            }
        };
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(true){

            public void visitXmlText(XmlText text) {
                if (text instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate((PsiElement)text, (PsiLanguageInjectionHost.InjectedPsiVisitor)injectedPsiVisitor);
                }
                super.visitXmlText(text);
            }

            public void visitXmlComment(XmlComment comment) {
                if (comment instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate((PsiElement)comment, (PsiLanguageInjectionHost.InjectedPsiVisitor)injectedPsiVisitor);
                }
                super.visitXmlComment(comment);
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (HtmlUtil.isScriptTag((XmlTag)attribute.getParent()) && "src".equals(attribute.getName())) {
                    XmlAttributeValue valueElement = attribute.getValueElement();
                    if (valueElement == null) {
                        return;
                    }
                    for (PsiReference reference : valueElement.getReferences()) {
                        if (reference instanceof PsiPolyVariantReference) {
                            ResolveResult[] results;
                            for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                                PsiElement resolvedElement = result.getElement();
                                if (!(resolvedElement instanceof PsiFile)) continue;
                                resultSet.add((PsiFile)resolvedElement);
                            }
                            continue;
                        }
                        PsiElement resolvedElement = reference.resolve();
                        if (!(resolvedElement instanceof PsiFile)) continue;
                        resultSet.add((PsiFile)resolvedElement);
                    }
                }
            }
        });
    }

    public String getGroupName() {
        return "JavaScript";
    }
}

