/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)JSChangeUtil.class.getName());
    @NonNls
    private static final String DUMMY = "dummy.";

    private JSChangeUtil() {
    }

    public static ASTNode createNameIdentifier(Project project, String name, IElementType type) {
        if (JSTokenTypes.IDENTIFIER_TOKENS_SET.contains(type)) {
            return JSChangeUtil.createNameIdentifier(project, name);
        }
        if (type == JSTokenTypes.STRING_LITERAL && !StringUtil.isQuotedString((String)name)) {
            return JSChangeUtil.createExpressionFromText(project, "\"" + name + "\"").getFirstChildNode();
        }
        return JSChangeUtil.createExpressionFromText(project, name).getFirstChildNode();
    }

    public static ASTNode createNameIdentifier(Project project, String name) {
        JSExpressionStatement expressionStatement = (JSExpressionStatement)JSChangeUtil.createJSTreeFromTextImpl(project, name + ";", null);
        JSReferenceExpressionImpl refExpression = (JSReferenceExpressionImpl)expressionStatement.getFirstChild();
        return refExpression.getNode().getFirstChildNode();
    }

    public static ASTNode createNameIdentifier(Project project, String name, @Nullable JSLanguageDialect dialect) {
        JSExpressionStatement expressionStatement = (JSExpressionStatement)JSChangeUtil.createJSTreeFromTextImpl(project, name + ";", dialect);
        JSReferenceExpressionImpl refExpression = (JSReferenceExpressionImpl)expressionStatement.getFirstChild();
        return refExpression.getNode().getFirstChildNode();
    }

    public static ASTNode createExpressionFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createExpressionFromText(project, text, null);
    }

    @NotNull
    public static ASTNode createExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        ASTNode node = JSChangeUtil.tryCreateExpressionFromText(project, text, dialect);
        if (node == null) {
            LOG.error("Wasn't parsed as expression in " + (Object)((Object)dialect), new Attachment[]{new Attachment("text.txt", text)});
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "createExpressionFromText"));
        }
        return aSTNode;
    }

    @Nullable
    public static ASTNode tryCreateExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        text = "{\n(" + text + ")\n}";
        PsiElement element = JSChangeUtil.createJSTreeFromTextImpl(project, text, dialect);
        assert (element instanceof JSBlockStatement) : "\"" + text + "\" was not parsed as BlockStatement in " + (Object)((Object)dialect);
        JSStatement[] statements = ((JSBlockStatement)element).getStatements();
        JSStatement jSStatement = element = statements.length > 0 ? statements[0] : null;
        if (!(element instanceof JSExpressionStatement)) {
            LOG.error("Unexpected expression parse in " + (Object)((Object)dialect), new Attachment[]{new Attachment("text.txt", text)});
            return null;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)element;
        JSExpression expr = (JSExpression)expressionStatement.getFirstChild();
        if (expr instanceof JSParenthesizedExpression) {
            expr = ((JSParenthesizedExpression)expr).getInnerExpression();
        }
        if (expr == null) {
            return null;
        }
        return expr.getNode();
    }

    public static ASTNode createStatementFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createStatementFromText(project, text, null);
    }

    public static ASTNode createStatementFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        PsiElement element = JSChangeUtil.createJSTreeFromTextImpl(project, text, dialect);
        JSSourceElement stmt = element instanceof JSSourceElement ? (JSSourceElement)element : null;
        return stmt != null ? stmt.getNode() : null;
    }

    @Nullable
    private static PsiElement createJSTreeFromTextImpl(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        PsiFile dummyFile = JSChangeUtil.createJSFileFromText(project, text, dialect);
        return dummyFile.getFirstChild();
    }

    public static PsiFile createJSFileFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        JSLanguageDialect language = dialect != null ? dialect : JavascriptLanguage.INSTANCE;
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        assert (def != null);
        String ext = dialect == null ? "js" : dialect.getFileExtension();
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY + ext, (Language)language, (CharSequence)text, false, true);
        assert (dummyFile instanceof JSFile);
        return dummyFile;
    }

    public static ASTNode createJSTreeFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createJSTreeFromText(project, text, null);
    }

    @NotNull
    public static PsiElement createCommaPsiElement(Project project) {
        ASTNode text = JSChangeUtil.createJSTreeFromText(project, "dummy,dummy");
        ASTNode node = text.getFirstChildNode();
        ASTNode commaNode = node.findChildByType(JSTokenTypes.COMMA);
        assert (commaNode != null);
        PsiElement psiElement = commaNode.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "createCommaPsiElement"));
        }
        return psiElement;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createConditionalPsiElements(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "createConditionalPsiElements"));
        }
        ASTNode text = JSChangeUtil.createJSTreeFromText(project, "dummy?dummy:dummy");
        ASTNode node = text.getFirstChildNode();
        ASTNode questNode = node.findChildByType(JSTokenTypes.QUEST);
        ASTNode semiNode = node.findChildByType(JSTokenTypes.COLON);
        assert (questNode != null);
        assert (semiNode != null);
        Pair pair = Pair.create((Object)questNode.getPsi(), (Object)semiNode.getPsi());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "createConditionalPsiElements"));
        }
        return pair;
    }

    public static ASTNode createJSTreeFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect languageDialect) {
        PsiElement element = JSChangeUtil.createJSTreeFromTextImpl(project, text, languageDialect);
        if (element != null) {
            return element.getNode();
        }
        return null;
    }

    public static JSExpression replaceExpression(JSExpression oldExpr, JSExpression newExpr) {
        if (JSUtils.isNeedParenthesis(oldExpr, newExpr)) {
            ASTNode parenthesized = JSChangeUtil.createExpressionFromText(oldExpr.getProject(), "(a)");
            JSParenthesizedExpression parenthPsi = (JSParenthesizedExpression)parenthesized.getPsi();
            parenthesized.replaceChild(parenthPsi.getInnerExpression().getNode(), newExpr.getNode().copyElement());
            oldExpr.getParent().getNode().replaceChild(oldExpr.getNode(), parenthesized);
            return parenthPsi;
        }
        ASTNode newNode = newExpr.getNode().copyElement();
        oldExpr.getParent().getNode().replaceChild(oldExpr.getNode(), newNode);
        return (JSExpression)newNode.getPsi();
    }

    public static JSElement replaceElement(JSElement oldElement, JSElement newElement) {
        ASTNode newNode = newElement.getNode().copyElement();
        oldElement.getParent().getNode().replaceChild(oldElement.getNode(), newNode);
        return (JSElement)newNode.getPsi();
    }

    public static JSStatement replaceStatement(JSStatement oldStatement, JSStatement newStatement) {
        ASTNode newNode = newStatement.getNode().copyElement();
        oldStatement.getParent().getNode().replaceChild(oldStatement.getNode(), newNode);
        return (JSStatement)newNode.getPsi();
    }

    public static void doIdentifierReplacement(PsiElement parent, PsiElement identifier, String name) {
        JSChangeUtil.doIdentifierReplacement(parent.getNode(), identifier.getNode(), name, parent.getProject());
    }

    public static void doIdentifierReplacement(ASTNode parentNode, ASTNode identifierNode, String name, Project project) {
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(project, name);
        parentNode.replaceChild(identifierNode, nameElement);
    }

    public static PsiElement doAddBefore(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (!JSChangeUtil.isStatementOrComment(element) && !(element instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddBefore(jsElement, element, anchor);
    }

    public static PsiElement doDoAddBefore(PsiElement parentElement, PsiElement elementToInsert, @Nullable PsiElement anchor) throws IncorrectOperationException {
        ASTNode elementNode = elementToInsert.getNode();
        if (elementNode == null) {
            throw new IncorrectOperationException("node should not be null");
        }
        ASTNode copiedElementNode = elementNode.copyElement();
        ASTNode parentNode = parentElement.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        anchorNode = JSChangeUtil.insertWhitespaceIfNeeded(anchorNode, elementNode, parentNode, anchorNode);
        parentNode.addChild(copiedElementNode, (ASTNode)(anchorNode != null ? anchorNode : null));
        return copiedElementNode.getPsi();
    }

    private static ASTNode insertWhitespaceIfNeeded(ASTNode anchorNode, ASTNode elementNode, ASTNode parentNode, ASTNode insertionPlaceNode) throws IncorrectOperationException {
        ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(parentNode.getPsi().getLanguage());
        TokenSet comments = parserDef.getCommentTokens();
        TokenSet whitespaces = parserDef.getWhitespaceTokens();
        if (anchorNode != null && (!whitespaces.contains(anchorNode.getElementType()) && !whitespaces.contains(elementNode.getElementType()) || comments.contains(anchorNode.getElementType()) || comments.contains(elementNode.getElementType()) || elementNode.getPsi() instanceof PsiComment) || anchorNode == null && parentNode.getFirstChildNode() == null) {
            String commentString = " ";
            if (anchorNode != null && comments.contains(anchorNode.getElementType()) || comments.contains(elementNode.getElementType()) || elementNode.getPsi() instanceof PsiComment) {
                commentString = "\n";
            }
            anchorNode = JSChangeUtil.addWs(parentNode, insertionPlaceNode, commentString);
        }
        return anchorNode;
    }

    public static ASTNode addWs(ASTNode parentNode, ASTNode insertionPlaceNode, String commentString) {
        ASTNode wsNode = PsiParserFacade.SERVICE.getInstance((Project)parentNode.getPsi().getProject()).createWhiteSpaceFromText(commentString).getNode();
        parentNode.addChild(wsNode, insertionPlaceNode);
        return wsNode;
    }

    public static boolean isStatementContainer(PsiElement jsElement) {
        return jsElement instanceof JSBlockStatement || jsElement instanceof JSEmbeddedContent || jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule;
    }

    public static boolean isStatementOrComment(PsiElement jsElement) {
        return jsElement instanceof JSSourceElement || jsElement instanceof PsiComment;
    }

    public static PsiElement doAddAfter(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (!JSChangeUtil.isStatementOrComment(element) && !(element instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddAfter(jsElement, element, anchor);
    }

    public static PsiElement doDoAddAfter(PsiElement jsElement, PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        ASTNode parentNode = jsElement.getNode();
        ASTNode node = element.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : parentNode.getLastChildNode();
        anchorNode = JSChangeUtil.insertWhitespaceIfNeeded(anchorNode, node, parentNode, anchorNode != null ? anchorNode.getTreeNext() : null);
        ASTNode nodeCopy = node.copyElement();
        if (anchor == null) {
            parentNode.addChild(nodeCopy);
        } else {
            parentNode.addChild(nodeCopy, anchorNode.getTreeNext());
        }
        ASTNode nextAfter = nodeCopy.getTreeNext();
        JSChangeUtil.insertWhitespaceIfNeeded(nextAfter, node, parentNode, nextAfter);
        return nodeCopy.getPsi();
    }

    public static PsiElement doAddRangeBefore(PsiElement parent, PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        PsiElement resultElement;
        PsiElement psiElement = resultElement = JSChangeUtil.doAddBefore(parent, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(parent, first, psiElement);
        }
        return resultElement;
    }

    public static PsiElement doAddRangeAfter(PsiElement jsElement, PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        PsiElement resultElement;
        PsiElement psiElement = resultElement = JSChangeUtil.doAddAfter(jsElement, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(jsElement, first, psiElement);
        }
        return resultElement;
    }

    public static boolean isBlockStatementContainer(JSElement jsElement) {
        return jsElement instanceof JSIfStatement || jsElement instanceof JSLoopStatement;
    }

    public static PsiElement blockDoAddRangeBefore(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "blockDoAddRangeBefore"));
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeBefore(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddRangeAfter(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "blockDoAddRangeAfter"));
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeAfter(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddAfter(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "blockDoAddAfter"));
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addAfter(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static PsiElement blockDoAddBefore(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "blockDoAddBefore"));
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addBefore(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static <T extends JSSourceElement> T addSourceElement(@NotNull JSSourceElement statement, T toAdd, boolean before) throws IncorrectOperationException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "addSourceElement"));
        }
        ASTNode treeParent = statement.getNode().getTreeParent();
        if (treeParent.getElementType() != JSElementTypes.BLOCK_STATEMENT && !(treeParent.getElementType() instanceof JSFileElementType) && !(treeParent.getElementType() instanceof JSClassElementType) && treeParent.getElementType() != JSElementTypes.EMBEDDED_CONTENT) {
            if (before) {
                return (T)((JSSourceElement)treeParent.getPsi().addBefore(toAdd, (PsiElement)statement));
            }
            return (T)((JSSourceElement)treeParent.getPsi().addAfter(toAdd, (PsiElement)statement));
        }
        ASTNode copy = toAdd.getNode().copyElement();
        ASTNode anchorBefore = before ? statement.getNode() : statement.getNode().getTreeNext();
        treeParent.addChild(copy, anchorBefore);
        return (T)((JSSourceElement)copy.getPsi());
    }

    public static void addComments(@NotNull List<PsiElement> comments, PsiElement newElement) {
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/lang/javascript/psi/impl/JSChangeUtil", "addComments"));
        }
        for (PsiElement comment : comments) {
            if (comment instanceof PsiWhiteSpace) {
                JSChangeUtil.addWs(newElement.getParent().getNode(), newElement.getNode(), comment.getText().replace("\n", ""));
                continue;
            }
            JSChangeUtil.doAddBefore(newElement.getParent(), comment, newElement);
        }
    }

    static void removeRangeWithRemovalOfCommas(ASTNode myNode, ASTNode parent) {
        ASTNode from = myNode;
        ASTNode to = myNode.getTreeNext();
        boolean seenComma = false;
        if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
            to = to.getTreeNext();
        }
        if (to != null && to.getElementType() == JSTokenTypes.COMMA) {
            to = to.getTreeNext();
            seenComma = true;
            if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
                to = to.getTreeNext();
            }
        }
        if (!seenComma) {
            ASTNode treePrev = from.getTreePrev();
            if (treePrev != null && treePrev.getElementType() == JSTokenTypes.WHITE_SPACE) {
                treePrev = treePrev.getTreePrev();
            }
            if (treePrev != null && treePrev.getElementType() == JSTokenTypes.COMMA) {
                from = treePrev;
            }
            if (to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE) {
                to = to.getTreeNext();
            }
        }
        parent.removeRange(from, to);
    }

    public static ASTNode createClassMemberFromText(Project project, String text, @Nullable JSLanguageDialect dialect) {
        text = "class Foo {" + text + "}";
        ASTNode node = JSChangeUtil.createJSTreeFromText(project, text, dialect);
        assert (node.getPsi() instanceof JSClass) : "\"" + text + "\" was not parsed as JSClass";
        return node.findChildByType(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS);
    }

    static abstract class BlockAddContext {
        final JSBlockStatement newlyAddedBlock;
        final PsiElement codeBlockAnchor;

        BlockAddContext(@NotNull PsiElement _anchor) throws IncorrectOperationException {
            if (_anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil$BlockAddContext", "<init>"));
            }
            ASTNode codeBlockNode = JSChangeUtil.createStatementFromText(_anchor.getProject(), "{ a }");
            this.newlyAddedBlock = (JSBlockStatement)_anchor.replace(codeBlockNode.getPsi());
            JSStatement artificiallyAddedBlockAnchor = this.newlyAddedBlock.getStatements()[0];
            CodeEditUtil.replaceChild((ASTNode)this.newlyAddedBlock.getNode(), (ASTNode)artificiallyAddedBlockAnchor.getNode(), (ASTNode)_anchor.getNode());
            this.codeBlockAnchor = _anchor;
        }

        abstract PsiElement doAddElement(PsiElement ... var1) throws IncorrectOperationException;
    }
}

