/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyImpl
extends JSQualifiedNamedElementBaseImpl<JSPropertyStub>
implements JSProperty,
StubBasedPsiElement<JSPropertyStub>,
JSIndexingDataHolder<JSPropertyStub> {
    @NonNls
    private static final String EXTEND_PROPERTY_NAME = "extend";
    @NonNls
    private static final String IMPLEMENT_PROPERTY_NAME = "implement";
    @NonNls
    private static final String MIXES_PROPERTY_NAME = "include";
    private static final TokenSet PROPERTY_NAME_SEARCH_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.PROPERTY_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COLON})});
    private static Map<String, SmartList<FrameworkIndexingHandler>> ourFrameworkHandlers = null;

    public JSPropertyImpl(ASTNode node) {
        super(node);
    }

    public JSPropertyImpl(JSPropertyStub stub) {
        this(stub, (IStubElementType)JSStubElementTypes.PROPERTY);
    }

    protected JSPropertyImpl(JSPropertyStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiReference getReference() {
        return this.getPropertyNameReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        PsiPolyVariantReference propertyNameReference = this.getPropertyNameReference();
        if (propertyNameReference != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = propertyNameReference;
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public PsiPolyVariantReference getPropertyNameReference() {
        return (PsiPolyVariantReference)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiElement identifier = this.getNameIdentifier();
            return CachedValueProvider.Result.create((Object)(identifier != null ? new JSPropertyNameReference(this) : null), (Object[])new Object[]{this});
        });
    }

    public String getName() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return StringUtil.replaceUnicodeEscapeSequences((String)StringUtil.unquoteString((String)node.getText()));
        }
        return null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getJSNamespace"));
            }
            return jSNamespace;
        }
        JSSymbolNamespace jSSymbolNamespace = this.getCachedData().mySymbolNamespace;
        if (jSSymbolNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getJSNamespace"));
        }
        return jSSymbolNamespace;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSSymbolNamespace symbolNamespace = this.getCachedData().mySymbolNamespace;
        return symbolNamespace.isLocal() ? null : symbolNamespace.getQualifiedName();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getCachedData().mySymbolNamespace.isExplicitlyDeclared();
    }

    private JSPropertyCachedData getCachedData() {
        return JSPropertyImpl.getCachedData(this);
    }

    public static JSPropertyCachedData getCachedData(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getCachedData"));
        }
        return (JSPropertyCachedData)CachedValuesManager.getCachedValue((PsiElement)property, () -> {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "lambda$getCachedData$1"));
            }
            JSPropertyCachedData data = JSPropertyImpl.calculateCachedData(property);
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{property});
        });
    }

    @NotNull
    private static JSPropertyCachedData calculateCachedData(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "calculateCachedData"));
        }
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        JSDocComment ownDocComment = JSDocumentationUtils.findOwnDocComment((JSElement)property);
        JSSymbolNamespaceImpl symbolNamespace = null;
        if (ownDocComment != null) {
            JSAttributeList.AccessType docCommentAccessType;
            JSQualifiedName namespace = ownDocComment.getNamespace();
            boolean namespaceExplicitlyDeclared = ownDocComment.isNamespaceExplicitlyDeclared();
            JSContext jsContext = ownDocComment.getJSContext();
            if (namespaceExplicitlyDeclared || namespace != null) {
                symbolNamespace = new JSSymbolNamespaceImpl(namespace, jsContext, namespaceExplicitlyDeclared, true, false);
            }
            if ((docCommentAccessType = ownDocComment.getAccessType()) != null) {
                accessType = docCommentAccessType;
            }
        }
        PsiElement parent = property.getParent();
        if (symbolNamespace == null && parent instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)parent;
            JSQualifiedName namespace = JSPropertyImpl.findNamespaceFromSpecialProperties(objectLiteral);
            symbolNamespace = namespace != null ? new JSSymbolNamespaceImpl(namespace, JSContext.UNKNOWN, true, true, false) : JSSymbolUtil.findNamespace((JSExpression)objectLiteral);
        }
        if (symbolNamespace == null) {
            symbolNamespace = JSSymbolNamespaceImpl.UNDEFINED;
        }
        JSPropertyCachedData jSPropertyCachedData = new JSPropertyCachedData(symbolNamespace, accessType);
        if (jSPropertyCachedData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "calculateCachedData"));
        }
        return jSPropertyCachedData;
    }

    @Nullable
    public static JSQualifiedName findNamespaceFromSpecialProperties(JSObjectLiteralExpression expression) {
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            String context = handler.resolveContextFromProperty(expression, true);
            if (context == null) continue;
            return JSQualifiedNameImpl.fromQualifiedName(context);
        }
        return null;
    }

    public ASTNode findNameIdentifier() {
        return JSPropertyImpl.findNameIdentifier(this.getNode());
    }

    public static ASTNode findNameIdentifier(ASTNode myNode) {
        ASTNode funExprNode;
        ASTNode nameNode = myNode.findChildByType(PROPERTY_NAME_SEARCH_SET);
        if (nameNode == null && (funExprNode = myNode.findChildByType(JSElementTypes.FUNCTION_EXPRESSIONS)) != null) {
            ASTNode firstIdentifier = funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
            if ((JSPropertyImpl.isGetIdentifier(firstIdentifier) || JSPropertyImpl.isSetIdentifier(firstIdentifier)) && firstIdentifier.getTreeNext() != null) {
                return funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES, firstIdentifier.getTreeNext());
            }
            return firstIdentifier;
        }
        return nameNode != null && JSKeywordSets.PROPERTY_NAMES.contains(nameNode.getElementType()) ? nameNode : null;
    }

    public boolean isGetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isGetProperty();
    }

    @Nullable
    static ASTNode findAccessNodeAsIdentifier(IElementType accessType, ASTNode funExprNode) {
        ASTNode maybeAccessNode = funExprNode.findChildByType(JSTokenTypes.IDENTIFIER);
        if (maybeAccessNode != null) {
            return accessType == JSTokenTypes.GET_KEYWORD && JSPropertyImpl.isGetIdentifier(maybeAccessNode) || accessType == JSTokenTypes.SET_KEYWORD && JSPropertyImpl.isSetIdentifier(maybeAccessNode) ? maybeAccessNode : null;
        }
        return null;
    }

    private static boolean isGetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.GET_KEYWORD;
    }

    private static boolean isSetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.SET_KEYWORD;
    }

    public boolean isSetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isSetProperty();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "setName"));
        }
        ASTNode renamedNode = this.findNameIdentifier();
        ASTNode parent = this.getNode();
        if (renamedNode != null && renamedNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && renamedNode.getFirstChildNode() != null) {
            parent = renamedNode;
            renamedNode = parent.getFirstChildNode();
        }
        assert (renamedNode != null);
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, renamedNode.getElementType());
        parent.replaceChild(renamedNode, nameElement);
        return this;
    }

    public JSExpression getValue() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    public JSVariable getVariable() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.VARIABLES);
        return node != null ? (JSVariable)node.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSProperty((JSProperty)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "processDeclarations"));
        }
        if (lastParent == null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place)) {
            return processor.execute((PsiElement)this, state);
        }
        return true;
    }

    static boolean placeToProcessProperties(PsiElement place) {
        return place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() instanceof JSThisExpression;
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        JSFunctionExpression value = this.tryGetFunctionInitializer();
        if (value != null) {
            ((JSFunctionBaseImpl)value).clearCaches();
        }
    }

    public Icon getIcon(int flags) {
        return JSPropertyImpl.getIcon((JSPsiElementBase)this, this.tryGetFunctionInitializer() != null ? PlatformIcons.METHOD_ICON : PlatformIcons.PROPERTY_ICON, flags);
    }

    public void delete() throws IncorrectOperationException {
        ASTNode myNode = this.getNode();
        JSChangeUtil.removeRangeWithRemovalOfCommas(myNode, myNode.getTreeParent());
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = JSResolveUtil.findUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Nullable
    public static Collection<FrameworkIndexingHandler> getFrameworkHandlersForPropertyName(String name) {
        if (ourFrameworkHandlers == null) {
            THashMap result = new THashMap();
            for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
                for (String s : handler.interestedProperties()) {
                    SmartList handlersForPropertyName = (SmartList)result.get(s);
                    if (handlersForPropertyName == null) {
                        handlersForPropertyName = new SmartList();
                        result.put(s, handlersForPropertyName);
                    }
                    handlersForPropertyName.add((Object)handler);
                }
            }
            ourFrameworkHandlers = result;
        }
        return (Collection)ourFrameworkHandlers.get(name);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        PsiElement grandParent;
        String name = this.getName();
        JSExpression value = this.getValue();
        boolean toProcessProperty = true;
        Collection<FrameworkIndexingHandler> handlers = JSPropertyImpl.getFrameworkHandlersForPropertyName(name);
        JSElementIndexingDataImpl indexingData = null;
        if (name != null && handlers != null) {
            indexingData = new JSElementIndexingDataImpl();
            for (FrameworkIndexingHandler f : handlers) {
                if (f.processProperty(name, (JSElement)value, indexingData)) continue;
                toProcessProperty = false;
            }
            if (!toProcessProperty) {
                return indexingData;
            }
            indexingData = null;
        }
        for (FrameworkIndexingHandler indexingHandler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            indexingData = indexingHandler.processAnyProperty(this, indexingData);
        }
        if (indexingData != null) {
            return indexingData;
        }
        if ((EXTEND_PROPERTY_NAME.equals(name) || IMPLEMENT_PROPERTY_NAME.equals(name) || MIXES_PROPERTY_NAME.equals(name) || "Extends".equals(name) || "Implements".equals(name)) && (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression || value instanceof JSArrayLiteralExpression || value instanceof JSCallExpression) && (grandParent = this.getParent().getParent()) instanceof JSArgumentList) {
            indexingData = new JSElementIndexingDataImpl();
            JSElement qualifyingExpression = JSSymbolUtil.findQualifyingExpressionFromArgumentList((JSArgumentList)grandParent);
            if (qualifyingExpression != null) {
                JSExpression[] classesToExtend = JSSymbolUtil.findClassesNames(value);
                String baseType = JSContextResolver.getQualifierOfExprAsString(qualifyingExpression);
                if (baseType != null) {
                    for (JSExpression classToExtend : classesToExtend) {
                        indexingData.addBaseType(baseType, StringUtil.unquoteString((String)classToExtend.getText()));
                    }
                    if (classesToExtend.length > 0) {
                        return indexingData;
                    }
                }
            }
        } else if (("members".equals(name) || "proto".equals(name) || "statics".equals(name) || "own".equals(name)) && (value instanceof JSCallExpression || value instanceof JSObjectLiteralExpression) && this.getParent().getParent() instanceof JSArgumentList) {
            return new JSElementIndexingDataImpl();
        }
        return null;
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return JSImplicitElementProviderImpl.getIndexingData(this);
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.getCachedData().myAccessType;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getAccessType"));
        }
        return accessType;
    }

    @Nullable
    public String getInitializerReference() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            return stub.getInitializerReference();
        }
        JSExpression value = this.getValue();
        if (value instanceof JSReferenceExpression && ((JSReferenceExpression)value).getQualifier() == null) {
            return ((JSReferenceExpression)value).getReferencedName();
        }
        return null;
    }

    @Nullable
    public JSFunctionExpression tryGetFunctionInitializer() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            StubElement type = StubTreeUtil.findChildStubByType(stub, JSElementTypes.FUNCTION_EXPRESSIONS);
            return type != null ? (JSFunctionExpression)type.getPsi() : null;
        }
        JSExpression value = this.getValue();
        return value instanceof JSFunctionExpression ? (JSFunctionExpression)value : null;
    }

    @Nullable
    public JSObjectLiteralExpression getObjectLiteralExpressionInitializer() {
        return (JSObjectLiteralExpression)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    @Nullable
    public JSLiteralExpression getLiteralExpressionInitializer() {
        return (JSLiteralExpression)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    @NotNull
    public JSContext getJSContext() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getJSContext"));
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().mySymbolNamespace.getJSContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl", "getJSContext"));
        }
        return jSContext;
    }

    @Nullable
    public JSType getType() {
        return (JSType)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, () -> {
            JSType type;
            JSPropertyStub stub = (JSPropertyStub)this.getStub();
            if (stub != null) {
                String typeString = stub.getTypeString();
                type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)this, stub.isTypeExplicitlyDeclared()));
            } else {
                type = this.evaluateType();
            }
            return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        });
    }

    @Nullable
    private JSType evaluateType() {
        String typeName;
        JSNamedElement element;
        PsiElement parent = this.getParent();
        String enumType = JSDocumentationUtils.findEnumType(parent);
        if (enumType != null && parent instanceof JSObjectLiteralExpression && (element = JSUtils.findInitializedElement((JSExpression)parent)) instanceof JSQualifiedNamedElement && (typeName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this, true);
            JSType enumNamespace = JSNamedType.createType(typeName, source, JSContext.STATIC);
            JSType enumElementType = JSTypeUtils.createType(enumType, source);
            return enumElementType != null ? new JSCompositeTypeImpl(source, enumNamespace, enumElementType) : enumNamespace;
        }
        String s = JSDocumentationUtils.findType((PsiElement)this);
        if (s != null) {
            return JSTypeUtils.createType(s, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        }
        if (parent instanceof JSObjectLiteralExpression) {
            JSRecordType.PropertySignature signature;
            JSNamedElement element2 = JSUtils.findInitializedElement((JSExpression)parent);
            JSType type = JSTypeUtils.getTypeOfElement((PsiElement)element2);
            String name = this.getName();
            if (type instanceof JSRecordType && name != null && (signature = ((JSRecordType)type).findPropertySignature(name)) != null) {
                return signature.getType();
            }
        }
        JSExpression value = this.getValue();
        JSType evaluated = JSSymbolUtil.evaluateTypeLocally(value, true);
        return value != null && DialectDetector.isTypeScript((PsiElement)value) ? evaluated : JSTypeUtils.copyWithExplicitlyDeclared(evaluated, false);
    }

    public static class JSPropertyCachedData {
        @NotNull
        public final JSSymbolNamespace mySymbolNamespace;
        @NotNull
        public final JSAttributeList.AccessType myAccessType;

        private JSPropertyCachedData(@NotNull JSSymbolNamespace symbolNamespace, @NotNull JSAttributeList.AccessType type) {
            if (symbolNamespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolNamespace", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl$JSPropertyCachedData", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/impl/JSPropertyImpl$JSPropertyCachedData", "<init>"));
            }
            this.mySymbolNamespace = symbolNamespace;
            this.myAccessType = type;
        }
    }
}

