/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSPropertyNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyNameReference
implements PsiPolyVariantReference {
    @NotNull
    private final JSProperty myProperty;

    public JSPropertyNameReference(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "<init>"));
        }
        this.myProperty = property;
    }

    @NotNull
    public JSProperty getElement() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getElement"));
        }
        return jSProperty;
    }

    public TextRange getRangeInElement() {
        ASTNode nameIdentifier = this.myProperty.findNameIdentifier();
        if (nameIdentifier == null) {
            return this.myProperty.getTextRange();
        }
        int quotesDelta = nameIdentifier.getElementType() == JSTokenTypes.STRING_LITERAL && nameIdentifier.getTextLength() >= 2 ? 1 : 0;
        int startOffsetInParent = nameIdentifier.getPsi().getStartOffsetInParent();
        return new TextRange(startOffsetInParent + quotesDelta, startOffsetInParent + nameIdentifier.getTextLength() - quotesDelta);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!this.myProperty.isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiReference[] nameRefs = this.myProperty.getNameIdentifier() != null ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty.getNameIdentifier()) : EMPTY_ARRAY;
        ResolveResult[] results = JSResolveUtil.resolve(this.myProperty.getContainingFile(), this, new JSPropertyNameResolver(this));
        ResolveResult[] resolveResultArray = this.merge(results, nameRefs, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private ResolveResult[] merge(ResolveResult[] resolves, PsiReference[] refs, boolean incompleteCode) {
        if (refs.length == 0) {
            return resolves;
        }
        ArrayList<ResolveResult> list = new ArrayList<ResolveResult>();
        for (ResolveResult resolveResult : resolves) {
            if (resolveResult.getElement() == this.myProperty) continue;
            list.add(resolveResult);
        }
        for (ResolveResult resolveResult : refs) {
            if (resolveResult instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)resolveResult).multiResolve(incompleteCode);
                list.addAll(Arrays.asList(results));
                continue;
            }
            PsiElement resolve = resolveResult.resolve();
            if (resolve == null || !resolve.isValid()) continue;
            list.add(new JSResolveResult(resolve));
        }
        return list.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.unquoteString((String)this.myProperty.getFirstChild().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myProperty.setName(newElementName);
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiElement element2;
        JSExpression expression;
        JSClass refElementClass;
        if ((element instanceof TypeScriptField || element instanceof TypeScriptFunction) && (refElementClass = JSUtils.getMemberContainingClass(element)) != null) {
            PsiElement resolvedElement = this.resolve();
            if (resolvedElement == element) {
                return true;
            }
            JSClass resolvedElementClass = JSUtils.getMemberContainingClass(resolvedElement);
            if (resolvedElementClass == null) {
                return false;
            }
            if (resolvedElement instanceof JSPsiElementBase) {
                return JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)resolvedElement, refElementClass);
            }
            return false;
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)expression).isReferenceTo(this.resolve());
        }
        if (element instanceof JSProperty && element != (element2 = this.resolve()) && element2 != null && element2 instanceof JSNamedElement) {
            if (!StringUtil.equals((CharSequence)((JSNamedElement)element).getName(), (CharSequence)((JSNamedElement)element2).getName())) {
                return false;
            }
            JSNamespaceEvaluationResult elementNamespace = JSContextResolver.resolveContext(element);
            String elementContext = JSNamespaceEvaluationResult.getQualifiedName(elementNamespace);
            JSNamespaceEvaluationResult element2Namespace = JSContextResolver.resolveContext(element2);
            String element2Context = JSNamespaceEvaluationResult.getQualifiedName(element2Namespace);
            return elementContext == null || element2Context == null || JSTypeUtils.haveAncestorChildRelation(elementContext, element2Context);
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty);
        ArrayList<Object> list = new ArrayList<Object>();
        for (PsiReference reference : references) {
            Object[] variants = reference.getVariants();
            if (variants.length <= 0) continue;
            list.addAll(Arrays.asList(variants));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }
}

