/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTryStatementImpl
extends JSStatementImpl
implements JSTryStatement {
    private static final TokenSet ourCatchesTypeSet = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.CATCH_BLOCK});

    public JSTryStatementImpl(ASTNode node) {
        super(node);
    }

    public JSStatement getStatement() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(type)) {
                return (JSStatement)child.getPsi();
            }
            if (type == JSTokenTypes.FINALLY_KEYWORD) break;
        }
        return null;
    }

    @Nullable
    public JSCatchBlock getCatchBlock() {
        ASTNode catchChild = this.getNode().findChildByType(JSElementTypes.CATCH_BLOCK);
        if (catchChild == null) {
            return null;
        }
        return (JSCatchBlock)catchChild.getPsi();
    }

    public JSCatchBlock[] getAllCatchBlocks() {
        return (JSCatchBlock[])this.findChildrenByClass(JSCatchBlock.class);
    }

    public JSStatement getFinallyStatement() {
        boolean foundFinally = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (foundFinally && JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(type)) {
                return (JSStatement)child.getPsi();
            }
            if (type != JSTokenTypes.FINALLY_KEYWORD) continue;
            foundFinally = true;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSTryStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSTryStatement((JSTryStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

