/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocCommentCachedData {
    private List<Pair<String, String>> myTypedefs;
    private String myType;
    private String myExplicitName;
    private JSQualifiedName myNamespace;
    private boolean myNamespaceExplicitlyDeclared;
    @NotNull
    private JSContext myContext = JSContext.UNKNOWN;
    private boolean mySeemsToBeFunction;
    private JSQualifiedName myClassName;
    private Map<JSQualifiedName, String> myProperties;
    private Set<JSQualifiedName> myOptionals;
    private List<String> myGenericParameters;
    private JSAttributeList.AccessType myAccessType;
    private Collection<String> myBaseTypes;
    private String myEnumType;
    private boolean myIsInterface;
    private boolean myIsClassExplicitly;
    private boolean myHasDeprecatedTag;
    private boolean myHasConstructsTag;
    private String myReturnType;
    private boolean myHasNamespaceTag;
    private boolean myHasLendsTag;
    private JSDocComment.BrowserFamily myBrowser = JSDocComment.BrowserFamily.ANY;
    private List<Pair<JSQualifiedName, String>> myParameters;
    private Map<JSQualifiedName, String> myDefaultValues;
    private String myThisType;
    private String myAlias;
    private boolean myHasAbstractTag;
    private boolean myHasConstTag;

    JSDocCommentCachedData() {
    }

    public void addTypedef(@Nullable String name, @NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "addTypedef"));
        }
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)type));
    }

    @NotNull
    public List<Pair<String, String>> getTypedefs() {
        List<Object> list = this.myTypedefs != null ? this.myTypedefs : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getTypedefs"));
        }
        return list;
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    @Nullable
    public String getExplicitName() {
        return this.myExplicitName;
    }

    public void setExplicitName(String explicitName) {
        this.myExplicitName = explicitName;
    }

    @NotNull
    public JSContext getContext() {
        JSContext jSContext = this.myContext;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getContext"));
        }
        return jSContext;
    }

    public void setContext(@NotNull JSContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "setContext"));
        }
        this.myContext = context;
    }

    public boolean seemsToBeFunction() {
        return this.mySeemsToBeFunction;
    }

    public void setSeemsToBeFunction() {
        this.mySeemsToBeFunction = true;
    }

    @Nullable
    public JSQualifiedName getClassName() {
        return this.myClassName;
    }

    public void setClassName(JSQualifiedName className) {
        this.myClassName = className;
        JSQualifiedName ns = className.getParent();
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myNamespace;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.myNamespaceExplicitlyDeclared;
    }

    public void setNamespace(@Nullable JSQualifiedName namespace) {
        this.myNamespace = namespace;
        this.myNamespaceExplicitlyDeclared = true;
    }

    public void addProperty(@NotNull JSQualifiedName name, @Nullable String type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "addProperty"));
        }
        if (this.myProperties == null) {
            this.myProperties = new THashMap();
        }
        this.myProperties.put(name, type);
    }

    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        return this.myProperties;
    }

    public void clearProperties() {
        this.myProperties = null;
    }

    public void setOptional(@NotNull JSQualifiedName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "setOptional"));
        }
        if (this.myOptionals == null) {
            this.myOptionals = new THashSet();
        }
        this.myOptionals.add(name);
    }

    @NotNull
    public Set<JSQualifiedName> getOptionals() {
        Set<Object> set = this.myOptionals != null ? this.myOptionals : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getOptionals"));
        }
        return set;
    }

    public void addGenericParameter(@NotNull String genericParameter) {
        if (genericParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericParameter", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "addGenericParameter"));
        }
        if (this.myGenericParameters == null) {
            this.myGenericParameters = new SmartList();
        }
        this.myGenericParameters.add(genericParameter);
    }

    @NotNull
    public List<String> getGenericParameters() {
        List<Object> list = this.myGenericParameters == null ? Collections.emptyList() : this.myGenericParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getGenericParameters"));
        }
        return list;
    }

    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        return this.myAccessType;
    }

    public void setAccessType(JSAttributeList.AccessType accessType) {
        this.myAccessType = accessType;
    }

    @Nullable
    public Collection<String> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(String baseType) {
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add(baseType);
    }

    @Nullable
    public String getEnumType() {
        return this.myEnumType;
    }

    public void setEnumType(String enumType) {
        this.myEnumType = enumType;
    }

    public void setIsInterface() {
        this.myIsInterface = true;
        this.setIsClassExplicitly();
    }

    public boolean isInterface() {
        return this.myIsInterface;
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean hasDeprecatedTag() {
        return this.myHasDeprecatedTag;
    }

    public void setHasDeprecatedTag() {
        this.myHasDeprecatedTag = true;
    }

    public boolean hasConstructsTag() {
        return this.myHasConstructsTag;
    }

    public void setHasConstructsTag() {
        this.myHasConstructsTag = true;
    }

    @Nullable
    public String getReturnType() {
        return this.myReturnType;
    }

    public void setReturnType(String returnType) {
        this.myReturnType = returnType;
    }

    public boolean hasNamespaceTag() {
        return this.myHasNamespaceTag;
    }

    public void setHasNamespaceTag() {
        this.myHasNamespaceTag = true;
    }

    public boolean hasLendsTag() {
        return this.myHasLendsTag;
    }

    public void setHasLendsTag() {
        this.myHasLendsTag = true;
    }

    @Nullable
    public String getLendsTagValue() {
        if (!this.hasLendsTag()) {
            return null;
        }
        String value = this.getExplicitName();
        if (value == null) {
            return null;
        }
        if (this.getNamespace() != null) {
            value = this.getNamespace().getQualifiedName() + "." + value;
        }
        if (this.getContext() == JSContext.INSTANCE) {
            value = value + "#";
        }
        return value;
    }

    public void setBrowserFamily(@NotNull JSDocComment.BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamily", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "setBrowserFamily"));
        }
        this.myBrowser = browserFamily;
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocComment.BrowserFamily browserFamily = this.myBrowser;
        if (browserFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getBrowserFamily"));
        }
        return browserFamily;
    }

    public void addParameter(@NotNull JSQualifiedName name, @Nullable String type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "addParameter"));
        }
        if (this.myParameters == null) {
            this.myParameters = new SmartList();
        }
        this.myParameters.add((Pair<JSQualifiedName, String>)Pair.create((Object)name, (Object)type));
    }

    @Nullable
    public List<Pair<JSQualifiedName, String>> getParameters() {
        return this.myParameters;
    }

    public void addDefaultValue(@NotNull JSQualifiedName name, String remainingLineContent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "addDefaultValue"));
        }
        if (this.myDefaultValues == null) {
            this.myDefaultValues = new THashMap();
        }
        this.myDefaultValues.put(name, remainingLineContent);
    }

    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedData", "getDefaultValue"));
        }
        return this.myDefaultValues != null ? this.myDefaultValues.get(name) : null;
    }

    @Nullable
    public String getThisType() {
        return this.myThisType;
    }

    public void setThisType(String thisType) {
        this.myThisType = thisType;
    }

    @Nullable
    public String getAlias() {
        return this.myAlias;
    }

    public void setAlias(String alias) {
        this.myAlias = alias;
    }

    public boolean hasAbstractTag() {
        return this.myHasAbstractTag;
    }

    public void setHasAbstractTag() {
        this.myHasAbstractTag = true;
    }

    public boolean hasConstTag() {
        return this.myHasConstTag;
    }

    public void setHasConstTag() {
        this.myHasConstTag = true;
    }
}

