/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluateContext
implements JSEvaluationResultContext {
    @Nullable
    public final PsiFile targetFile;
    private PsiElement source;
    private JSReferenceExpression myProcessedExpression;
    private final Deque<JSApplyContextElement> myJSElementsToApply;
    private boolean myTypeIsGuessed;
    @Nullable
    private PsiFile myJSModule;
    @NotNull
    private final JSRecursionGuard myRecursionGuard;
    private final Set<String> visitedTypes;

    public JSEvaluateContext(@Nullable PsiFile _targetFile) {
        this(_targetFile, new JSRecursionGuard());
    }

    public JSEvaluateContext(@Nullable PsiFile targetFile, @NotNull JSRecursionGuard recursionGuard) {
        if (recursionGuard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursionGuard", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "<init>"));
        }
        this.visitedTypes = new THashSet();
        this.targetFile = targetFile;
        this.myJSElementsToApply = new ArrayDeque<JSApplyContextElement>(5);
        this.myRecursionGuard = recursionGuard;
    }

    @NotNull
    public static JSEvaluateContext fromEvaluationResultContext(@NotNull JSEvaluationResultContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        if (context instanceof JSEvaluateContext) {
            JSEvaluateContext jSEvaluateContext = (JSEvaluateContext)context;
            if (jSEvaluateContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
            }
            return jSEvaluateContext;
        }
        JSEvaluateContext result = new JSEvaluateContext(null);
        for (JSApplyContextElement element : context.getJSElementsToApply()) {
            result.pushJSElementToApply(element);
        }
        result.setTypeIsGuessed(context.isTypeGuessed());
        result.myJSModule = context.getJSModule();
        JSEvaluateContext jSEvaluateContext = result;
        if (jSEvaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        return jSEvaluateContext;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    public void setProcessedExpression(@Nullable JSReferenceExpression processedExpression) {
        this.myProcessedExpression = processedExpression;
    }

    public PsiElement getSource() {
        return this.source;
    }

    public void setSource(PsiElement source) {
        this.source = source;
    }

    @NotNull
    public JSApplyContextElement popJSElementToApply() {
        JSApplyContextElement jSApplyContextElement = this.myJSElementsToApply.pop();
        if (jSApplyContextElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "popJSElementToApply"));
        }
        return jSApplyContextElement;
    }

    @Override
    @Nullable
    public JSApplyContextElement peekJSElementToApply() {
        return this.myJSElementsToApply.peek();
    }

    @NotNull
    public static JSApplyContextElement createJSElementToApply(@NotNull JSElement elementToApply) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "createJSElementToApply"));
        }
        if (elementToApply instanceof JSNewExpression) {
            JSApplyInstanceContextElement jSApplyInstanceContextElement = new JSApplyInstanceContextElement((JSNewExpression)elementToApply);
            if (jSApplyInstanceContextElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "createJSElementToApply"));
            }
            return jSApplyInstanceContextElement;
        }
        if (elementToApply instanceof JSCallExpression) {
            JSApplyCallElement jSApplyCallElement = new JSApplyCallElement((JSCallExpression)elementToApply);
            if (jSApplyCallElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "createJSElementToApply"));
            }
            return jSApplyCallElement;
        }
        if (elementToApply instanceof JSDestructuringProperty) {
            JSApplyPropertyElement jSApplyPropertyElement = new JSApplyPropertyElement((JSDestructuringProperty)elementToApply);
            if (jSApplyPropertyElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "createJSElementToApply"));
            }
            return jSApplyPropertyElement;
        }
        if (elementToApply instanceof JSDestructuringArray) {
            JSApplyIndexedAccessElement jSApplyIndexedAccessElement = new JSApplyIndexedAccessElement((JSDestructuringArray)elementToApply);
            if (jSApplyIndexedAccessElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "createJSElementToApply"));
            }
            return jSApplyIndexedAccessElement;
        }
        throw new IllegalArgumentException("Wrong JS elementToApply: " + elementToApply.getClass());
    }

    public void pushJSElementToApply(@NotNull JSApplyContextElement elementToApply) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "pushJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
    }

    public void processWithJSElementToApply(@NotNull JSApplyContextElement elementToApply, @NotNull Runnable runnable) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
        runnable.run();
        this.myJSElementsToApply.pop();
    }

    public void processWithoutTopJSElementToApply(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "processWithoutTopJSElementToApply"));
        }
        JSApplyContextElement pop = this.myJSElementsToApply.pop();
        runnable.run();
        this.myJSElementsToApply.push(pop);
    }

    @Override
    public boolean isJSElementsToApplyEmpty() {
        return this.myJSElementsToApply.isEmpty();
    }

    @Override
    public boolean isTypeGuessed() {
        return this.myTypeIsGuessed;
    }

    public void setTypeIsGuessed(boolean typeIsGuessed) {
        this.myTypeIsGuessed = typeIsGuessed;
    }

    @NotNull
    public Deque<JSApplyContextElement> getJSElementsToApply() {
        Deque<JSApplyContextElement> deque = this.myJSElementsToApply;
        if (deque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "getJSElementsToApply"));
        }
        return deque;
    }

    @Override
    @Nullable
    public PsiFile getJSModule() {
        return this.myJSModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withJSModule(@Nullable PsiFile jsModule, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withJSModule"));
        }
        PsiFile jsModuleBefore = this.getJSModule();
        try {
            this.myJSModule = jsModule;
            runnable.run();
        }
        finally {
            this.myJSModule = jsModuleBefore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCombinedContext(@NotNull JSEvaluationResultContext context, @NotNull Runnable runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "withCombinedContext"));
        }
        int sizeBefore = this.myJSElementsToApply.size();
        PsiFile jsModuleBefore = this.myJSModule;
        boolean typeIsGuessedBefore = this.myTypeIsGuessed;
        try {
            for (JSApplyContextElement element : context.getJSElementsToApply()) {
                this.pushJSElementToApply(element);
            }
            this.myJSModule = context.getJSModule();
            this.myTypeIsGuessed |= context.isTypeGuessed();
            runnable.run();
        }
        finally {
            while (this.myJSElementsToApply.size() > sizeBefore) {
                this.popJSElementToApply();
            }
            this.myJSModule = jsModuleBefore;
            this.myTypeIsGuessed = typeIsGuessedBefore;
        }
    }

    @Override
    public boolean isEquivalentTo(JSEvaluationResultContext other) {
        return JSEvaluationResultContext.JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
    }

    @NotNull
    public JSRecursionGuard getRecursionGuard() {
        JSRecursionGuard jSRecursionGuard = this.myRecursionGuard;
        if (jSRecursionGuard == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "getRecursionGuard"));
        }
        return jSRecursionGuard;
    }

    public boolean ensureProcessed(String type) {
        return !this.visitedTypes.add(type);
    }

    public static enum JSEvaluationPlace {
        PARAMETER_TYPE,
        TYPEOF_TYPE,
        DEFAULT,
        FORCE_EVALUATE_TYPE,
        REFERENCE_EXPRESSION;

    }
}

