/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementImpl
extends FakePsiElement
implements JSImplicitElement {
    @NotNull
    protected final JSImplicitElementStructureImpl myStructure;
    @Nullable
    protected final PsiElement myProvider;

    public JSImplicitElementImpl(@NotNull String name, @Nullable PsiElement provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this(new Builder(name, provider));
    }

    public JSImplicitElementImpl(@NotNull String name, @Nullable JSQualifiedName namespace, @Nullable PsiElement provider) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this(new Builder(name, provider).setNamespace(namespace));
    }

    public JSImplicitElementImpl(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this.myStructure = this.createStructure(builder);
        this.myProvider = builder.myProvider;
        assert (this.getType() == JSImplicitElement.Type.Function == this instanceof JSImplicitFunctionImpl);
    }

    public JSImplicitElementImpl(@NotNull JSImplicitElementStructureImpl structure, @Nullable PsiElement provider) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "<init>"));
        }
        this.myStructure = structure;
        this.myProvider = provider;
    }

    protected JSImplicitElementStructureImpl createStructure(Builder builder) {
        return new JSImplicitElementStructureImpl(builder);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "processDeclarations"));
        }
        return processor.execute((PsiElement)this, state);
    }

    @NotNull
    public String getName() {
        String string = this.myStructure.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return this.myStructure.getNamespace();
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myStructure.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getQualifiedName"));
        }
        return string;
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return this.myStructure.isNamespaceExplicitlyDeclared();
    }

    @Nullable
    public String getUserString() {
        return this.myStructure.getUserString();
    }

    @NotNull
    public static JSImplicitElement fromQualifiedName(String qName, @Nullable PsiElement provider) {
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(qualifiedName.getName(), qualifiedName.getParent(), provider);
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "fromQualifiedName"));
        }
        return jSImplicitElementImpl;
    }

    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.myStructure.getType();
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.myStructure.getJSContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.myStructure.getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getAccessType"));
        }
        return accessType;
    }

    public boolean hasMinorImportance() {
        return this.myStructure.hasMinorImportance();
    }

    public boolean isDeprecated() {
        return this.myStructure.isDeprecated();
    }

    @Nullable
    public String getTypeString() {
        return this.myStructure.getTypeString();
    }

    public PsiElement getParent() {
        return this.myProvider;
    }

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect dialect;
        if (this.myProvider != null && (dialect = DialectDetector.languageDialectOfElement(this.myProvider)) != null) {
            JSLanguageDialect jSLanguageDialect = dialect;
            if (jSLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getLanguage"));
            }
            return jSLanguageDialect;
        }
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getLanguage"));
        }
        return javascriptLanguage;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        JSImplicitElementImpl jSImplicitElementImpl = this.myProvider != null ? this.myProvider : this;
        if (jSImplicitElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getNavigationElement"));
        }
        return jSImplicitElementImpl;
    }

    public boolean isConst() {
        return this.myStructure.isConst();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "setName"));
        }
        if (this.myProvider instanceof JSLiteralExpression) {
            ElementManipulators.getManipulator((PsiElement)this.myProvider).handleContentChange(this.myProvider, name);
        }
        if (this.myProvider instanceof PsiNamedElement && StringUtil.equals((CharSequence)this.getName(), (CharSequence)((PsiNamedElement)this.myProvider).getName())) {
            ((PsiNamedElement)this.myProvider).setName(name);
        }
        return this.toBuilder().setName(name).toImplicitElement();
    }

    @NotNull
    protected Builder toBuilder() {
        Builder builder = new Builder(this.getName(), this.myProvider);
        this.fillBuilder(builder);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "toBuilder"));
        }
        return builder2;
    }

    protected void fillBuilder(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "fillBuilder"));
        }
        this.myStructure.fillBuilder(builder);
        builder.setProvider(this.myProvider);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        JSImplicitElement.Type type = this.getType();
        switch (type) {
            case Variable: {
                return PlatformIcons.VARIABLE_ICON;
            }
            case Function: {
                return JSStubElementImpl.blendFlags(PlatformIcons.METHOD_ICON, true, false);
            }
            case Property: {
                return PlatformIcons.PROPERTY_ICON;
            }
            case Namespace: 
            case Class: 
            case Interface: {
                JSIconProvider iconProvider = JSIconProvider.getForLanguage((PsiElement)this.getContainingFile());
                return type == JSImplicitElement.Type.Interface ? iconProvider.getInterfaceIcon() : iconProvider.getClassIcon();
            }
            case Tag: {
                return JSIconProvider.HTML_TAG_ICON;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.myProvider == ((JSImplicitElementImpl)((Object)obj)).myProvider && this.myStructure.equals(((JSImplicitElementImpl)((Object)obj)).myStructure);
    }

    public int hashCode() {
        return this.myStructure.hashCode();
    }

    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this);
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.myStructure.isClassOrInterface();
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    public boolean isExported() {
        return false;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getJSNamespace"));
        }
        return jSNamespaceImpl;
    }

    @NotNull
    public JSImplicitElementStructureImpl getStructure() {
        JSImplicitElementStructureImpl jSImplicitElementStructureImpl = this.myStructure;
        if (jSImplicitElementStructureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl", "getStructure"));
        }
        return jSImplicitElementStructureImpl;
    }

    public static class Builder {
        @NotNull
        protected String myName;
        @Nullable
        protected JSQualifiedName myNamespace;
        protected int myFlags;
        @Nullable
        protected String myTypeString;
        @Nullable
        protected PsiElement myProvider;
        @Nullable
        protected String myUserString;
        @Nullable
        List<JSImplicitParameterStructure> myParameters;
        protected int myOffset;
        protected PsiFile myFile;

        public Builder(@NotNull JSQualifiedName qualifiedName, @Nullable PsiElement provider) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "<init>"));
            }
            this(qualifiedName.getName(), provider);
            this.setNamespace(qualifiedName.getParent());
        }

        public Builder(@NotNull String name, @Nullable PsiElement provider) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "<init>"));
            }
            this.myName = name;
            this.myProvider = provider;
            this.setNamespaceExplicitlyDeclared(true);
            this.setType(JSImplicitElement.Type.Property);
            this.setAccessType(JSAttributeList.AccessType.PACKAGE_LOCAL);
            this.setContext(JSContext.UNKNOWN);
        }

        public Builder setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "setName"));
            }
            this.myName = name;
            return this;
        }

        public Builder setNamespace(@Nullable JSQualifiedName namespace) {
            this.myNamespace = namespace;
            return this;
        }

        public Builder setNamespaceExplicitlyDeclared(boolean namespaceExplicitlyDeclared) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.NAMESPACE_EXPLICITLY_DECLARED_FLAG, namespaceExplicitlyDeclared);
            return this;
        }

        public Builder setProperties(JSImplicitElement.Property ... properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, EnumSet.of(properties[0], properties));
            return this;
        }

        public Builder setProperties(@Nullable EnumSet<JSImplicitElement.Property> properties) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.PROPERTIES_FLAG, properties);
            return this;
        }

        public Builder setType(JSImplicitElement.Type type) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.TYPE_FLAG, type);
            return this;
        }

        public Builder setContext(JSContext context) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.JS_CONTEXT_FLAG, context);
            return this;
        }

        public Builder setAccessType(JSAttributeList.AccessType accessType) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.ACCESS_TYPE_FLAG, accessType);
            return this;
        }

        public Builder setTypeString(@Nullable String typeString) {
            this.myTypeString = typeString;
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_TYPE_STRING_FLAG, typeString != null);
            return this;
        }

        public Builder setDeprecated(boolean deprecated) {
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.DEPRECATED_FLAG, deprecated);
            return this;
        }

        @Nullable
        public PsiElement getProvider() {
            return this.myProvider;
        }

        public Builder setProvider(@Nullable PsiElement provider) {
            this.myProvider = provider;
            return this;
        }

        public Builder setUserString(@Nullable String userString) {
            JSImplicitElement.ourUserStringsRegistry.checkRegistered(userString);
            return this.setPossiblyUnregisteredUserString(userString);
        }

        public Builder setPossiblyUnregisteredUserString(@Nullable String userString) {
            this.myUserString = userString;
            this.myFlags = JSImplicitElementStructureImpl.writeFlag(this.myFlags, JSImplicitElementStructureImpl.HAS_USER_STRING_FLAG, userString != null);
            return this;
        }

        public Builder setFlags(int flags) {
            this.myFlags = flags;
            return this;
        }

        public Builder setParameters(@Nullable List<JSImplicitParameterStructure> parameters) {
            this.myParameters = parameters;
            return this;
        }

        public Builder setParametersFromDecorators(@NotNull List<Pair<String, JSParameterTypeDecorator>> parameters) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "setParametersFromDecorators"));
            }
            this.myParameters = parameters.stream().map(JSImplicitParameterStructure::new).collect(Collectors.toList());
            return this;
        }

        public Builder setOffset(int offset) {
            this.myOffset = offset;
            return this;
        }

        public Builder setFile(PsiFile file) {
            this.myFile = file;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.myFlags == builder.myFlags && this.myName.equals(builder.myName) && ComparatorUtil.equalsNullable((Object)this.myNamespace, (Object)builder.myNamespace) && ComparatorUtil.equalsNullable((Object)this.myTypeString, (Object)builder.myTypeString) && ComparatorUtil.equalsNullable((Object)this.myProvider, (Object)builder.myProvider) && ComparatorUtil.equalsNullable((Object)this.myUserString, (Object)builder.myUserString) && ComparatorUtil.equalsNullable(this.myParameters, builder.myParameters);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + (this.myNamespace != null ? this.myNamespace.hashCode() : 0);
            result = 31 * result + this.myFlags;
            result = 31 * result + (this.myTypeString != null ? this.myTypeString.hashCode() : 0);
            result = 31 * result + (this.myProvider != null ? this.myProvider.hashCode() : 0);
            result = 31 * result + (this.myUserString != null ? this.myUserString.hashCode() : 0);
            return result;
        }

        @NotNull
        public JSImplicitElementImpl toImplicitElement() {
            if (this.myFile != null) {
                JSOffsetBasedImplicitElement jSOffsetBasedImplicitElement = new JSOffsetBasedImplicitElement(this, this.myOffset, this.myFile);
                if (jSOffsetBasedImplicitElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "toImplicitElement"));
                }
                return jSOffsetBasedImplicitElement;
            }
            if (JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.TYPE_FLAG, this.myFlags) == JSImplicitElement.Type.Function) {
                JSImplicitFunctionImpl jSImplicitFunctionImpl = new JSImplicitFunctionImpl(this);
                if (jSImplicitFunctionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "toImplicitElement"));
                }
                return jSImplicitFunctionImpl;
            }
            JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl(this);
            if (jSImplicitElementImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "toImplicitElement"));
            }
            return jSImplicitElementImpl;
        }

        @NotNull
        public JSImplicitElementStructureImpl toImplicitElementStructure() {
            if (JSImplicitElementStructureImpl.readFlag(JSImplicitElementStructureImpl.TYPE_FLAG, this.myFlags) == JSImplicitElement.Type.Function) {
                JSImplicitFunctionStructureImpl jSImplicitFunctionStructureImpl = new JSImplicitFunctionStructureImpl(this);
                if (jSImplicitFunctionStructureImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "toImplicitElementStructure"));
                }
                return jSImplicitFunctionStructureImpl;
            }
            JSImplicitElementStructureImpl jSImplicitElementStructureImpl = new JSImplicitElementStructureImpl(this);
            if (jSImplicitElementStructureImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "toImplicitElementStructure"));
            }
            return jSImplicitElementStructureImpl;
        }

        @NotNull
        public Builder copy() {
            Builder copy = new Builder(this.myName, this.myProvider);
            this.copyFieldsTo(copy);
            Builder builder = copy;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "copy"));
            }
            return builder;
        }

        protected void copyFieldsTo(@NotNull Builder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementImpl$Builder", "copyFieldsTo"));
            }
            builder.myNamespace = this.myNamespace;
            builder.myFlags = this.myFlags;
            builder.myTypeString = this.myTypeString;
            builder.myUserString = this.myUserString;
        }
    }
}

