/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.ui.components.JBLabel;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertToClassProcessor
extends BaseRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)JSConvertToClassProcessor.class.getName());
    public static final String DEFINE_PROPERTY = "defineProperty";
    public static final String DEFINE_PROPERTIES = "defineProperties";
    @NotNull
    private final JSFunction myFunction;
    private PsiElement mySearchTarget;
    private UsageInfo[] myInfos;

    public JSConvertToClassProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback, @NotNull JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "<init>"));
        }
        super(project, prepareSuccessfulCallback);
        this.myFunction = function;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createUsageViewDescriptor"));
        }
        JSConvertToClassUsageViewDescriptor jSConvertToClassUsageViewDescriptor = new JSConvertToClassUsageViewDescriptor(this.myFunction);
        if (jSConvertToClassUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "createUsageViewDescriptor"));
        }
        return jSConvertToClassUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        this.mySearchTarget = this.myFunction;
        boolean wasReference = false;
        if (this.myFunction instanceof JSFunctionExpression) {
            if (this.myFunction.getParent() instanceof JSVariable) {
                this.mySearchTarget = this.myFunction.getParent();
            } else if (this.myFunction.getParent() instanceof JSAssignmentExpression && ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression() != null) {
                this.mySearchTarget = ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression().getExpression();
                this.mySearchTarget = this.mySearchTarget instanceof JSReferenceExpression ? ((JSReferenceExpression)this.mySearchTarget).resolve() : this.mySearchTarget;
                wasReference = this.mySearchTarget != null;
                this.mySearchTarget = this.mySearchTarget == null ? this.myFunction : this.mySearchTarget;
            }
        }
        List references = JSDefaultRenameProcessor.getReferences(this.mySearchTarget, false, JSDefaultRenameProcessor.ReferencesType.JS);
        if (wasReference) {
            references = ContainerUtil.filter(references, reference -> this.myFunction.getContainingFile().equals(reference.getElement().getContainingFile()));
        }
        references = ContainerUtil.filter(references, reference -> JSConvertToClassProcessor.getParentAssignment(reference) != null || JSConvertToClassProcessor.parseDefineProperty(reference, true) != null);
        List usages = ContainerUtil.map((Collection)references, reference -> new UsageInfo(reference));
        this.myInfos = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (this.myInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "findUsages"));
        }
        return this.myInfos;
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "customizeUsagesView"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "customizeUsagesView"));
        }
        super.customizeUsagesView(viewDescriptor, usageView);
        UsageViewPresentation presentation = usageView.getPresentation();
        presentation.setShowCancelButton(true);
        presentation.setTargetsNodeText("Function to be converted to class");
        presentation.setCodeUsagesString("Declarations of function members to be converted to class members");
        presentation.setToolwindowTitle("Convert to class");
        presentation.setTabText("refactoring preview");
        if (this.containsDefineProperty()) {
            JPanel panel = new JPanel(new BorderLayout());
            JBLabel label = new JBLabel(JSBundle.message((String)"javascript.refactoring.function.to.es6.class.defineProperty.warning.text", (Object[])new Object[0]));
            label.setIcon(AllIcons.General.BalloonWarning);
            panel.setBackground(MessageType.WARNING.getPopupBackground());
            panel.add((Component)label, "West");
            usageView.setAdditionalComponent((JComponent)panel);
        }
    }

    private boolean containsDefineProperty() {
        if (this.myInfos == null) {
            return false;
        }
        for (UsageInfo info : this.myInfos) {
            List<Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>> list;
            PsiReference reference = info.getReference();
            if (reference == null || (list = JSConvertToClassProcessor.parseDefineProperty(reference, true)) == null) continue;
            return true;
        }
        return false;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        JSStatement statement;
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "performRefactoring"));
        }
        List<UsageInfo> usagesList = JSConvertToClassProcessor.sortUsages(usages);
        ArrayList<UsageInfo> notConvertedUsagesList = new ArrayList<UsageInfo>();
        String name = this.mySearchTarget instanceof JSNamedElement ? ((JSNamedElement)this.mySearchTarget).getName() : this.myFunction.getName();
        JSItemToClassConvertor convertor = new JSItemToClassConvertor(this.myFunction, null).setFunctionName(name);
        for (UsageInfo info : usagesList) {
            PsiReference reference = info.getReference();
            if (reference != null) {
                JSAssignmentExpression assignment = JSConvertToClassProcessor.getParentAssignment(reference);
                if (assignment != null && reference instanceof JSReferenceExpression && ((JSReferenceExpression)reference).getParent() instanceof JSReferenceExpression) {
                    if (convertor.addChildRecursively(info, (JSReferenceExpression)((JSReferenceExpression)reference).getParent(), assignment)) {
                        continue;
                    }
                } else {
                    List<Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>> list = JSConvertToClassProcessor.parseDefineProperty(reference, false);
                    if (list != null) {
                        boolean everythingCorrect = true;
                        for (Trinity<JSReferenceExpression, String, JSObjectLiteralExpression> trinity : list) {
                            if (convertor.processDefineProperty(info, (JSReferenceExpression)trinity.getFirst(), (String)trinity.getSecond(), (JSObjectLiteralExpression)trinity.getThird())) continue;
                            everythingCorrect = false;
                            break;
                        }
                        if (everythingCorrect) continue;
                    }
                }
            }
            notConvertedUsagesList.add(info);
        }
        convertor.convertChildContainersToStaticDeclarations();
        List<UsageInfo> duplicateProperties = convertor.generate();
        notConvertedUsagesList.addAll(ContainerUtil.map(convertor.getStaticDeclarations(), expression -> new UsageInfo((PsiElement)expression)));
        if (this.myFunction.getParent() instanceof JSVariable) {
            statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myFunction, JSStatement.class);
            if (statement != null) {
                statement.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement);
                JSVariable parent = (JSVariable)this.myFunction.getParent();
                parent.delete();
                return;
            }
        } else if (this.myFunction.getParent() instanceof JSAssignmentExpression && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myFunction, JSStatement.class)) != null) {
            statement.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement);
            JSConvertToClassProcessor.removeExpression(null, (JSExpression)((JSAssignmentExpression)this.myFunction.getParent()));
            return;
        }
        PsiElement replace = this.myFunction.replace((PsiElement)convertor.getClazz());
        this.showNotConverted(notConvertedUsagesList, duplicateProperties, replace);
    }

    private void showNotConverted(List<UsageInfo> list, @Nullable List<UsageInfo> duplicateProperties, PsiElement replace) {
        if (duplicateProperties != null) {
            list.addAll(duplicateProperties);
        }
        if (list.isEmpty()) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setShowCancelButton(false);
        presentation.setTargetsNodeText("Function converted to class");
        presentation.setCodeUsagesString("Declarations that were not converted");
        presentation.setToolwindowTitle("Convert to class");
        presentation.setTabText("Refactoring Result");
        List usages = ContainerUtil.map(list, info -> new UsageInfo2UsageAdapter(info));
        UsageViewManager.getInstance((Project)this.myProject).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter(replace)}, usages.toArray(Usage.EMPTY_ARRAY), presentation);
    }

    @NotNull
    private static List<UsageInfo> sortUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "sortUsages"));
        }
        ArrayList<UsageInfo> usagesList = new ArrayList<UsageInfo>(Arrays.asList(usages));
        Collections.sort(usagesList, (o1, o2) -> {
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
                PsiReference ref1 = JSConvertToClassProcessor.getTopReference((PsiReference)e1);
                PsiReference ref2 = JSConvertToClassProcessor.getTopReference((PsiReference)e2);
                if (ref1 instanceof PsiElement && ref2 instanceof PsiElement) {
                    return ((PsiElement)ref1).getText().compareTo(((PsiElement)ref2).getText());
                }
            }
            if (e1 != null && e2 != null) {
                return e1.getText().compareTo(e2.getText());
            }
            return 0;
        });
        ArrayList<UsageInfo> arrayList = usagesList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "sortUsages"));
        }
        return arrayList;
    }

    public static void removeExpression(@Nullable String name, @NotNull JSExpression expression) {
        JSExpression[] arguments;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "removeExpression"));
        }
        if (expression instanceof JSCallExpression && JSConvertToClassProcessor.checkForDefinePropertyName(((JSCallExpression)expression).getMethodExpression(), DEFINE_PROPERTIES) && (arguments = ((JSCallExpression)expression).getArguments()).length == 2 && arguments[1] instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression object = (JSObjectLiteralExpression)arguments[1];
            JSProperty property = object.findProperty(name);
            if (property != null) {
                property.delete();
            }
            if (object.getProperties().length != 0) {
                return;
            }
        }
        if (expression.getParent() instanceof JSCommaExpression) {
            JSCommaExpression comma = (JSCommaExpression)expression.getParent();
            JSExpression other = comma.getLOperand() == expression ? comma.getROperand() : comma.getLOperand();
            comma.replace((PsiElement)other);
        } else if (expression.getParent() instanceof JSExpressionStatement) {
            expression.getParent().delete();
        } else {
            expression.getParent().deleteChildRange((PsiElement)expression, (PsiElement)expression);
        }
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "getAfterData"));
        }
        return super.getAfterData(usages);
    }

    private static PsiReference getTopReference(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "getTopReference"));
        }
        if (!(reference instanceof PsiElement)) {
            return null;
        }
        PsiElement current = (PsiElement)reference;
        while (current instanceof JSReferenceExpression) {
            if (!(current.getParent() instanceof PsiReference)) {
                return (PsiReference)current;
            }
            current = current.getParent();
        }
        return null;
    }

    @Nullable
    private static List<Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>> parseDefineProperty(@NotNull PsiReference reference, boolean onlyCheck) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "parseDefineProperty"));
        }
        PsiReference topReference = JSConvertToClassProcessor.getTopReference(reference);
        if (!(topReference instanceof PsiElement)) {
            return null;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        if (parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression) {
            JSArgumentList list = (JSArgumentList)parent;
            JSCallExpression call = (JSCallExpression)parent.getParent();
            if (JSConvertToClassProcessor.checkForDefinePropertyName(call.getMethodExpression(), DEFINE_PROPERTY) && list.getArguments().length == 3) {
                JSExpression[] arguments = list.getArguments();
                if (!PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)((PsiElement)topReference), (boolean)false)) {
                    return null;
                }
                JSReferenceExpression expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)arguments[0], JSReferenceExpression.class);
                JSLiteralExpression nameLiteral = (JSLiteralExpression)ObjectUtils.tryCast((Object)arguments[1], JSLiteralExpression.class);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)arguments[2], JSObjectLiteralExpression.class);
                if (expression == null || nameLiteral == null || object == null) {
                    return null;
                }
                if (!nameLiteral.isQuotedLiteral()) {
                    return null;
                }
                return Collections.singletonList(Trinity.create((Object)expression, (Object)StringUtil.unquoteString((String)nameLiteral.getText()), (Object)object));
            }
            if (JSConvertToClassProcessor.checkForDefinePropertyName(call.getMethodExpression(), DEFINE_PROPERTIES) && list.getArguments().length == 2) {
                JSExpression[] arguments = list.getArguments();
                if (!PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)((PsiElement)topReference), (boolean)false)) {
                    return null;
                }
                JSReferenceExpression expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)arguments[0], JSReferenceExpression.class);
                JSObjectLiteralExpression object = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)arguments[1], JSObjectLiteralExpression.class);
                if (expression == null || object == null) {
                    return null;
                }
                if (onlyCheck) {
                    return Collections.singletonList(Trinity.create((Object)expression, (Object)"", null));
                }
                JSProperty[] properties = object.getProperties();
                ArrayList<Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>> result = new ArrayList<Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>>();
                for (JSProperty property : properties) {
                    if (!(property.getValue() instanceof JSObjectLiteralExpression)) continue;
                    result.add((Trinity<JSReferenceExpression, String, JSObjectLiteralExpression>)Trinity.create((Object)expression, (Object)property.getName(), (Object)((JSObjectLiteralExpression)property.getValue())));
                }
                return result;
            }
        }
        return null;
    }

    private static boolean checkForDefinePropertyName(@NotNull JSExpression methodExpression, @NotNull String name) {
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForDefinePropertyName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "checkForDefinePropertyName"));
        }
        return methodExpression instanceof JSReferenceExpression && name.equals(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && "Object".equals(((JSReferenceExpression)methodExpression).getQualifier().getText());
    }

    @Nullable
    private static JSAssignmentExpression getParentAssignment(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor", "getParentAssignment"));
        }
        PsiReference topReference = JSConvertToClassProcessor.getTopReference(reference);
        if (!(topReference instanceof PsiElement)) {
            return null;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        if (parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression) {
            return (JSAssignmentExpression)parent.getParent();
        }
        return null;
    }

    protected String getCommandName() {
        return JSBundle.message((String)"javascript.refactoring.function.to.es6.class.command", (Object[])new Object[]{JSFormatUtil.formatMethod(this.myFunction, 1, 0)});
    }
}

