/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemToClassConvertor {
    public static final String PROTOTYPE = "prototype";
    @NotNull
    private final JSFunction myFunction;
    @Nullable
    private String myFunctionName;
    @Nullable
    private final JSAssignmentExpression myParentAssignment;
    private final boolean myNested;
    private Map<String, JSAssignmentExpression> myStaticDeclarations;
    private Map<String, JSAssignmentExpression> myMemberDeclarations;
    private Map<String, JSObjectLiteralExpression> myMemberProps;
    private Map<String, JSObjectLiteralExpression> myStaticProps;
    private final MultiMap<String, UsageInfo> myDuplicateProperties;
    private final Map<String, JSItemToClassConvertor> myChildConvertors;
    private JSFunction myLastAdded;
    private ES6Class myClazz;
    private JSFunction myConstructor;
    private final List<JSAssignmentExpression> myRemoveOld;

    public JSItemToClassConvertor(@NotNull JSFunction function, @Nullable JSAssignmentExpression assignment) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "<init>"));
        }
        this.myStaticDeclarations = new HashMap<String, JSAssignmentExpression>();
        this.myMemberDeclarations = new HashMap<String, JSAssignmentExpression>();
        this.myMemberProps = new HashMap<String, JSObjectLiteralExpression>();
        this.myStaticProps = new HashMap<String, JSObjectLiteralExpression>();
        this.myDuplicateProperties = new MultiMap();
        this.myFunction = function;
        this.myParentAssignment = assignment;
        this.myNested = this.myParentAssignment != null;
        this.myChildConvertors = new HashMap<String, JSItemToClassConvertor>();
        this.myRemoveOld = new ArrayList<JSAssignmentExpression>();
    }

    public JSItemToClassConvertor setFunctionName(@Nullable String functionName) {
        this.myFunctionName = functionName;
        return this;
    }

    public boolean processDefineProperty(@NotNull UsageInfo usageInfo, @NotNull JSReferenceExpression reference, @NotNull String name, @NotNull JSObjectLiteralExpression literal) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "processDefineProperty"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "processDefineProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "processDefineProperty"));
        }
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "processDefineProperty"));
        }
        String referenceName = reference.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        boolean hasDuplicate = this.myDuplicateProperties.containsKey((Object)name);
        if (PROTOTYPE.equals(referenceName)) {
            if (reference.getParent() instanceof JSReferenceExpression) {
                return false;
            }
            this.myDuplicateProperties.putValue((Object)name, (Object)usageInfo);
            if (hasDuplicate) {
                return true;
            }
            this.myMemberProps.put(name, literal);
            return true;
        }
        if (reference.getParent() instanceof JSReferenceExpression) {
            JSItemToClassConvertor convertor = this.myChildConvertors.get(referenceName);
            if (convertor == null) {
                return false;
            }
            return convertor.processDefineProperty(usageInfo, (JSReferenceExpression)reference.getParent(), name, literal);
        }
        this.myDuplicateProperties.putValue((Object)name, (Object)usageInfo);
        if (hasDuplicate) {
            return true;
        }
        this.myStaticProps.put(name, literal);
        return true;
    }

    @NotNull
    private List<UsageInfo> getDuplicatePropertiesUsages() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        for (Map.Entry entry : this.myDuplicateProperties.entrySet()) {
            list.addAll((Collection)entry.getValue());
        }
        for (JSItemToClassConvertor convertor : this.myChildConvertors.values()) {
            list.addAll(convertor.getDuplicatePropertiesUsages());
        }
        ArrayList<UsageInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "getDuplicatePropertiesUsages"));
        }
        return arrayList;
    }

    public boolean addChildRecursively(@NotNull UsageInfo usageInfo, @NotNull JSReferenceExpression reference, @NotNull JSAssignmentExpression assignment) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addChildRecursively"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addChildRecursively"));
        }
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addChildRecursively"));
        }
        String referenceName = reference.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiElement parent = reference.getParent();
        if (JSItemToClassConvertor.isDefinitionInAssignment(parent)) {
            if (PROTOTYPE.equals(referenceName)) {
                return this.addPrototypeChildren(usageInfo, assignment);
            }
            return this.addStaticChild(usageInfo, referenceName, assignment);
        }
        if (parent instanceof JSReferenceExpression) {
            if (PROTOTYPE.equals(referenceName)) {
                return this.addMemberChild(usageInfo, assignment, reference);
            }
            JSItemToClassConvertor convertor = this.myChildConvertors.get(referenceName);
            if (convertor == null) {
                return false;
            }
            return convertor.addChildRecursively(usageInfo, (JSReferenceExpression)parent, assignment);
        }
        return false;
    }

    private boolean addPrototypeChildren(UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addPrototypeChildren"));
        }
        if (assignment.getDefinitionExpression() == null || !(assignment.getDefinitionExpression().getInitializer() instanceof JSObjectLiteralExpression)) {
            return false;
        }
        JSObjectLiteralExpression initializer = (JSObjectLiteralExpression)assignment.getDefinitionExpression().getInitializer();
        JSProperty[] properties = initializer.getProperties();
        boolean success = true;
        for (JSProperty property : properties) {
            JSExpression replacement;
            JSExpressionStatement statement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(this.myFunction.getProject(), "prototype." + property.getName() + "= 1;").getPsi(JSExpressionStatement.class);
            JSStatement baseStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)assignment, JSStatement.class);
            statement = (JSExpressionStatement)baseStatement.getParent().addBefore((PsiElement)statement, (PsiElement)baseStatement);
            JSItemToClassConvertor.moveJSDoc((PsiElement)property, (JSElement)statement);
            JSAssignmentExpression expression = (JSAssignmentExpression)statement.getExpression();
            if (property instanceof ES6FunctionProperty) {
                replacement = JSFunctionsHelper.createAnonymousFunction(this.myFunction.getProject(), (JSFunction)((ES6FunctionProperty)property));
            } else {
                if (property.getValue() == null) {
                    return false;
                }
                replacement = property.getValue();
            }
            expression.getDefinitionExpression().getInitializer().replace((PsiElement)replacement);
            JSReferenceExpression prototypeReference = (JSReferenceExpression)expression.getDefinitionExpression().getExpression().getFirstChild();
            success &= this.addMemberChild(usageInfo, expression, prototypeReference);
        }
        if (success) {
            this.myRemoveOld.add(assignment);
        }
        return success;
    }

    private static boolean isDefinitionInAssignment(PsiElement parent) {
        return parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression;
    }

    public boolean addMemberChild(@NotNull UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment, @NotNull JSReferenceExpression prototypeReference) {
        PsiElement grand;
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addMemberChild"));
        }
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addMemberChild"));
        }
        if (prototypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototypeReference", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addMemberChild"));
        }
        assert (PROTOTYPE.equals(prototypeReference.getReferenceName()));
        PsiElement parent = prototypeReference.getParent();
        if (parent instanceof JSReferenceExpression && JSItemToClassConvertor.isDefinitionInAssignment(grand = parent.getParent())) {
            Pair<String, Boolean> pair = this.checkAssignmentForDuplication(usageInfo, assignment);
            if (pair == null) {
                return false;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) {
                return true;
            }
            this.myMemberDeclarations.put((String)pair.getFirst(), assignment);
            return true;
        }
        return false;
    }

    @Nullable
    private Pair<String, Boolean> checkAssignmentForDuplication(@NotNull UsageInfo usageInfo, @NotNull JSAssignmentExpression assignment) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "checkAssignmentForDuplication"));
        }
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "checkAssignmentForDuplication"));
        }
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        String newName = ((JSReferenceExpression)expression).getReferenceName();
        boolean hasDuplicate = this.myDuplicateProperties.containsKey((Object)newName);
        this.myDuplicateProperties.putValue((Object)newName, (Object)usageInfo);
        return Pair.create((Object)newName, (Object)(!hasDuplicate ? 1 : 0));
    }

    public boolean addStaticChild(UsageInfo usageInfo, @NotNull String referenceName, @NotNull JSAssignmentExpression assignment) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addStaticChild"));
        }
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "addStaticChild"));
        }
        if (assignment.getDefinitionExpression() != null && assignment.getDefinitionExpression().getInitializer() instanceof JSFunctionExpression) {
            this.myChildConvertors.put(referenceName, new JSItemToClassConvertor((JSFunction)assignment.getDefinitionExpression().getInitializer(), assignment));
        } else {
            Pair<String, Boolean> pair = this.checkAssignmentForDuplication(usageInfo, assignment);
            if (pair == null) {
                return false;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) {
                return true;
            }
            this.myStaticDeclarations.put((String)pair.getFirst(), assignment);
        }
        return true;
    }

    public boolean canBeConvertedToStaticDeclaration() {
        if (!(this.myMemberDeclarations.isEmpty() && this.myChildConvertors.isEmpty() && this.myMemberProps.isEmpty() && this.myStaticProps.isEmpty())) {
            return false;
        }
        return PsiTreeUtil.findChildOfType((PsiElement)this.myFunction, JSThisExpression.class) == null;
    }

    public void convertChildContainersToStaticDeclarations() {
        Iterator<Map.Entry<String, JSItemToClassConvertor>> iterator = this.myChildConvertors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JSItemToClassConvertor> next = iterator.next();
            JSItemToClassConvertor convertor = next.getValue();
            convertor.convertChildContainersToStaticDeclarations();
            if (!convertor.canBeConvertedToStaticDeclaration()) continue;
            this.myStaticDeclarations.put(next.getKey(), convertor.getParentAssignment());
            iterator.remove();
        }
    }

    public List<UsageInfo> generate() {
        this.filterDuplicates();
        this.createClassWithConstructor();
        for (JSAssignmentExpression jSAssignmentExpression : JSItemToClassConvertor.orderDeclarations(this.myMemberDeclarations.values())) {
            this.addDefinition(jSAssignmentExpression, false);
        }
        for (Map.Entry entry : this.myMemberProps.entrySet()) {
            this.addProperty((String)entry.getKey(), (JSObjectLiteralExpression)entry.getValue(), false);
        }
        for (Map.Entry entry : this.myStaticProps.entrySet()) {
            this.addProperty((String)entry.getKey(), (JSObjectLiteralExpression)entry.getValue(), true);
        }
        for (Map.Entry entry : this.myChildConvertors.entrySet()) {
            JSItemToClassConvertor convertor = (JSItemToClassConvertor)entry.getValue();
            convertor.generate();
            convertor.getParentAssignment().getDefinitionExpression().getInitializer().replace((PsiElement)convertor.getClazz());
        }
        for (JSAssignmentExpression jSAssignmentExpression : this.myRemoveOld) {
            JSConvertToClassProcessor.removeExpression(null, (JSExpression)jSAssignmentExpression);
        }
        return this.getDuplicatePropertiesUsages();
    }

    private void filterDuplicates() {
        Iterator iterator = this.myDuplicateProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (((Collection)next.getValue()).size() > 1) continue;
            iterator.remove();
        }
        for (String key : this.myDuplicateProperties.keySet()) {
            this.myMemberProps.remove(key);
            this.myStaticProps.remove(key);
            this.myMemberDeclarations.remove(key);
            this.myStaticDeclarations.remove(key);
        }
    }

    private void addProperty(String key, JSObjectLiteralExpression value, boolean isStatic) {
        Pair<FunctionInfo, FunctionInfo> pair = JSItemToClassConvertor.getGetSet(value);
        if (pair == null) {
            JSBlockStatement constructorBlock;
            Boolean writable = JSItemToClassConvertor.getBooleanValue(value.findProperty("writeable"));
            JSProperty valueProperty = value.findProperty("value");
            String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myClazz).FIELD_PREFIX + key;
            String getterBlockText = new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myClazz, innerName).setQualifier("this").generate();
            JSFunction getter = JSFunctionsHelper.createAccessorInClassFromText(this.myClazz.getProject(), JavaScriptGenerateAccessorHandler.GenerationMode.Getter, key, isStatic, getterBlockText, false);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)getter, (PsiElement)this.myLastAdded);
            if (!Boolean.FALSE.equals(writable)) {
                String setterBlockText = new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myClazz, innerName).setter().setQualifier("this").generate();
                JSFunction setter = JSFunctionsHelper.createAccessorInClassFromText(this.myClazz.getProject(), JavaScriptGenerateAccessorHandler.GenerationMode.Setter, key, isStatic, setterBlockText, true);
                this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)setter, (PsiElement)this.myLastAdded);
            }
            if (valueProperty != null && valueProperty.getValue() != null && (constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)this.myConstructor, JSBlockStatement.class)) != null) {
                JSSourceElement[] elements = (JSSourceElement[])PsiTreeUtil.getChildrenOfType((PsiElement)constructorBlock, JSSourceElement.class);
                Object anchor = null;
                anchor = elements != null && elements.length > 0 ? elements[elements.length - 1] : constructorBlock.getFirstChild();
                PsiElement statement = JSChangeUtil.createStatementFromText(this.myClazz.getProject(), "this." + innerName + "=" + valueProperty.getValue().getText() + ";").getPsi();
                constructorBlock.addAfter(statement, anchor);
            }
        } else {
            if (pair.getFirst() != null) {
                JSFunction getter = JSFunctionsHelper.createGetter(this.myFunction.getProject(), ((FunctionInfo)pair.getFirst()).getFunction(), key, isStatic);
                this.addDefinition(getter, ((FunctionInfo)pair.getFirst()).getComment());
            }
            if (pair.getSecond() != null) {
                JSFunction setter = JSFunctionsHelper.createSetter(this.myFunction.getProject(), ((FunctionInfo)pair.getSecond()).getFunction(), key, isStatic);
                this.addDefinition(setter, ((FunctionInfo)pair.getSecond()).getComment());
            }
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)value, JSCallExpression.class);
        if (call != null) {
            JSConvertToClassProcessor.removeExpression(key, (JSExpression)call);
        }
    }

    private void addDefinition(JSFunction getter, PsiComment comment) {
        this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)getter, (PsiElement)this.myLastAdded);
        JSDocumentationUtils.moveJSDoc(comment, (PsiElement)this.myLastAdded);
    }

    private static Boolean getBooleanValue(@Nullable JSProperty property) {
        if (property != null && property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isBooleanLiteral()) {
            return (Boolean)((JSLiteralExpression)property.getValue()).getValue();
        }
        return null;
    }

    private static JSFunction getFunctionValue(@Nullable JSProperty property) {
        if (property instanceof ES6FunctionProperty) {
            return (JSFunction)property;
        }
        return property != null && property.getValue() instanceof JSFunction ? (JSFunction)property.getValue() : null;
    }

    @Nullable
    private static Pair<FunctionInfo, FunctionInfo> getGetSet(JSObjectLiteralExpression object) {
        JSProperty[] properties = object.getProperties();
        JSFunction get = null;
        JSFunction set = null;
        PsiComment getComment = null;
        PsiComment setComment = null;
        for (JSProperty property : properties) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)property);
            if ("get".equals(property.getName())) {
                get = JSItemToClassConvertor.getFunctionValue(property);
                getComment = docComment;
                continue;
            }
            if ("set".equals(property.getName())) {
                set = JSItemToClassConvertor.getFunctionValue(property);
                setComment = docComment;
                continue;
            }
            return null;
        }
        if (get == null && set == null) {
            return null;
        }
        return Pair.create((Object)(get == null ? null : new FunctionInfo(get, getComment)), (Object)(set == null ? null : new FunctionInfo(set, setComment)));
    }

    private static List<JSAssignmentExpression> orderDeclarations(Collection<JSAssignmentExpression> set) {
        ArrayList<JSAssignmentExpression> result = new ArrayList<JSAssignmentExpression>(set);
        Collections.sort(result, (o1, o2) -> {
            if (!o1.getContainingFile().equals(o2.getContainingFile())) {
                return o1.getContainingFile().getVirtualFile().getUrl().compareTo(o2.getContainingFile().getVirtualFile().getUrl());
            }
            return new Integer(o1.getTextRange().getStartOffset()).compareTo(o2.getTextRange().getStartOffset());
        });
        return result;
    }

    private void createClassWithConstructor() {
        Project project = this.myFunction.getProject();
        if (this.myNested) {
            JSVarStatement statement = (JSVarStatement)JSChangeUtil.createStatementFromText(project, "var a = class {};", JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSVarStatement.class);
            JSExpression initializer = statement.getVariables()[0].getInitializer();
            assert (initializer instanceof ES6Class);
            this.myClazz = (ES6Class)initializer;
        } else {
            String name = this.myFunctionName != null ? this.myFunctionName : this.myFunction.getName();
            PsiFile dummy = JSChangeUtil.createJSFileFromText(project, "class " + name + "{}", JavaScriptSupportLoader.ECMA_SCRIPT_6);
            assert (dummy.getFirstChild() instanceof ES6Class);
            this.myClazz = (ES6Class)dummy.getFirstChild();
        }
        String constructorTemplateText = JSClassUtils.createConstructorSignatureForClass((JSClass)this.myClazz, true) + "() {}";
        this.myConstructor = (JSFunction)JSChangeUtil.createClassMemberFromText(project, constructorTemplateText, JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
        assert (this.myConstructor.getParameterList() != null);
        if (this.myFunction.getParameterList() != null) {
            JSFunctionsHelper.moveParameters(this.myFunction, this.myConstructor);
        }
        JSFunctionsHelper.moveFunctionBody(this.myFunction, this.myConstructor);
        this.myLastAdded = this.myConstructor = (JSFunction)BaseCreateMethodsFix.addMethodToClassWithoutAnchor((JSClass)this.myClazz, JavaScriptSupportLoader.ECMA_SCRIPT_6, (PsiElement)this.myConstructor, null);
        JSItemToClassConvertor.moveJSDoc((PsiElement)this.myFunction, (JSElement)this.myConstructor);
    }

    private void addDefinition(JSAssignmentExpression assignment, boolean isStatic) {
        Project project = assignment.getProject();
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return;
        }
        String newName = ((JSReferenceExpression)expression).getReferenceName();
        JSExpression initializer = assignment.getDefinitionExpression().getInitializer();
        if (initializer instanceof JSFunctionExpression) {
            JSFunction method = (JSFunction)JSChangeUtil.createClassMemberFromText(project, (isStatic ? "static " : "") + newName + "() {}", JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
            JSParameterList parameters = ((JSFunctionExpression)initializer).getParameterList();
            if (parameters != null) {
                JSFunctionsHelper.moveParameters((JSFunction)((JSFunctionExpression)initializer), method);
            }
            JSFunctionsHelper.moveFunctionBody((JSFunction)initializer, method);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter((PsiElement)method, (PsiElement)this.myLastAdded);
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), (JSElement)this.myLastAdded);
        } else {
            JSExpressionStatement statement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(project, "this." + newName + "=1;").getPsi(JSExpressionStatement.class);
            assert (statement.getExpression() instanceof JSAssignmentExpression);
            JSAssignmentExpression newAssignment = (JSAssignmentExpression)statement.getExpression();
            newAssignment.getDefinitionExpression().getInitializer().replace(initializer.copy());
            JSSourceElement body = JSItemToClassConvertor.getMethodBody(this.myConstructor);
            statement = (JSExpressionStatement)body.addBefore((PsiElement)statement, body.getLastChild());
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), (JSElement)statement);
        }
        JSItemToClassConvertor.deleteMovedDeclaration((PsiElement)assignment);
    }

    private static void moveJSDoc(@NotNull PsiElement oldElement, @NotNull JSElement newElement) {
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "moveJSDoc"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "moveJSDoc"));
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(oldElement);
        JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)newElement);
    }

    private static void deleteMovedDeclaration(PsiElement assignment) {
        PsiElement parent = assignment.getParent();
        if (parent instanceof JSStatement) {
            parent.getParent().deleteChildRange(parent, parent);
        } else {
            parent.deleteChildRange(assignment, assignment);
        }
    }

    private static JSSourceElement getMethodBody(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor", "getMethodBody"));
        }
        JSSourceElement[] body = function.getBody();
        assert (body.length == 1);
        return body[0];
    }

    @Nullable
    public JSAssignmentExpression getParentAssignment() {
        return this.myParentAssignment;
    }

    public Collection<JSAssignmentExpression> getStaticDeclarations() {
        return this.myStaticDeclarations.values();
    }

    public ES6Class getClazz() {
        return this.myClazz;
    }

    private static class FunctionInfo {
        private final JSFunction myFunction;
        private final PsiComment myComment;

        public FunctionInfo(JSFunction function, PsiComment comment) {
            this.myFunction = function;
            this.myComment = comment;
        }

        public JSFunction getFunction() {
            return this.myFunction;
        }

        public PsiComment getComment() {
            return this.myComment;
        }
    }
}

