/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractedFunctionSignatureInfoBuilder {
    private static final JSFunctionSignatureGenerator JS_GENERATOR = new JSFunctionSignatureGenerator();

    @NotNull
    public String getSignature(@NotNull JSExtractFunctionSettings settings, PsiElement anchor) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getSignature"));
        }
        String string = this.getGenerator().getSignature(this.getSignatureInfo(settings, anchor), anchor).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getSignature"));
        }
        return string;
    }

    protected JSFunctionSignatureGenerator getGenerator() {
        return JS_GENERATOR;
    }

    protected JSFunctionSignatureInfo getSignatureInfo(@NotNull JSExtractFunctionSettings settings, PsiElement anchor) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getSignatureInfo"));
        }
        JSExtractFunctionHandler.IntroductionScope introductionScope = settings.getIntroductionScope();
        JSFunctionSignatureInfo result = new JSFunctionSignatureInfo(settings.getMethodName());
        this.fill(result, settings, introductionScope, anchor);
        return result;
    }

    protected void fill(JSFunctionSignatureInfo result, JSExtractFunctionSettings settings, JSExtractFunctionHandler.IntroductionScope introductionScope, PsiElement anchor) {
        result.setFunctionExpression(settings.makeFunctionExpression());
        result.setScope(this.getScope(settings));
        this.setParams(result, settings);
        if (result.getScope() != JSFunctionSignatureInfo.Scope.JS_OBJECT) {
            PsiElement ref = ExtractedFunctionSignatureGenerator.findClassRefForScope(anchor, introductionScope.getParent());
            result.setFunctionAnchor(ref == null ? null : ref.getText());
        }
    }

    protected JSFunctionSignatureInfo.Scope getScope(@NotNull JSExtractFunctionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getScope"));
        }
        JSExtractFunctionHandler.IntroductionScope introductionScope = settings.getIntroductionScope();
        if (introductionScope.isClassContext()) {
            return JSFunctionSignatureInfo.Scope.CLASS;
        }
        if (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent)) {
            return JSFunctionSignatureInfo.Scope.JS_OBJECT;
        }
        return JSFunctionSignatureInfo.Scope.GLOBAL;
    }

    protected void setParams(@NotNull JSFunctionSignatureInfo result, @NotNull JSExtractFunctionSettings settings) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "setParams"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "setParams"));
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings);
        List<JSVariable> parameters = JSExtractFunctionHandler.getOrderedParameters(parametersInfo);
        boolean referencesArguments = false;
        for (JSVariable p : parameters) {
            if (JSExtractFunctionHandler.isArgumentsReference(p)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(p);
            if (parameterInfo != null && !parameterInfo.used) continue;
            result.addParameter((Couple<String>)Couple.of((Object)(parameterInfo != null ? parameterInfo.name : p.getName()), (Object)this.getStringType(p, parameterInfo)));
        }
        if (referencesArguments) {
            result.addParameter((Couple<String>)Couple.of((Object)"arguments", (Object)"$varArgs$"));
        }
    }

    @Nullable
    protected String getStringType(@NotNull JSVariable variable, @Nullable JSExtractFunctionSettings.ParameterInfo parameterInfo) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getStringType"));
        }
        return null;
    }

    protected static void setAccessType(JSFunctionSignatureInfo result, JSExtractFunctionSettings settings) {
        result.setAccessType(settings.getAccessType());
    }

    @Nullable
    protected static String getStringTypeImpl(@NotNull JSVariable variable, @Nullable JSExtractFunctionSettings.ParameterInfo parameterInfo) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder", "getStringTypeImpl"));
        }
        String type = null;
        if (parameterInfo != null) {
            type = parameterInfo.type;
        } else {
            JSType variableType = variable.getType();
            if (variableType != null && !(variableType instanceof JSTypeofTypeImpl)) {
                type = variableType.getTypeText(JSType.TypeTextFormat.CODE);
            }
        }
        return type;
    }

    protected static void setStatic(JSFunctionSignatureInfo result, JSExtractFunctionSettings settings, PsiElement anchor) {
        result.setStatic(settings.makeStatic() || JSResolveUtil.calculateStaticFromContext(anchor));
    }
}

