/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionSignatureInfo {
    public static final String VAR_ARG_TYPE = "$varArgs$";
    @NotNull
    private final List<Couple<String>> myParameters;
    @NotNull
    private final String myFunctionName;
    @Nullable
    private String myReturnType;
    private boolean myIsFunctionExpression;
    private String myTypeParameterList;
    @NotNull
    private Scope myScope;
    private boolean myIsStatic;
    @NotNull
    private JSAttributeList.AccessType myAccessType;
    @Nullable
    private String myFunctionAnchor;

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.myAccessType;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "getAccessType"));
        }
        return accessType;
    }

    public void setAccessType(@NotNull JSAttributeList.AccessType accessType) {
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "setAccessType"));
        }
        this.myAccessType = accessType;
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public void setStatic(boolean isStatic) {
        this.myIsStatic = isStatic;
    }

    @Nullable
    public String getFunctionAnchor() {
        return this.myFunctionAnchor;
    }

    public void setFunctionAnchor(@Nullable String functionAnchor) {
        this.myFunctionAnchor = functionAnchor;
    }

    @NotNull
    public Scope getScope() {
        Scope scope = this.myScope;
        if (scope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "getScope"));
        }
        return scope;
    }

    public void setScope(@NotNull Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "setScope"));
        }
        this.myScope = scope;
    }

    public JSFunctionSignatureInfo(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "<init>"));
        }
        this.myParameters = ContainerUtil.newArrayList();
        this.myScope = Scope.GLOBAL;
        this.myIsStatic = false;
        this.myAccessType = JSAttributeList.AccessType.PUBLIC;
        this.myFunctionName = name;
    }

    public void setFunctionExpression(boolean isFunctionalExpression) {
        this.myIsFunctionExpression = isFunctionalExpression;
    }

    public void setReturnType(@Nullable String returnType) {
        this.myReturnType = returnType;
    }

    public boolean isFunctionExpression() {
        return this.myIsFunctionExpression;
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "getFunctionName"));
        }
        return string;
    }

    public void addParameter(@NotNull Couple<String> parameterAndType) {
        if (parameterAndType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterAndType", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "addParameter"));
        }
        this.myParameters.add(parameterAndType);
    }

    public void addParameterAndType(@NotNull String parameterName, @Nullable String type) {
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "addParameterAndType"));
        }
        this.myParameters.add((Couple<String>)Couple.of((Object)parameterName, (Object)type));
    }

    @NotNull
    public List<Couple<String>> getParameters() {
        List<Couple<String>> list = this.myParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureInfo", "getParameters"));
        }
        return list;
    }

    @Nullable
    public String getReturnType() {
        return this.myReturnType;
    }

    public String getMyTypeParameterList() {
        return this.myTypeParameterList;
    }

    public void setTypeParameterList(String typeParameterList) {
        this.myTypeParameterList = typeParameterList;
    }

    public static enum Scope {
        GLOBAL,
        CLASS,
        JS_OBJECT;

    }
}

