/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.inline.FunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.InjectionQuoteHandler;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class VarOrFieldInliner
implements InlineHandler.Inliner {
    private final ReadWriteAccessDetector detector;
    private final JSFunction fun;
    private final PsiElement myElement;
    private final MySettings mySettings;
    private final JSExpression myInlinedExpr;
    private final boolean myLocalVar;
    private final boolean myDependsOnContext;

    public VarOrFieldInliner(PsiElement element, MySettings settings) {
        this.myElement = element;
        this.mySettings = settings;
        this.myInlinedExpr = settings.initialized;
        JSVariable var = (JSVariable)element;
        this.myLocalVar = VarOrFieldInliner.isLocalVariable(var);
        this.detector = new JSReadWriteAccessDetector();
        this.fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, JSFunction.class);
        this.myDependsOnContext = JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)this.myInlinedExpr, false, false);
    }

    public MultiMap<PsiElement, String> getConflicts(PsiReference reference, PsiElement referenced) {
        final PsiElement expression = reference.getElement();
        final MultiMap conflicts = new MultiMap();
        if (!JSResolveUtil.isSelfReference(expression) && this.detector.getExpressionAccess(expression) != ReadWriteAccessDetector.Access.Read && (this.mySettings.myTarget instanceof JSVariable || VarOrFieldInliner.referencesOurDefinition(expression, this.mySettings.myTarget))) {
            conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.used.as.lvalue", (Object[])new Object[0]));
            return conflicts;
        }
        if (this.myLocalVar && this.myDependsOnContext && this.fun != PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class)) {
            JSExpression initializer;
            if (referenced instanceof JSVariable && (initializer = ((JSVariable)referenced).getInitializer()) != null) {
                initializer.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                    final Set<String> processed = new THashSet();

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        PsiElement resolve;
                        String referenced;
                        super.visitJSReferenceExpression(node);
                        if (node.getQualifier() == null && (referenced = node.getReferencedName()) != null && this.processed.add(referenced) && conflicts.size() == 0 && (resolve = node.resolve()) != null) {
                            JSFunction funScope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)resolve, JSFunction.class);
                            Object scope = funScope != null ? resolve.getUseScope() : GlobalSearchScope.fileScope((PsiFile)node.getContainingFile());
                            for (PsiReference ref : ReferencesSearch.search((PsiElement)resolve, (SearchScope)scope).findAll()) {
                                if (VarOrFieldInliner.this.detector.getExpressionAccess(ref.getElement()) == ReadWriteAccessDetector.Access.Read) continue;
                                conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                            }
                        }
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        super.visitJSThisExpression(node);
                        conflicts.putValue((Object)expression, (Object)JSBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                    }
                });
            }
            return conflicts.size() != 0 ? conflicts : null;
        }
        return JSRefactoringConflictsUtil.calcAccessibilityConflicts(reference, (JSAttributeListOwner)referenced, JSVisibilityUtil.DEFAULT_OPTIONS);
    }

    public void inlineUsage(UsageInfo usage, PsiElement referenced) {
        PsiElement usageElement = usage.getElement();
        if (usageElement == null) {
            return;
        }
        if (usageElement instanceof JSLiteralExpression) {
            PsiReference reference;
            ProperTextRange rangeInElement = usage.getRangeInElement();
            PsiReference psiReference = reference = rangeInElement != null ? usageElement.findReferenceAt(rangeInElement.getStartOffset()) : null;
            if (reference instanceof JSTextReference && reference.isSoft()) {
                return;
            }
        }
        if (this.mySettings.myTarget instanceof JSDefinitionExpression ? !VarOrFieldInliner.referencesOurDefinition(usageElement, this.mySettings.myTarget) : usageElement.getParent() == referenced) {
            return;
        }
        PsiElement replacementElement = this.mySettings.getReplacement(usageElement);
        if (usageElement instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)usageElement).getQualifier();
            String s = FunctionInliner.buildReplacement(replacementElement, (JSExpression)usageElement, (Map<JSReferenceExpression, RangeMarker>)new THashMap(), Collections.emptyMap(), (Map<RangeMarker, JSParameter>)new THashMap(), qualifier, false);
            PsiElement parent = usageElement.getParent();
            if (parent instanceof ES6Property && ((ES6Property)parent).isShorthanded()) {
                String objectLiteralText = "{ " + ((JSReferenceExpression)usageElement).getReferenceName() + ": " + s + "}";
                PsiElement objectLiteral = JSInheritedLanguagesHelper.createExpressionFromText(objectLiteralText, replacementElement, true);
                usageElement = parent;
                replacementElement = ((JSObjectLiteralExpression)objectLiteral).getFirstProperty();
            } else {
                replacementElement = JSInheritedLanguagesHelper.createExpressionFromText(s, replacementElement, true);
            }
        }
        Object element = usageElement instanceof JSExpression && replacementElement instanceof JSExpression ? JSChangeUtil.replaceExpression((JSExpression)usageElement, (JSExpression)replacementElement) : usageElement.replace(replacementElement);
        this.mySettings.addRangeHighlighterForPsiElement((PsiElement)element);
    }

    private static boolean referencesOurDefinition(PsiElement usageElement, PsiElement target) {
        return VarOrFieldInliner.findDefinition(usageElement) == target;
    }

    private static PsiElement findDefinition(PsiElement usageElement) {
        if (usageElement instanceof JSReferenceExpression) {
            PsiElement usageElementParent = usageElement.getParent();
            String referencedName = ((JSReferenceExpression)usageElement).getReferencedName();
            if (usageElementParent instanceof JSNamedElement || referencedName == null) {
                return null;
            }
            SinkResolveProcessor<ResolveResultSink> p = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            p.setLocalResolve(true);
            JSResolveUtil.treeWalkUp(p, usageElement, usageElementParent, usageElement);
            return p.getResult();
        }
        return null;
    }

    private static boolean isLocalVarOrField(PsiElement element) {
        return element instanceof JSVariable && (VarOrFieldInliner.isLocalVariable((JSVariable)element) || JSResolveUtil.findParent(element) instanceof JSClass);
    }

    static boolean isLocalVariable(JSVariable jsVariable) {
        return !(jsVariable instanceof JSParameter) && jsVariable.getUseScope() instanceof LocalSearchScope;
    }

    public static InlineHandler.Settings handleVariable(PsiElement element, @Nullable Editor editor, boolean invokedOnReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean isSelfReference) {
        String problemKey = null;
        if (VarOrFieldInliner.isLocalVarOrField(element)) {
            if (((JSVariable)element).getInitializer() != null) {
                return new MySettings(element, invokedOnReference && JSResolveUtil.findParent(element) instanceof JSClass, editor, isSelfReference);
            }
            if (invokedOnReference) {
                PsiFile file = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(editor.getDocument());
                PsiReference invokedOnRef = file.findReferenceAt(editor.getCaretModel().getOffset());
                JSDefinitionExpression expr = null;
                if (invokedOnRef instanceof JSReferenceExpression) {
                    PsiElement grandParent;
                    PsiElement parent = invokedOnRef.getElement().getParent();
                    if (!(parent instanceof JSDefinitionExpression)) {
                        parent = VarOrFieldInliner.findDefinition((PsiElement)((JSReferenceExpression)invokedOnRef));
                    }
                    if (parent instanceof JSDefinitionExpression && (grandParent = parent.getParent()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getROperand() != null) {
                        expr = (JSDefinitionExpression)parent;
                    }
                }
                if (expr != null) {
                    boolean foundDefinitionUsages = false;
                    for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                        if (!(ref instanceof JSReferenceExpression) || !VarOrFieldInliner.referencesOurDefinition((PsiElement)ref, (PsiElement)expr)) continue;
                        foundDefinitionUsages = true;
                        break;
                    }
                    if (foundDefinitionUsages) {
                        return new MySettings((PsiElement)expr, true, editor, isSelfReference);
                    }
                    problemKey = "javascript.refactoring.cannot.find.usages.of.definition.to.inline";
                } else {
                    problemKey = "javascript.refactoring.cannot.find.definition.to.inline";
                }
            } else {
                problemKey = "javascript.refactoring.cannot.not.inline.noninitialized.definition";
            }
        }
        if (problemKey == null) {
            problemKey = "javascript.refactoring.cannot.inline.nonlocal.variable";
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JSBundle.message((String)problemKey, (Object[])new Object[0]), (String)JSBundle.message((String)"javascript.refactoring.inline.variable.title", (Object[])new Object[0]), (String)"refactoring.inlineVariable");
        return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
    }

    public static void removeDefinition(PsiElement element, MySettings settings) {
        boolean b;
        JSExpressionStatement expressionStatement;
        PsiElement toRemove = settings.myTarget;
        if (toRemove instanceof JSDefinitionExpression && (expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)toRemove, JSExpressionStatement.class)) != null) {
            toRemove = expressionStatement;
        }
        FormatFixer toRemoveFormatFixer = FormatFixer.create(toRemove, FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        toRemove.delete();
        toRemoveFormatFixer.fixFormat();
        if (element instanceof JSNamedElement && toRemove != element && (b = JSUnusedGlobalSymbolsInspection.calcUnused((JSNamedElement)element, element.getUseScope()))) {
            FormatFixer fi = FormatFixer.create(element, FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
            element.delete();
            fi.fixFormat();
        }
    }

    static class MySettings
    extends JSInlineHandler.JSInlineSettingsBase {
        private final PsiElement myTarget;
        private JSExpression initialized;

        MySettings(PsiElement target, boolean oneRef, Editor editor, boolean isSelfReference) {
            super(oneRef, target.getContainingFile(), editor, isSelfReference);
            this.myTarget = target;
            if (target instanceof JSVariable) {
                this.initialized = ((JSVariable)target).getInitializer();
            } else if (target instanceof JSDefinitionExpression) {
                this.initialized = ((JSAssignmentExpression)target.getParent()).getROperand();
            }
            assert (this.initialized != null);
        }

        @Override
        public void highlightUsages(Editor editor, Collection<PsiReference> refs) {
            ArrayList<PsiElement> refsToHighlight = new ArrayList<PsiElement>();
            boolean referencingDef = this.myTarget instanceof JSDefinitionExpression;
            for (PsiReference ref : refs) {
                if (referencingDef && !VarOrFieldInliner.referencesOurDefinition((PsiElement)ref, this.myTarget)) continue;
                refsToHighlight.add(ref.getElement());
            }
            Project project = editor.getProject();
            HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(PsiUtilCore.toPsiElementArray(refsToHighlight)), false);
            if (Comparing.equal((Object)JSInlineHandler.getPhysicalFileOfEditor(editor), (Object)JSInlineHandler.getVirtualFile(this.myTarget.getContainingFile()))) {
                HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(new PsiElement[]{this.myTarget instanceof JSVariable ? ((JSVariable)this.myTarget).getNameIdentifier() : this.myTarget}), true);
            }
            HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        }

        public PsiElement getReplacement(PsiElement usageElement) {
            InjectionQuoteHandler quoteHandler = new InjectionQuoteHandler(usageElement);
            JSExpression result = this.initialized;
            if (quoteHandler.hasSomethingToDo()) {
                Document document = quoteHandler.fixQuotes((PsiElement)result);
                result = (JSExpression)JSChangeUtil.createExpressionFromText(this.myTarget.getProject(), document.getText(), JSUtils.getDialect(this.myTarget.getContainingFile())).getPsi();
            }
            return result;
        }
    }
}

