/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;

public class JSApplicationSettings {
    private static final String SHOW_TYPESCRIPT_AUTO_IMPORT = "typescript.show.auto.import";
    private static final String MERGE_IMPORTS = "typescript.merge.auto.import";
    private static final String USE_CONFIG = "typescript.use.config.auto.import";
    private static final String TS_NODE_MODULES_RESOLUTION = "typescript.use.directory.import";

    public static JSApplicationSettings getInstance() {
        return (JSApplicationSettings)ServiceManager.getService(JSApplicationSettings.class);
    }

    public boolean isShowTypeScriptAutoImport() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_TYPESCRIPT_AUTO_IMPORT, true);
    }

    public void setShowTypeScriptAutoImport(boolean showTypeScriptAutoImport) {
        PropertiesComponent.getInstance().setValue(SHOW_TYPESCRIPT_AUTO_IMPORT, Boolean.toString(showTypeScriptAutoImport));
    }

    public boolean isMergeImports() {
        return PropertiesComponent.getInstance().getBoolean(MERGE_IMPORTS, true);
    }

    public boolean isUseAbsoluteConfigPath() {
        return PropertiesComponent.getInstance().getBoolean(USE_CONFIG, false);
    }

    public void setUseAbsoluteConfigPath(boolean value) {
        PropertiesComponent.getInstance().setValue(USE_CONFIG, Boolean.toString(value));
    }

    public void setUseNodeModulesResolutionImports(boolean value) {
        PropertiesComponent.getInstance().setValue(TS_NODE_MODULES_RESOLUTION, Boolean.toString(value));
    }

    public boolean isUseNodeModulesResolutionImports() {
        return PropertiesComponent.getInstance().getBoolean(TS_NODE_MODULES_RESOLUTION, true);
    }

    public void setMergeImports(boolean isMergeImports) {
        PropertiesComponent.getInstance().setValue(MERGE_IMPORTS, Boolean.toString(isMergeImports));
    }
}

