/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureViewElement
implements StructureViewTreeElement {
    private final Set<String> myParentReferencedNames;
    protected PsiElement myElement;
    protected List<PsiElement> myElements;
    protected final boolean myIncludeInherited;
    private final boolean isEcma;
    private boolean myInherited;
    private final JSStructureItemPresentation myPresentation;

    public JSStructureViewElement(PsiElement element, boolean includeInherited, boolean ecma) {
        this(Collections.singletonList(element), includeInherited, null, ecma);
    }

    public JSStructureViewElement(List<PsiElement> elements, boolean includeInherited, Set<String> parentReferencedNames, boolean ecma) {
        this.myElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        this.myElements = elements;
        this.myIncludeInherited = includeInherited;
        this.myParentReferencedNames = parentReferencedNames != null ? parentReferencedNames : Collections.emptySet();
        this.myPresentation = this.createPresentation();
        this.isEcma = ecma;
    }

    public PsiElement getValue() {
        return this.myElement;
    }

    List<PsiElement> getAllElements() {
        return this.myElements;
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.myElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        final PsiElement element = this.getValue();
        if (!element.isValid()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureViewElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        THashSet referencedNames = new THashSet(this.myParentReferencedNames);
        JSQualifiedName ns = this.getProvidedNamespaceByElement(element);
        List<StructureViewTreeElement> children = this.collectMyElements((THashSet<String>)referencedNames, ns, element.getContainingFile());
        List<StructureViewTreeElement> elementsFromSupers = this.getSuperElements(element, ns, (Set<String>)referencedNames);
        Collections.sort(children, new Comparator<StructureViewTreeElement>(){
            private final InjectedLanguageManager myInstance;
            {
                this.myInstance = InjectedLanguageManager.getInstance((Project)element.getProject());
            }

            @Override
            public int compare(StructureViewTreeElement _o1, StructureViewTreeElement _o2) {
                StubElement s2;
                PsiElement e1 = JSStructureViewElement.getPsiElement(_o1);
                PsiElement e2 = JSStructureViewElement.getPsiElement(_o2);
                StubElement s1 = e1 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)e1).getStub() : null;
                StubElement stubElement = s2 = e2 instanceof StubBasedPsiElement ? ((StubBasedPsiElement)e2).getStub() : null;
                if (s1 != null && s2 == null) {
                    return -1;
                }
                if (s1 == null && s2 != null) {
                    return 1;
                }
                int offset1 = s1 != null ? ((ObjectStubBase)s1).id : this.myInstance.injectedToHost(e1, e1.getTextOffset());
                int offset2 = s2 != null ? ((ObjectStubBase)s2).id : this.myInstance.injectedToHost(e2, e2.getTextOffset());
                return offset1 - offset2;
            }
        });
        if (elementsFromSupers != null && !elementsFromSupers.isEmpty()) {
            children = new ArrayList<StructureViewTreeElement>(children);
            THashMap functionsByNames = new THashMap();
            for (StructureViewTreeElement child : children) {
                JSFunction function;
                String name;
                PsiElement el = JSStructureViewElement.getPsiElement(child);
                if (!(el instanceof JSFunction) || (name = (function = (JSFunction)el).getName()) == null) continue;
                functionsByNames.put(name, function);
            }
            for (StructureViewTreeElement superTreeElement : elementsFromSupers) {
                JSFunction superFunction;
                JSFunction function;
                PsiElement superElement = JSStructureViewElement.getPsiElement(superTreeElement);
                boolean addSuperElement = true;
                if (superElement instanceof JSFunction && (function = (JSFunction)functionsByNames.get((superFunction = (JSFunction)superElement).getName())) != null) {
                    addSuperElement = false;
                }
                if (!addSuperElement) continue;
                children.add(superTreeElement);
            }
        }
        StructureViewTreeElement[] structureViewTreeElementArray = children.toArray(new StructureViewTreeElement[children.size()]);
        if (structureViewTreeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureViewElement", "getChildren"));
        }
        return structureViewTreeElementArray;
    }

    protected List<StructureViewTreeElement> getSuperElements(PsiElement element, JSQualifiedName namespace, Set<String> referencedNames) {
        PsiFile file = element.getContainingFile();
        if (file instanceof JSFile && ((JSFile)file).isMinified()) {
            return null;
        }
        List<StructureViewTreeElement> elementsFromSupers = null;
        if (this.myIncludeInherited) {
            if (element instanceof JSClass) {
                for (JSClass clazz : ((JSClass)element).getSuperClasses()) {
                    StructureViewTreeElement[] structureViewTreeElements = this.createStructureViewElement((PsiElement)clazz, referencedNames).getChildren();
                    elementsFromSupers = new ArrayList<StructureViewTreeElement>(structureViewTreeElements.length);
                    for (StructureViewTreeElement e : structureViewTreeElements) {
                        if (!JSStructureViewElement.isVisible((PsiElement)e.getValue(), element) || !(e instanceof JSStructureViewElement)) continue;
                        ((JSStructureViewElement)e).setInherited();
                        elementsFromSupers.add(e);
                    }
                }
            } else if (!this.isEcma) {
                JSQualifiedName parent;
                String typeName = namespace != null ? namespace.getQualifiedName() : null;
                JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
                if (parent != null && "Object".equals(parent.getQualifiedName())) {
                    typeName = null;
                }
                if (element instanceof JSPsiElementBase && !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)element) && (!(element instanceof JSFunction) || element instanceof JSFunctionExpression) && (!(element instanceof JSVariable) || !JSSymbolUtil.isMeaningfulLocalVariableInitializer(((JSVariable)element).getInitializerOrStub()) || ((JSVariable)element).isLocal()) || !(element instanceof JSNamedElement) && !JSSymbolUtil.isConstructorName(typeName) || element instanceof JSProperty || element instanceof JSImplicitElement && !JSStructureViewElement.isClass((JSImplicitElement)element)) {
                    typeName = null;
                }
                if (typeName != null) {
                    final HashSet visitedTypes = new HashSet();
                    JSTypeEvaluateManager.iterateTypeHierarchy(element, typeName, new JSTypeEvaluateManager.NamespaceProcessor(){

                        @Override
                        public boolean process(String serializedType, VirtualFile file) {
                            visitedTypes.add(JSTypeUtils.getTypeMatchingNamespace(serializedType));
                            return true;
                        }
                    });
                    GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file);
                    MultiMap result = MultiMap.createSmart();
                    for (String type : visitedTypes) {
                        this.addElementsFromNamespace((MultiMap<String, PsiElement>)result, scope, type);
                    }
                    List<StructureViewTreeElement> superElements = this.convertPsiToElements((MultiMap<String, PsiElement>)result, referencedNames);
                    for (StructureViewTreeElement superElement : superElements) {
                        ((JSStructureViewElement)superElement).setInherited();
                    }
                    elementsFromSupers = !superElements.isEmpty() ? superElements : null;
                }
            }
        }
        return elementsFromSupers;
    }

    private static boolean isClass(JSImplicitElement element) {
        JSImplicitElement.Type type = element.getType();
        return type == JSImplicitElement.Type.Class || type == JSImplicitElement.Type.Interface;
    }

    @Nullable
    protected JSQualifiedName getProvidedNamespaceByElement(PsiElement element) {
        JSNamespace jsNamespace;
        if (element instanceof JSElementBase && (jsNamespace = JSNamespaceImpl.buildProvidedNamespace((JSElementBase)element, true)) != null) {
            return jsNamespace.getQualifiedName();
        }
        return null;
    }

    protected JSStructureViewElement createStructureViewElement(PsiElement element, Set<String> parentReferencedNames) {
        return this.createStructureViewElement(Collections.singletonList(element), parentReferencedNames);
    }

    protected JSStructureViewElement createStructureViewElement(List<PsiElement> elements, Set<String> parentReferencedNames) {
        return new JSStructureViewElement(elements, this.myIncludeInherited, parentReferencedNames, this.isEcma);
    }

    public static PsiElement getPsiElement(StructureViewTreeElement element) {
        return (PsiElement)element.getValue();
    }

    protected List<StructureViewTreeElement> collectMyElements(THashSet<String> referencedNamedIds, JSQualifiedName ns, PsiFile contextFile) {
        return this.doCollectMyElements(referencedNamedIds, ns, contextFile, this.myElement, this.myElements, false);
    }

    protected List<StructureViewTreeElement> doCollectMyElements(THashSet<String> referencedNames, JSQualifiedName ns, PsiFile contextFile, PsiElement mainElement, List<PsiElement> mainElements, boolean oneElementOnly) {
        boolean shouldFindNsInDepth;
        boolean myElementIsFile = mainElement instanceof PsiFile;
        boolean bl = shouldFindNsInDepth = myElementIsFile && mainElement.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || mainElement instanceof JSImplicitElement;
        if (mainElement instanceof JSDefinitionExpression && "prototype".equals(((JSDefinitionExpression)mainElement).getName())) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> visitedFiles = new HashSet<PsiFile>();
        visitedFiles.add(contextFile);
        MultiMap children = MultiMap.createSmart();
        ArrayDeque<PsiElement> queue = new ArrayDeque<PsiElement>();
        for (PsiElement element : mainElements) {
            queue.addAll(JSStructureViewElement.gatherChildElements(element, visitedFiles));
        }
        while (!queue.isEmpty()) {
            PsiElement element = (PsiElement)queue.poll();
            JSStructureViewElement.addImplicitChildren(queue, element);
            if (this.shouldSkipProcess(element)) continue;
            String name = this.getName(element, (MultiMap<String, PsiElement>)children);
            if (StringUtil.isNotEmpty((String)name) && !(element instanceof JSDestructuringProperty)) {
                if (JSStructureViewElement.isElementInMyNamespace(element, ns, myElementIsFile, shouldFindNsInDepth)) {
                    this.addElement((MultiMap<String, PsiElement>)children, element, name);
                    if (!oneElementOnly) continue;
                    return this.convertPsiToElements((MultiMap<String, PsiElement>)children, (Set<String>)referencedNames);
                }
                if (element instanceof JSElementBase) {
                    String parentName;
                    JSQualifiedName namespace = ((JSElementBase)element).getJSNamespace().getQualifiedName();
                    JSQualifiedName parent = JSStructureViewElement.findNsInParents(namespace, ns);
                    parent = parent == null && JSStructureViewElement.shouldAddNamespaceFromDefinition(element, namespace, this.myParentReferencedNames) ? namespace : parent;
                    String string = parentName = parent != null ? parent.getName() : null;
                    if (parent != null && this.myParentReferencedNames.contains(name) && Comparing.equal((Object)parent, (Object)namespace)) continue;
                    if (parent != null && !parentName.equals("Window")) {
                        children.putValue((Object)parentName, (Object)new JSStructureImplicitNamespace(parent, element));
                        if (!oneElementOnly) continue;
                        return this.convertPsiToElements((MultiMap<String, PsiElement>)children, (Set<String>)referencedNames);
                    }
                }
            }
            if (JSStructureViewElement.isScopeChangingElement(element)) continue;
            queue.addAll(JSStructureViewElement.gatherChildElements(element, visitedFiles));
        }
        if (ns != null && !oneElementOnly) {
            GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)contextFile);
            this.addElementsFromNamespace((MultiMap<String, PsiElement>)children, scope, ns.getQualifiedName());
        }
        referencedNames.addAll((Collection)children.keySet());
        return this.convertPsiToElements((MultiMap<String, PsiElement>)children, (Set<String>)referencedNames);
    }

    protected boolean shouldSkipProcess(PsiElement element) {
        return false;
    }

    private static boolean shouldAddNamespaceFromDefinition(PsiElement element, JSQualifiedName namespace, Set<String> parentReferencedNames) {
        return namespace != null && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).tryGetFunctionExpressionInitializer() != null && !parentReferencedNames.contains(namespace.getName());
    }

    private static void addImplicitChildren(Queue<PsiElement> queue, PsiElement element) {
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                queue.addAll(elements);
            }
        }
    }

    protected void addElement(MultiMap<String, PsiElement> children, PsiElement element, String name) {
        String key;
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
        String nameOfFunction = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)function);
        PsiElement structureElement = function != null && StringUtil.equals((CharSequence)name, (CharSequence)nameOfFunction) ? function : element;
        String string = key = name != null ? name : "<anonymous>";
        if (!children.get((Object)key).contains(structureElement)) {
            children.putValue((Object)key, (Object)structureElement);
        }
    }

    private void addElementsFromNamespace(MultiMap<String, PsiElement> children, GlobalSearchScope scope, String namespace) {
        boolean isObject = "Object".equals(namespace);
        for (JSPsiElementBase namedElement : JSClassResolver.getInstance().findNamespaceMembers(namespace, scope, true)) {
            String name;
            if (isObject && namedElement.getJSContext() == JSContext.STATIC || (name = this.getName((PsiElement)namedElement, children)) == null) continue;
            this.addElement(children, (PsiElement)namedElement, name);
        }
    }

    protected String getName(PsiElement element, MultiMap<String, PsiElement> children) {
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof JSDefinitionExpression) {
            PsiFile file;
            JSFunction function;
            JSClass clazz;
            JSDefinitionExpression definition = (JSDefinitionExpression)element;
            if ("prototype".equals(definition.getName()) && definition.getJSContext() != JSContext.INSTANCE) {
                return null;
            }
            if (this.isEcma && (clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)(function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)definition, JSFunction.class)), JSClass.class)) != null) {
                return null;
            }
            if ("exports".equals(definition.getName()) && (file = definition.getContainingFile()) instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                return null;
            }
            if (definition.getJSNamespace().getQualifiedName() == null && definition.tryGetFunctionExpressionInitializer() == null && !this.hasStructureElements(element)) {
                return null;
            }
        }
        if (element instanceof JSFunction && ((JSFunction)element).isAnonymousFunctionCall()) {
            return null;
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && PsiTreeUtil.getParentOfType((PsiElement)element, JSAssignmentExpression.class, (boolean)true, (Class[])new Class[]{JSFunction.class}) != null) {
            return String.valueOf(children.size());
        }
        if (JSStructureViewElement.skipVariable(element)) {
            return null;
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) {
            return null;
        }
        return element instanceof JSNamedElementBase ? JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element) : null;
    }

    private boolean hasStructureElements(PsiElement element) {
        return this.doCollectMyElements((THashSet<String>)new THashSet(), this.getProvidedNamespaceByElement(element), element.getContainingFile(), element, Collections.singletonList(element), true).size() != 0;
    }

    private static Collection<? extends PsiElement> gatherChildElements(PsiElement element, Set<PsiFile> visitedFiles) {
        StubElement stub;
        JSExpression value;
        if (element instanceof JSStructureImplicitNamespace) {
            return Collections.singleton(element.getParent());
        }
        if (element instanceof JSAssignmentExpression) {
            SmartList result = new SmartList();
            PsiElement value2 = element;
            while (value2 instanceof JSAssignmentExpression) {
                PsiElement definition = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                ContainerUtil.addIfNotNull((Collection)result, (Object)definition);
                value2 = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            }
            return result;
        }
        if (element instanceof JSDefinitionExpression && (value = ((JSDefinitionExpression)element).getInitializerOrStub()) != null) {
            return Collections.singleton(value);
        }
        if (element instanceof JSIncludeDirective) {
            PsiFile file = ((JSIncludeDirective)element).resolveFile();
            element = file != null && !visitedFiles.contains(file) ? file : element;
            visitedFiles.add(file);
        }
        Object object = element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            return ContainerUtil.map((Collection)stub.getChildrenStubs(), (Function)new Function<StubElement, PsiElement>(){

                public PsiElement fun(StubElement o) {
                    return o.getPsi();
                }
            });
        }
        return Arrays.asList(element.getChildren());
    }

    private List<StructureViewTreeElement> convertPsiToElements(MultiMap<String, PsiElement> children, final Set<String> parentReferencedNames) {
        return ContainerUtil.concat((Iterable)ContainerUtil.map((Collection)children.entrySet(), (Function)new Function<Map.Entry<String, Collection<PsiElement>>, List<StructureViewTreeElement>>(){

            public List<StructureViewTreeElement> fun(Map.Entry<String, Collection<PsiElement>> entry) {
                List value = (List)entry.getValue();
                SmartList staticElements = new SmartList();
                boolean hasInstanceMember = false;
                for (PsiElement element : value) {
                    if (!(element instanceof JSPsiElementBase)) continue;
                    JSContext context = ((JSPsiElementBase)element).getJSContext();
                    if (context == JSContext.STATIC) {
                        staticElements.add((Object)element);
                        continue;
                    }
                    if (context != JSContext.INSTANCE) continue;
                    hasInstanceMember = true;
                }
                if (!staticElements.isEmpty() && hasInstanceMember) {
                    SmartList otherElements = new SmartList();
                    Iterator staticElementsIterator = staticElements.iterator();
                    PsiElement staticElement = (PsiElement)staticElementsIterator.next();
                    for (PsiElement element : value) {
                        if (staticElement == element) {
                            staticElement = staticElementsIterator.hasNext() ? (PsiElement)staticElementsIterator.next() : null;
                            continue;
                        }
                        otherElements.add((Object)element);
                    }
                    return ContainerUtil.newArrayList((Object[])new StructureViewTreeElement[]{this.sortAndCreate((List<PsiElement>)staticElements), this.sortAndCreate((List<PsiElement>)otherElements)});
                }
                return Collections.singletonList(this.sortAndCreate(value));
            }

            private StructureViewTreeElement sortAndCreate(List<PsiElement> value) {
                Collections.sort(value, (e1, e2) -> {
                    if (e1 instanceof JSImplicitElement && !(e2 instanceof JSImplicitElement)) {
                        return 1;
                    }
                    if (e2 instanceof JSImplicitElement && !(e1 instanceof JSImplicitElement)) {
                        return -1;
                    }
                    return 0;
                });
                return JSStructureViewElement.this.createStructureViewElement(value, (Set<String>)parentReferencedNames);
            }
        }));
    }

    private static boolean isVisible(PsiElement namedElement, PsiElement element) {
        JSAttributeListOwner attributeListOwner;
        JSAttributeList attributeList;
        if (namedElement instanceof JSElementBase) {
            JSAttributeList.AccessType type = ((JSElementBase)namedElement).getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (namedElement instanceof JSFunctionItem) {
                return true;
            }
        }
        if (namedElement instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)namedElement).getAttributeList()) != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                return JSResolveUtil.isAccessibleFromCurrentPackage(namedElement, element);
            }
            return type != JSAttributeList.AccessType.PRIVATE;
        }
        return true;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        JSStructureItemPresentation jSStructureItemPresentation = this.myPresentation;
        if (jSStructureItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureViewElement", "getPresentation"));
        }
        return jSStructureItemPresentation;
    }

    @NotNull
    public JSStructureItemPresentation createPresentation() {
        JSStructureItemPresentation jSStructureItemPresentation = new JSStructureItemPresentation(this);
        if (jSStructureItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/structureView/JSStructureViewElement", "createPresentation"));
        }
        return jSStructureItemPresentation;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    private JSStructureViewElement setInherited() {
        this.myInherited = true;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStructureViewElement element = (JSStructureViewElement)o;
        if (this.myInherited != element.myInherited) {
            return false;
        }
        return this.myElements.equals(element.myElements);
    }

    public int hashCode() {
        int result = this.myElements.hashCode();
        result = 31 * result + (this.myInherited ? 1 : 0);
        return result;
    }

    private static boolean isElementInMyNamespace(PsiElement element, JSQualifiedName myNs, boolean myElementIsFile, boolean shouldFindNsInDepth) {
        if (!(element instanceof JSElementBase)) {
            return true;
        }
        JSQualifiedName namespace = ((JSElementBase)element).getJSNamespace().getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (namespace.equals(myNs)) {
            return true;
        }
        String name = namespace.getName();
        if (myElementIsFile) {
            if (Comparing.equal((Object)namespace.getParent(), (Object)myNs) && "Window".equals(name)) {
                return true;
            }
            if (!shouldFindNsInDepth && element instanceof JSClass && JSStructureViewElement.findNsInParents(namespace, myNs) != null) {
                return true;
            }
        } else if (!StringUtil.isEmpty((String)name) && myNs != null && name.equals(myNs.getName()) && Comparing.equal((Object)JSStructureViewElement.getParentSkippingWindow(namespace), (Object)JSStructureViewElement.getParentSkippingWindow(myNs))) {
            return true;
        }
        return false;
    }

    private static JSQualifiedName getParentSkippingWindow(@Nullable JSQualifiedName namespace) {
        JSQualifiedName parent;
        JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
        if (parent != null && "Window".equals(parent.getName())) {
            return parent.getParent();
        }
        return parent;
    }

    private static JSQualifiedName findNsInParents(JSQualifiedName namespace, JSQualifiedName ns1) {
        while (namespace != null) {
            JSQualifiedName parentNs = namespace.getParent();
            if (Comparing.equal((Object)parentNs, (Object)ns1)) {
                return namespace;
            }
            namespace = parentNs;
        }
        return null;
    }

    private static boolean skipVariable(PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        if (element instanceof JSParameter) {
            return true;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        if (fun == null) {
            return false;
        }
        JSExpression initializer = ((JSVariable)element).getInitializerOrStub();
        if (initializer instanceof JSThisExpression || initializer instanceof JSAssignmentExpression) {
            return true;
        }
        if (fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall()) {
            return false;
        }
        if (JSResolveUtil.findParent((PsiElement)fun) instanceof JSClass) {
            return true;
        }
        return !JSSymbolUtil.isMeaningfulLocalVariableInitializer(initializer);
    }

    public static boolean isScopeChangingElement(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof JSFunctionExpression) || element instanceof JSCatchBlock;
    }

    private static class JSStructureImplicitNamespace
    extends JSImplicitElementImpl {
        public JSStructureImplicitNamespace(JSQualifiedName parent, PsiElement element) {
            super(new JSImplicitElementImpl.Builder(parent, element).setType(JSStructureImplicitNamespace.isClassMemberDefinition(element) ? JSImplicitElement.Type.Class : JSImplicitElement.Type.Namespace));
        }

        private static boolean isClassMemberDefinition(PsiElement element) {
            return element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getJSContext() == JSContext.INSTANCE;
        }
    }
}

