/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSAssignmentExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSAssignmentExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSAssignmentExpressionStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAssignmentExpressionElementType
extends JSStubElementType<JSAssignmentExpressionStub, JSAssignmentExpression> {
    public JSAssignmentExpressionElementType() {
        super("ASSIGNMENT_EXPRESSION");
    }

    @NotNull
    public JSAssignmentExpressionStub createStub(@NotNull JSAssignmentExpression psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/types/JSAssignmentExpressionElementType", "createStub"));
        }
        JSAssignmentExpressionStubImpl jSAssignmentExpressionStubImpl = new JSAssignmentExpressionStubImpl(psi, parentStub);
        if (jSAssignmentExpressionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSAssignmentExpressionElementType", "createStub"));
        }
        return jSAssignmentExpressionStubImpl;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSAssignmentExpressionImpl(node);
    }

    @NotNull
    public JSAssignmentExpressionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/types/JSAssignmentExpressionElementType", "deserialize"));
        }
        JSAssignmentExpressionStubImpl jSAssignmentExpressionStubImpl = new JSAssignmentExpressionStubImpl(dataStream, parentStub);
        if (jSAssignmentExpressionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/JSAssignmentExpressionElementType", "deserialize"));
        }
        return jSAssignmentExpressionStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode lOperandNode = JSBinaryExpressionImpl.getLOperandNode(node);
        if (lOperandNode == null || lOperandNode.getElementType() != JSStubElementTypes.DEFINITION_EXPRESSION) {
            return false;
        }
        return JSStubElementTypes.DEFINITION_EXPRESSION.shouldCreateStub(lOperandNode);
    }
}

