/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.inspections.JSAnnotatorInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedFunctionInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedVariableInspection;
import com.intellij.lang.javascript.inspections.JSValidateTypesInspection;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnnotatorProblemReporter
implements JSProblemReporter<Annotation> {
    private final AnnotationHolder myHolder;

    public JSAnnotatorProblemReporter(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    public Annotation registerGenericError(ASTNode nameIdentifier, String message, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier.getPsi(), message, ProblemHighlightType.GENERIC_ERROR, intentionActions);
    }

    public Annotation registerGenericError(PsiElement nameIdentifier, String message, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, intentionActions);
    }

    public Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message) {
        return this.registerProblem(nameIdentifier, message, null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
    }

    public Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier, message, type, null, LocalQuickFix.EMPTY_ARRAY, intentionActions);
    }

    @Override
    @Nullable
    public Annotation registerProblem(PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, LocalQuickFix ... fixes) {
        return this.registerProblem(nameIdentifier, message, type, inspectionId, fixes, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    protected Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
        if (intentionActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerProblem"));
        }
        return this.registerProblem(nameIdentifier, null, message, type, inspectionId, fixes, intentionActions);
    }

    @Nullable
    protected Annotation registerProblem(@Nullable PsiElement nameIdentifier, @Nullable TextRange range, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
        FileViewProvider viewProvider;
        if (intentionActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerProblem"));
        }
        if (inspectionId != null && !this.shouldReportInspectionProblems()) {
            return null;
        }
        if (inspectionId == null) {
            inspectionId = this.getAnnotatorInspectionId();
        }
        if (range == null && nameIdentifier != null) {
            range = nameIdentifier.getTextRange();
            if (JSValidateTypesInspection.SHORT_NAME.equals(inspectionId)) {
                range = JSAnnotatorProblemReporter.shortenTextRange(nameIdentifier, range);
            }
        }
        if (range == null) {
            return null;
        }
        PsiFile file = nameIdentifier != null ? nameIdentifier.getContainingFile() : null;
        LocalInspectionToolWrapper localInspectionToolWrapper = null;
        HighlightDisplayKey displayKey = null;
        InspectionProfile inspectionProfile = null;
        Set suppressors = null;
        if (nameIdentifier != null && inspectionId != null) {
            inspectionProfile = JSAnnotatorProblemReporter.getInspectionProfile(nameIdentifier);
            localInspectionToolWrapper = JSAnnotatorProblemReporter.getInspectionToolWrapper(nameIdentifier, inspectionId, inspectionProfile);
            displayKey = HighlightDisplayKey.find((String)inspectionId);
            if (localInspectionToolWrapper == null || !inspectionProfile.isToolEnabled(displayKey, (PsiElement)file)) {
                return null;
            }
            if (!IntentionAndInspectionFilter.isInspectionSupportedForElement(inspectionId, nameIdentifier)) {
                return null;
            }
            if (nameIdentifier.isValid()) {
                suppressors = InspectionProfileEntry.getSuppressors((PsiElement)nameIdentifier);
                for (InspectionSuppressor suppressor : suppressors) {
                    if (!suppressor.isSuppressedFor(nameIdentifier, inspectionId)) continue;
                    return null;
                }
                LocalInspectionTool tool = (LocalInspectionTool)localInspectionToolWrapper.getTool();
                if (SuppressionUtil.inspectionResultSuppressed((PsiElement)nameIdentifier, (LocalInspectionTool)tool)) {
                    return null;
                }
            }
        }
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        Annotation annotation = null;
        if ((type == ProblemHighlightType.ERROR || type == ProblemHighlightType.GENERIC_ERROR) && file != null && (viewProvider = file.getViewProvider()).isPhysical() && !ProjectScope.getProjectScope((Project)file.getProject()).contains(viewProvider.getVirtualFile())) {
            type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        if (type == ProblemHighlightType.ERROR || type == ProblemHighlightType.GENERIC_ERROR) {
            annotation = this.myHolder.createErrorAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            annotation = this.myHolder.createWarningAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.WEAK_WARNING) {
            annotation = this.myHolder.createWeakWarningAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.INFORMATION) {
            annotation = this.myHolder.createInfoAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (localInspectionToolWrapper != null) {
            PsiElement parent;
            LocalInspectionTool tool = (LocalInspectionTool)localInspectionToolWrapper.getTool();
            if (displayKey == null) {
                return null;
            }
            HighlightDisplayLevel defaultLevel = inspectionProfile.getErrorLevel(displayKey, nameIdentifier);
            if (tool instanceof JSUnresolvedVariableInspection && !((JSUnresolvedVariableInspection)tool).myStrictlyCheckProperties && !(parent = nameIdentifier.getParent()).getFirstChild().equals(nameIdentifier)) {
                return null;
            }
            if ((tool instanceof JSUnresolvedVariableInspection && ((JSUnresolvedVariableInspection)tool).myStrictlyCheckGlobalDefinitions || tool instanceof JSUnresolvedFunctionInspection && ((JSUnresolvedFunctionInspection)tool).myStrictlyCheckGlobalDefinitions) && (parent = nameIdentifier.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
                defaultLevel = HighlightDisplayLevel.ERROR;
            }
            if (defaultLevel == HighlightDisplayLevel.ERROR) {
                ProblemHighlightType error = type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                annotation = JSAnnotatorProblemReporter.createErrorAnnotation(range, message, error, this.myHolder);
            } else if (defaultLevel == HighlightDisplayLevel.WARNING) {
                annotation = this.myHolder.createWarningAnnotation(range, message);
            }
            if (annotation == null) {
                annotation = this.myHolder.createWeakWarningAnnotation(range, message);
            }
        } else {
            annotation = this.myHolder.createWeakWarningAnnotation(range, message);
        }
        ArrayList fixesWithSuppress = ContainerUtil.newArrayList((Object[])((Object[])ObjectUtils.notNull((Object)fixes, (Object)LocalQuickFix.EMPTY_ARRAY)));
        if (suppressors != null) {
            for (InspectionSuppressor suppressor : suppressors) {
                ContainerUtil.addAll((Collection)fixesWithSuppress, (Object[])suppressor.getSuppressActions(nameIdentifier, inspectionId));
            }
        }
        if (nameIdentifier != null && file != null) {
            JSAnnotatorProblemReporter.registerIntentionAndFixes(nameIdentifier, (LocalQuickFix[])ContainerUtil.toArray((List)fixesWithSuppress, (Object[])new LocalQuickFix[fixesWithSuppress.size()]), intentionActions, annotation, file, displayKey);
        }
        return annotation;
    }

    private boolean shouldReportInspectionProblems() {
        PsiFile psiFile = this.myHolder.getCurrentAnnotationSession().getFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if (file == null || file instanceof LightVirtualFile) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)psiFile.getProject());
        return fileIndex.isInContent(file) && !fileIndex.isInLibraryClasses(file) && !fileIndex.isInLibrarySource(file);
    }

    @NotNull
    private static InspectionProfile getInspectionProfile(@NotNull PsiElement nameIdentifier) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "getInspectionProfile"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance((Project)nameIdentifier.getProject()).getCurrentProfile();
        if (inspectionProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "getInspectionProfile"));
        }
        return inspectionProfile;
    }

    private static LocalInspectionToolWrapper getInspectionToolWrapper(@NotNull PsiElement nameIdentifier, @NotNull String inspectionId, InspectionProfile inspectionProfile) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "getInspectionToolWrapper"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "getInspectionToolWrapper"));
        }
        return (LocalInspectionToolWrapper)inspectionProfile.getInspectionTool(inspectionId, nameIdentifier);
    }

    public static void registerIntentionAndFixes(@NotNull PsiElement nameIdentifier, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions, @NotNull Annotation annotation, @NotNull PsiFile file, @Nullable HighlightDisplayKey displayKey) {
        String displayName;
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerIntentionAndFixes"));
        }
        if (intentionActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerIntentionAndFixes"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerIntentionAndFixes"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "registerIntentionAndFixes"));
        }
        boolean fixRegistered = false;
        if (fixes != null) {
            SmartPsiElementPointer pointer = null;
            LocalQuickFix[] localQuickFixArray = fixes;
            int n = localQuickFixArray.length;
            for (int i = 0; i < n; ++i) {
                LocalQuickFix l = localQuickFixArray[i];
                if (l instanceof IntentionAction) {
                    annotation.registerFix((IntentionAction)l, null, displayKey);
                    fixRegistered = true;
                    if (!(l instanceof FixAndIntentionAction)) continue;
                    pointer = ((FixAndIntentionAction)l).registerElementRefForFix(nameIdentifier, pointer);
                    continue;
                }
                if (!(l instanceof SuppressQuickFix)) continue;
                fixRegistered = true;
                annotation.registerFix((IntentionAction)SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)((SuppressQuickFix)l)), null, displayKey);
            }
        }
        for (IntentionAction action : intentionActions) {
            annotation.registerFix(action, null, displayKey);
        }
        if (!file.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && displayKey != null && !fixRegistered && (displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)displayKey)) != null) {
            annotation.registerFix((IntentionAction)new EmptyIntentionAction(displayName), null, displayKey);
        }
    }

    public static TextRange shortenTextRange(PsiElement place, TextRange range) {
        Document document = PsiDocumentManager.getInstance((Project)place.getProject()).getDocument(place.getContainingFile());
        if (document != null && document.getLineNumber(range.getStartOffset()) < document.getLineNumber(range.getEndOffset())) {
            range = new TextRange(range.getStartOffset(), document.getLineEndOffset(document.getLineNumber(range.getStartOffset())));
        }
        return range;
    }

    @Deprecated
    public static Annotation createErrorAnnotation(PsiElement nameIdentifier, String message, ProblemHighlightType type, @NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "createErrorAnnotation"));
        }
        return JSAnnotatorProblemReporter.createErrorAnnotation(nameIdentifier.getTextRange(), message, type, holder);
    }

    private static Annotation createErrorAnnotation(TextRange range, String message, ProblemHighlightType type, @NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter", "createErrorAnnotation"));
        }
        Annotation annotation = holder.createErrorAnnotation(range, message);
        annotation.setHighlightType(type);
        return annotation;
    }

    @Nullable
    protected String getAnnotatorInspectionId() {
        return JSAnnotatorInspection.SHORT_NAME;
    }
}

