/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInsertTypeGuardFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public TypeScriptInsertTypeGuardFix(@Nullable PsiElement element, String typeName) {
        super(element);
        this.myName = typeName;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "isAvailable"));
        }
        if (TypeScriptUtil.hasAmbientExternalModuleInQName(this.myName) && TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement))) {
            return false;
        }
        JSVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return false;
        }
        if (variable.getType() instanceof JSPrimitiveType && this.isTypeOfMember(this.wrapTypeToQuotes(this.myName))) {
            return false;
        }
        String name = variable.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        return parent instanceof JSExpressionStatement || parent instanceof JSVarStatement;
    }

    private static JSVariable getResolvedVariable(PsiElement startElement) {
        PsiElement resolve;
        if (startElement instanceof JSVariable) {
            return (JSVariable)startElement;
        }
        if (startElement instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)startElement).resolve()) instanceof JSVariable) {
            return (JSVariable)resolve;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "invoke"));
        }
        if (editor == null) {
            return;
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        if (parent == null) {
            return;
        }
        JSVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return;
        }
        String shortenedType = TypeScriptUtil.getShortestTypeNameInContext(this.myName, startElement);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        String typeofWrapType = this.wrapTypeToQuotes(shortenedType);
        boolean isTypeOf = this.isTypeOfMember(typeofWrapType);
        String typeOperation = isTypeOf ? "if (typeof %s === %s) {$SELECTION$}" : "if (%s instanceof %s) {$SELECTION$}";
        Template template = templateManager.createTemplate("", "", String.format(typeOperation, variable.getName(), isTypeOf ? typeofWrapType : shortenedType));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = parent.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + parent.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, parent.getText(), template);
    }

    public boolean isTypeOfMember(String typeofWrapType) {
        return ArrayUtil.contains((String)typeofWrapType, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    public String wrapTypeToQuotes(String shortenedType) {
        String string = '\"' + shortenedType + '\"';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "wrapTypeToQuotes"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"typescript.insert.type.guard.fix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix", "getFamilyName"));
        }
        return string;
    }
}

