/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.ide.macro.FilePathMacro;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6To5TaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/watcher/ES6To5TaskConsumer", "isAvailable"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(file);
        return dialect != null && dialect == DialectOptionHolder.ECMA_6 && (file.getFileType() == JavaScriptFileType.INSTANCE || file.getFileType() == ES6FileType.INSTANCE);
    }

    public String getConsumeMessage() {
        return "Enable File Watcher to transpile ECMAScript 6 to ECMAScript 5?";
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(JSBundle.message((String)"js.file.watcher.6to5.name", (Object[])new Object[0]));
        options.setDescription(JSBundle.message((String)"js.file.watcher.6to5.description", (Object[])new Object[0]));
        options.setFileExtension(JavaScriptFileType.INSTANCE.getDefaultExtension());
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/watcher/ES6To5TaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/ES6To5TaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/watcher/ES6To5TaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        JavaScriptFileType fileType = file != null ? file.getFileType() : JavaScriptFileType.INSTANCE;
        boolean es6 = fileType == ES6FileType.INSTANCE || fileType == JSXHarmonyFileType.INSTANCE;
        options.setFileExtension(fileType.getDefaultExtension());
        String outFilePathMacro = "$" + new FileNameWithoutExtension().getName() + "$" + (es6 ? "" : "-compiled") + ".js";
        options.setArguments("--source-maps --out-file " + outFilePathMacro + " --presets es2015 $" + new FilePathMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutput(outFilePathMacro + ":" + outFilePathMacro + ".map");
        options.setProgram(ES6To5TaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "babel.cmd" : "babel")));
    }
}

