/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterInfoHandler
extends JSParameterInfoHandler {
    @Override
    @Nullable
    protected JSArgumentList fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        VirtualFile virtualFile;
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/lang/typescript/TypeScriptParameterInfoHandler", "fillSignaturesForArgumentList"));
        }
        JSArgumentList result = super.fillSignaturesForArgumentList(context, argList);
        if (result != null) {
            return result;
        }
        PsiFile file = context.getFile();
        Project project = context.getProject();
        if (!TypeScriptLanguageServiceUtil.useServiceParameterInfo(project, virtualFile = file.getVirtualFile())) {
            return null;
        }
        Future<TypeScriptSignatureHelpResponse> future = TypeScriptLanguageServiceEvents.getService(project).getSignatureHelp(virtualFile, context.getEditor(), context.getOffset());
        TypeScriptSignatureHelpResponse response = TypeScriptLanguageServiceUtil.awaitFuture(future, TypeScriptLanguageServiceUtil.TIMEOUT_MILLS, 20L, null);
        if (response == null) {
            return null;
        }
        List<JSFunctionItem> items = TypeScriptLanguageServiceResponseParser.parseFunctions(response);
        context.setItemsToShow(items.stream().map(el -> new JSFunctionWithSubstitutor((JSFunctionItem)el, null)).toArray());
        return argList;
    }

    @Override
    protected boolean skipTypeScript() {
        return false;
    }
}

