/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommandOld;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileInfoBuilder {
    @NotNull
    public static FileHighlightingInfo createInfoWithUnSavedFiles(Project project, @NotNull VirtualFile currentVirtualFile, @Nullable Document currentDocument, long documentModificationTime) {
        if (currentVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVirtualFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String compilerId = TypeScriptCompilerService.getService(project).getCompilerId(currentVirtualFile);
        JSLanguageServiceUpdateContext context = TypeScriptCompileInfoBuilder.createUpdateContext(project);
        long stamp = currentVirtualFile.getModificationStamp();
        if (stamp < documentModificationTime) {
            stamp = documentModificationTime;
        }
        FileHighlightingInfo fileHighlightingInfo = new FileHighlightingInfo(currentVirtualFile, stamp, context, compilerId, TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(currentVirtualFile, project), currentDocument == null ? null : currentDocument);
        if (fileHighlightingInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        return fileHighlightingInfo;
    }

    @NotNull
    public static JSLanguageServiceUpdateContext createUpdateContext(Project project) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap nameToContent = ContainerUtil.newHashMap();
        HashMap nameToTimestamps = ContainerUtil.newHashMap();
        TypeScriptCompileInfoBuilder.fillByUnsavedDocuments(nameToContent, nameToTimestamps);
        TypeScriptCompileInfoBuilder.fillByOpenedEditors(project, nameToContent, nameToTimestamps);
        JSLanguageServiceUpdateContext jSLanguageServiceUpdateContext = new JSLanguageServiceUpdateContext(nameToContent, nameToTimestamps);
        if (jSLanguageServiceUpdateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createUpdateContext"));
        }
        return jSLanguageServiceUpdateContext;
    }

    private static void fillByOpenedEditors(Project project, Map<String, Document> nameToContent, Map<String, Long> nameToTimestamps) {
        Map<VirtualFile, Document> files = TypeScriptLanguageServiceUtil.getOpenedFiles(project);
        for (Map.Entry<VirtualFile, Document> entry : files.entrySet()) {
            long processedDocumentModificationStamp;
            VirtualFile processedOpenedFile = entry.getKey();
            String name = TypeScriptCompilerConfigUtil.normalizeNameAndPath(processedOpenedFile);
            if (nameToTimestamps.containsKey(name)) continue;
            Document document = entry.getValue();
            long processedStamp = processedOpenedFile.getModificationStamp();
            if (processedStamp < (processedDocumentModificationStamp = document.getModificationStamp())) {
                processedStamp = processedDocumentModificationStamp;
            }
            nameToContent.put(name, document);
            nameToTimestamps.put(name, processedStamp);
        }
    }

    private static void fillByUnsavedDocuments(Map<String, Document> nameToContent, Map<String, Long> nameToTimestamps) {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager.getFile(document);
            if (virtualFile == null || !virtualFile.isInLocalFileSystem() || !TypeScriptCompilerSettings.acceptFileType(virtualFile.getFileType())) continue;
            String name = TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile);
            nameToContent.put(name, document);
            nameToTimestamps.put(name, document.getModificationStamp());
        }
    }

    public static TypeScriptLanguageServiceUpdateFilesCommandOld createSimpleCompilerInput(Project project, @NotNull VirtualFile currentVirtualFile) {
        if (currentVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVirtualFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "createSimpleCompilerInput"));
        }
        String compilerId = TypeScriptCompilerService.getService(project).getCompilerId(currentVirtualFile);
        List fileNames = ContainerUtil.createMaybeSingletonList((Object)TypeScriptCompilerConfigUtil.normalizeNameAndPath(currentVirtualFile));
        return new TypeScriptLanguageServiceUpdateFilesCommandOld((Collection)fileNames, (Pair)TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(currentVirtualFile, project), compilerId){

            @Override
            public boolean shouldShowErrorsInToolWindow() {
                return false;
            }

            @Override
            public boolean isReturnCompiledFiles() {
                return true;
            }
        };
    }

    public static TypeScriptLanguageServiceUpdateFilesCommandOld createCompilerInputForConfig(Project project, TypeScriptConfig config) {
        String compilerIdForConfig = TypeScriptCompilerConfigUtil.getConfigIdByConfig(config);
        return new TypeScriptLanguageServiceUpdateFilesCommandOld((Collection)ContainerUtil.emptyList(), null, compilerIdForConfig){

            @Override
            public boolean shouldShowErrorsInToolWindow() {
                return false;
            }

            @Override
            public boolean forceCompile() {
                return true;
            }

            @Override
            public boolean isReturnCompiledFiles() {
                return true;
            }
        };
    }

    @Nullable
    public static Pair<String, String> getModuleInfoIfNeed(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfoIfNeed"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfoIfNeed"));
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (settings.isHasOutDirectory()) {
            return TypeScriptCompileInfoBuilder.getModuleInfo(file, project);
        }
        return null;
    }

    @NotNull
    public static Pair<String, String> getModuleInfo(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfo"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfo"));
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(file);
        String contentRootPath = null;
        if (contentRoot != null) {
            contentRootPath = TypeScriptCompilerService.normalizeNameAndPath(contentRoot.getCanonicalPath());
        }
        VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(file);
        String sourceRootPath = null;
        if (sourceRoot != null) {
            sourceRootPath = TypeScriptCompilerService.normalizeNameAndPath(sourceRoot.getCanonicalPath());
        }
        Pair pair = Pair.create((Object)contentRootPath, sourceRootPath);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "getModuleInfo"));
        }
        return pair;
    }

    @NotNull
    public static String toPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "toPath"));
        }
        String canonicalPath = configFile.getParent().getCanonicalPath();
        assert (canonicalPath != null);
        String string = FileUtil.toSystemDependentName((String)canonicalPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder", "toPath"));
        }
        return string;
    }

    public static class FileHighlightingInfo {
        public final VirtualFile file;
        public final long fileTimestamp;
        public final JSLanguageServiceUpdateContext updateContext;
        public final String compilerId;
        public final Document currentFileDocument;
        public final Pair<String, String> moduleInfo;

        /*
         * WARNING - void declaration
         */
        public FileHighlightingInfo(@NotNull VirtualFile file, long fileTimestamp, JSLanguageServiceUpdateContext updateContext, String compilerId, Pair<String, String> moduleInfo, Document document) {
            void currentFileDocument;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompileInfoBuilder$FileHighlightingInfo", "<init>"));
            }
            this.file = file;
            this.fileTimestamp = fileTimestamp;
            this.updateContext = updateContext;
            this.compilerId = compilerId;
            this.moduleInfo = moduleInfo;
            this.currentFileDocument = currentFileDocument;
        }
    }
}

