/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.compilerService.TypeScriptCompilerServiceImpl;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptCompilerService
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final String TYPE_SCRIPT_COMPILER_INFO = "TypeScript Compiler Info";
    public static final String GO_TO_CONFIG_ACTION = "PATH";
    public static final String DEFAULT_CONFIG_NAME = "default";
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    @Nullable
    protected final JSLanguageServiceToolWindowManager myToolWindowManager;
    @NotNull
    protected final Object myLock;
    @NotNull
    private final Alarm myCheckCompilerAliveAlarm;
    protected volatile JSLanguageService myService;

    @NotNull
    public GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.mySettings.getScopeName());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public JSLanguageServiceToolWindowManager getToolWindowManager() {
        return this.myToolWindowManager;
    }

    public static TypeScriptCompilerService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getService"));
        }
        if (TypeScriptLanguageServiceUtil.useServiceByDefault(project)) {
            return (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptServerServiceImpl.class);
        }
        return (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptCompilerServiceImpl.class);
    }

    public TypeScriptCompilerService(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "<init>"));
        }
        this.myLock = new Object();
        this.myProject = project;
        this.mySettings = settings;
        NotificationsConfiguration.getNotificationsConfiguration().register(TYPE_SCRIPT_COMPILER_INFO, NotificationDisplayType.NONE, true);
        this.myToolWindowManager = this.createToolWindow(project);
        this.myCheckCompilerAliveAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                JSLanguageService compiler = TypeScriptCompilerService.this.myService;
                if (compiler != null) {
                    Object object = TypeScriptCompilerService.this.myLock;
                    synchronized (object) {
                        compiler = TypeScriptCompilerService.this.myService;
                        if (compiler != null && compiler.getState() == JSLanguageService.State.ERROR_OR_TIMEOUT) {
                            ApplicationManager.getApplication().invokeLater(() -> TypeScriptCompilerService.this.restartProcessImpl(false));
                        }
                    }
                }
                if (TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.isDisposed() || TypeScriptCompilerService.this.myProject.isDisposed()) {
                    return;
                }
                TypeScriptCompilerService.this.myCheckCompilerAliveAlarm.addRequest((Runnable)this, 5000);
            }
        }.run();
        this.initToolWindow();
    }

    @Nullable
    public JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    protected static JSLanguageServiceCommandResultProcessor getResetCachesProcessor(final @NotNull JSLanguageService service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getResetCachesProcessor"));
        }
        return new JSLanguageServiceCommandResultProcessor<Boolean>(){

            @Override
            public Boolean process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$2", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService$2", "process"));
                }
                service.resetCaches();
                return true;
            }
        };
    }

    public abstract void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean var1);

    @Nullable
    public abstract Future<List<JSLanguageServiceAnnotationResult>> updateFilesAndGetErrors(@NotNull TypeScriptCompileInfoBuilder.FileHighlightingInfo var1, boolean var2);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig var1);

    @Nullable
    protected final JSLanguageService getProcess() {
        JSLanguageService toReturn = this.myService;
        if (toReturn != null) {
            return toReturn;
        }
        return (JSLanguageService)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return this.computeProcessUnderLocks();
            }
        });
    }

    @Nullable
    protected JSLanguageService computeProcessUnderLocks() {
        JSLanguageService service = this.myService;
        if (service == null) {
            Collection<TypeScriptConfig> files;
            boolean useNewService = TypeScriptCompilerSettings.useNewTypeScriptService(this.myProject);
            boolean useConfig = this.mySettings.isUseConfigForCompiler();
            if (useConfig && !useNewService && (files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject)).isEmpty()) {
                if (this.myToolWindowManager != null) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        String message = "Cannot find tsconfig.json in the project";
                        this.myToolWindowManager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)JSLanguageServiceAnnotationResult.buildError(message), true);
                    });
                }
                if (this.mySettings.isUseConfigForCompiler()) {
                    return null;
                }
            }
            this.myService = service = this.createService();
        }
        return service;
    }

    @NotNull
    protected abstract JSLanguageServiceImpl createService();

    public abstract void addFileToCompileQueue(@NotNull List<VirtualFile> var1);

    public void resetCaches() {
        JSLanguageService process = this.getProcess();
        if (process != null) {
            process.resetCaches();
        }
    }

    @NotNull
    protected String getCompilerId(@NotNull VirtualFile targetFile) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
        }
        if (!this.mySettings.isUseConfigForCompiler()) {
            if (DEFAULT_CONFIG_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
            }
            return DEFAULT_CONFIG_NAME;
        }
        Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
        if (files.isEmpty()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                JSLanguageServiceToolWindowManager manager = this.myToolWindowManager;
                if (manager != null) {
                    manager.printToConsole("IDE message: Project doesn't contain tsconfig.json\n");
                }
            });
            if (DEFAULT_CONFIG_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
            }
            return DEFAULT_CONFIG_NAME;
        }
        String configId = TypeScriptCompilerConfigUtil.getConfigIdForFile(this.myProject, targetFile);
        String string = configId == null ? DEFAULT_CONFIG_NAME : configId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "getCompilerId"));
        }
        return string;
    }

    public static String normalizeNameAndPath(@Nullable String path) {
        if (null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLanguageService(@Nullable JSLanguageService service) {
        Object object = this.myLock;
        synchronized (object) {
            this.myService = service;
            this.cleanLocalState();
        }
    }

    public void restartService() {
        this.restartProcessImpl(true);
    }

    public void restartService(boolean recreateToolWindow) {
        this.restartProcessImpl(recreateToolWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartProcessImpl(boolean recreateToolWindow) {
        Object object = this.myLock;
        synchronized (object) {
            JSLanguageServiceToolWindowManager manager = this.myToolWindowManager;
            if (manager != null && (recreateToolWindow || manager.isConnectedToProcessHandler())) {
                manager.cleanPanel();
            }
            JSLanguageService service = this.myService;
            this.initToolWindow();
            this.cleanLocalState();
            if (service != null) {
                this.myService = null;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (service.getState() != JSLanguageService.State.DISPOSED) {
                        Disposer.dispose((Disposable)service);
                    }
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (service.getState() != JSLanguageService.State.DISPOSED) {
                            Disposer.dispose((Disposable)service);
                        }
                    });
                }
            }
            this.initToolWindow();
        }
    }

    protected void cleanLocalState() {
    }

    public void sendCommand(@NotNull JSLanguageServiceSimpleCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "sendCommand"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null);
    }

    @Nullable
    public abstract Future<Boolean> update(JSLanguageServiceUpdateContext var1);

    @Nullable
    public <T> Future<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandResultProcessor<T> processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "sendCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "sendCommand"));
        }
        JSLanguageService process = this.getProcess();
        if (process == null) {
            return null;
        }
        return process.execute(command, processor);
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && (this.mySettings.isCompilerEnabled() || this.mySettings.isUseService());
    }

    private void initToolWindow() {
        if (this.myToolWindowManager == null || this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isEnabled()) {
                this.myToolWindowManager.init();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }, this.myProject.getDisposed()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderLockAndRestart(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/lang/typescript/compiler/TypeScriptCompilerService", "runUnderLockAndRestart"));
        }
        Object object = this.myLock;
        synchronized (object) {
            runnable.run();
            this.restartService();
        }
    }

    public void dispose() {
        JSLanguageService compiler = this.myService;
        if (compiler != null) {
            Disposer.dispose((Disposable)compiler);
        }
    }
}

