/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerExternalAnnotator;
import com.intellij.lang.typescript.compiler.TypeScriptServiceSharedHighlightingStateHolder;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    public static final TypeScriptCompilerExternalAnnotator ANNOTATOR = new TypeScriptCompilerExternalAnnotator();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TypeScriptServiceSharedHighlightingStateHolder myHolder;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final AnnotationHolderImpl myAnnotationHolder;
    private volatile List<JSLanguageServiceAnnotationResult> myLastResult;

    protected TypeScriptServiceHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull TypeScriptServiceSharedHighlightingStateHolder myStateHolder, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "<init>"));
        }
        if (myStateHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myStateHolder", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "<init>"));
        }
        super(project, editor.getDocument(), false);
        this.myLastResult = null;
        this.myFile = file;
        this.myHolder = myStateHolder;
        this.myEditor = editor;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file));
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "doCollectInformation"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.needProcessAnnotation()) {
            return;
        }
        long docTimeStamp = this.myEditor.getDocument().getModificationStamp();
        TypeScriptServiceSharedHighlightingStateHolder.CalcState runningState = this.myHolder.getState(this.myFile);
        if (runningState != null) {
            Future<List<JSLanguageServiceAnnotationResult>> future = runningState.future;
            if (future.isDone()) {
                this.myLastResult = TypeScriptServiceHighlightingPass.awaitResults(future, progress);
                this.myHolder.reset(this.myFile);
                if (docTimeStamp == runningState.stamp) {
                    return;
                }
            } else {
                if (docTimeStamp == runningState.stamp) {
                    this.myLastResult = TypeScriptServiceHighlightingPass.awaitResults(future, progress);
                    this.myHolder.reset(this.myFile);
                    return;
                }
                this.myHolder.reset(this.myFile);
                future.cancel(false);
            }
        }
        this.startAwaitingNewResults(progress, docTimeStamp);
    }

    private void startAwaitingNewResults(@NotNull ProgressIndicator progress, long docTimeStamp) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "startAwaitingNewResults"));
        }
        TypeScriptCompilerExternalAnnotator.DataToCompile data = ANNOTATOR.createCompileData(this.myFile, this.myEditor, this.myProject);
        if (data.changedConfigs != null) {
            this.saveChangedConfigsAndRestartAnnotation(data);
            return;
        }
        Future<List<JSLanguageServiceAnnotationResult>> future = ANNOTATOR.getFutureByData(data);
        if (future == null) {
            return;
        }
        this.myHolder.saveState(this.myFile, new TypeScriptServiceSharedHighlightingStateHolder.CalcState(future, docTimeStamp));
        this.myLastResult = TypeScriptServiceHighlightingPass.awaitResults(future, progress);
        this.myHolder.reset(this.myFile);
    }

    @Nullable
    private static List<JSLanguageServiceAnnotationResult> awaitResults(@Nullable Future<List<JSLanguageServiceAnnotationResult>> future, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "awaitResults"));
        }
        return TypeScriptLanguageServiceUtil.awaitFuture(future, TypeScriptLanguageServiceUtil.TIMEOUT_MILLS, 20L, progress);
    }

    public void doApplyInformationToEditor() {
        Editor editor;
        JSLanguageServiceToolWindowManager toolWindowManager;
        if (this.myDocument == null) {
            return;
        }
        boolean needApply = this.needProcessAnnotation();
        if (needApply) {
            ANNOTATOR.apply(this.myFile, this.myLastResult, (AnnotationHolder)this.myAnnotationHolder);
        }
        List<HighlightInfo> infos = this.getHighlights();
        if (needApply && (toolWindowManager = TypeScriptToolWindowProvider.getToolWindow(this.myProject)) != null && this.myLastResult != null && this.myEditor == (editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor())) {
            toolWindowManager.logCurrentErrors(this.myLastResult, false);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private boolean needProcessAnnotation() {
        return TypeScriptLanguageServiceUtil.useServiceAnnotation(this.myProject);
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.getHighlights();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "getInfos"));
        }
        return list;
    }

    private void saveChangedConfigsAndRestartAnnotation(TypeScriptCompilerExternalAnnotator.DataToCompile data) {
        Project project = this.myEditor.getProject();
        if (project != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                Collection<VirtualFile> configs = data.changedConfigs;
                assert (configs != null);
                for (VirtualFile config : configs) {
                    Document document = FileDocumentManager.getInstance().getDocument(config);
                    if (document == null) continue;
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart(this.myFile);
            }, project.getDisposed());
        }
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        if (this.myAnnotationHolder.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "getHighlights"));
            }
            return list;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        for (Annotation annotation : this.myAnnotationHolder) {
            infos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPass", "getHighlights"));
        }
        return arrayList;
    }
}

