/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileActionBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileAllAction
extends TypeScriptCompileActionBase {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    public TypeScriptCompileAllAction() {
        this(JSBundle.message((String)"typescript.compiler.action.compile.all", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.all.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile2);
    }

    public TypeScriptCompileAllAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Override
    @Nullable
    protected Consumer<ProgressIndicator> getBackgroundProcess(Project project, @Nullable DataContext context) {
        return indicator -> this.runCompile(project, (ProgressIndicator)indicator, null);
    }

    protected void runCompile(@NotNull Project project, @NotNull ProgressIndicator indicator, @Nullable VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "runCompile"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "runCompile"));
        }
        LinkedHashSet infos = ContainerUtil.newLinkedHashSet();
        TypeScriptCompilerService compilerService = TypeScriptCompilerService.getService(project);
        GlobalSearchScope scope = TypeScriptCompilerConfigUtil.getCompileScope(project);
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        this.runBeforeStartingCompile(indicator, project, compilerService);
        if (this.processConfigsOnly(settings)) {
            this.processConfigs(project, indicator, compilerService, infos, scope);
            indicator.checkCanceled();
            this.logErrors(infos, compilerService);
            return;
        }
        boolean mainOnly = settings.isUseMainFile();
        HashSet processedFiles = ContainerUtil.newHashSet();
        this.iterateFilesForCompile(project, indicator, (Processor<VirtualFile>)((Processor)file -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "lambda$runCompile$1"));
            }
            return this.processFile(indicator, infos, compilerService, scope, mainOnly, processedFiles, (VirtualFile)file);
        }), files);
        indicator.checkCanceled();
        this.logErrors(infos, compilerService);
    }

    protected boolean processConfigsOnly(TypeScriptCompilerSettings settings) {
        return settings.isUseConfigForCompiler();
    }

    private boolean processFile(@NotNull ProgressIndicator indicator, @NotNull Collection<JSLanguageServiceAnnotationResult> infos, @NotNull TypeScriptCompilerService compilerService, @NotNull GlobalSearchScope scope, boolean mainOnly, @NotNull Set<String> processedFiles, @NotNull VirtualFile file) {
        String path;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        if (compilerService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerService", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        if (processedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedFiles", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "processFile"));
        }
        indicator.checkCanceled();
        if (!TypeScriptCompilerSettings.acceptFileType(file.getFileType()) || !scope.accept(file) || JSLibraryUtil.isProbableLibraryFile(file)) {
            return true;
        }
        if (processedFiles.size() > 0 && (path = file.getCanonicalPath()) != null) {
            String independentName = FileUtil.toSystemIndependentName((String)path);
            if (processedFiles.contains(independentName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Action Compile: skip compile for " + file.getName());
                }
                return true;
            }
            if (mainOnly) {
                infos.add(new JSLanguageServiceAnnotationResult(JSBundle.message((String)"typescript.compiler.action.no.compile.message", (Object[])new Object[0]), path, "warning", 0, 0, 0, 0));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Action Compile: skip and warning no compile for " + file.getName());
                }
                return true;
            }
        }
        return this.compileFile(file, indicator, compilerService, infos, processedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processConfigs(Project project, ProgressIndicator indicator, TypeScriptCompilerService service, Collection<JSLanguageServiceAnnotationResult> infos, GlobalSearchScope scope) {
        Collection<TypeScriptConfig> configs;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            configs = this.getConfigsForProcessing(project, service);
        }
        finally {
            token.finish();
        }
        for (TypeScriptConfig config : configs) {
            if (scope.contains(config.getConfigFile()) && !this.compileConfig(indicator, service, config, infos)) break;
        }
    }

    @NotNull
    protected Collection<TypeScriptConfig> getConfigsForProcessing(Project project, TypeScriptCompilerService service) {
        Collection<TypeScriptConfig> collection = TypeScriptConfigService.Provider.getConfigFiles(project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "getConfigsForProcessing"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        GlobalSearchScope scope = TypeScriptCompilerConfigUtil.getCompileScope(project);
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        ArrayList filesToIterate = ContainerUtil.newArrayList();
        try {
            for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
                filesToIterate.addAll(FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope));
            }
        }
        finally {
            token.finish();
        }
        for (VirtualFile file : filesToIterate) {
            if (TypeScriptUtil.isUnderNodeModules(file, project) || processor.process((Object)file)) continue;
            return;
        }
    }
}

