/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.google.gson.stream.JsonReader;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerVersionDialog;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.webcore.util.JsonUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.CharArrayReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerVersionPanel
extends JPanel {
    public static final Key<Pair<Long, String>> VERSION_TEXT = Key.create((String)"ts.panel.version");
    public static final String TYPESCRIPT_FOLDER_NAME = "typescript";
    private final JBLabel myLabel;
    private final JButton myEditButtion;
    @Nullable
    private final Project myProject;
    private final TypeScriptCompilerSettings mySettings;
    private String myServiceDirectory;
    private TypeScriptCompilerSettings.TypeScriptCompilerVersionType myVersionType;

    public TypeScriptCompilerSettings.TypeScriptCompilerVersionType getMyVersionType() {
        return this.myVersionType;
    }

    public TypeScriptCompilerVersionPanel(final @Nullable Project project, TypeScriptCompilerSettings settings) {
        super(new FlowLayout(0));
        this.myProject = project;
        this.mySettings = settings;
        this.myLabel = new JBLabel("Text field");
        this.myEditButtion = new JButton("Edit...");
        this.add((Component)this.myLabel, "Center");
        this.add((Component)this.myEditButtion, "East");
        this.myEditButtion.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeScriptCompilerVersionDialog dialog = new TypeScriptCompilerVersionDialog(project, TypeScriptCompilerVersionPanel.this);
                if (dialog.showAndGet()) {
                    TypeScriptCompilerVersionPanel.this.myVersionType = dialog.getVersionType();
                    TypeScriptCompilerVersionPanel.this.myServiceDirectory = dialog.getServiceDirectory();
                    TypeScriptCompilerVersionPanel.this.myLabel.setText(TypeScriptCompilerVersionPanel.this.getVersionTitle(TypeScriptCompilerVersionPanel.this.myVersionType, false));
                }
            }
        });
    }

    public void resetValue() {
        this.myVersionType = this.mySettings.getVersionType();
        this.myServiceDirectory = this.mySettings.getTypeScriptServiceDirectory();
        this.myLabel.setText(this.getVersionTitle(this.myVersionType, false));
    }

    public void apply() {
        this.mySettings.setVersionType(this.myVersionType);
        this.mySettings.setTypeScriptServiceDirectory(this.myServiceDirectory);
        this.myLabel.setText(this.getVersionTitle(this.myVersionType, false));
    }

    public boolean isModified() {
        return this.myVersionType != this.mySettings.getVersionType() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myServiceDirectory), (CharSequence)this.mySettings.getTypeScriptServiceDirectory());
    }

    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    private String getVersionTitle(@NotNull TypeScriptCompilerSettings.TypeScriptCompilerVersionType version, boolean force) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerVersionPanel", "getVersionTitle"));
        }
        switch (version) {
            case EMBEDDED_OR_DETECTED: {
                VirtualFile libDirectory = TypeScriptLanguageServiceUtil.findTypeScriptLibDirectory(this.myProject);
                if (libDirectory != null) {
                    return this.setVersionTextForPath(force, libDirectory, "node_modules");
                }
            }
            case EMBEDDED: {
                return String.format("%s (bundled)", JSBundle.message((String)"typescript.compiler.embedded.version", (Object[])new Object[0]));
            }
            case SERVICE_DIRECTORY: {
                VirtualFile path = this.getFileForDirectory();
                return this.setVersionTextForPath(force, path, "custom");
            }
        }
        return null;
    }

    private String setVersionTextForPath(boolean force, VirtualFile path, String name) {
        String versionText = null;
        if (path != null) {
            Pair data = (Pair)path.getUserData(VERSION_TEXT);
            if (!force) {
                this.updateVersionAsync(path, (Pair<Long, String>)data);
            }
            versionText = data == null ? null : (String)data.second;
        }
        return !StringUtil.isEmpty(versionText) ? String.format("%s (%s)", versionText, name) : name;
    }

    private VirtualFile getFileForDirectory() {
        String directory = this.myServiceDirectory;
        if (StringUtil.isEmpty((String)directory)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(directory);
    }

    private void updateVersionAsync(@NotNull VirtualFile path, @Nullable Pair<Long, String> oldData) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerVersionPanel", "updateVersionAsync"));
        }
        if (oldData == null) {
            path.putUserData(VERSION_TEXT, TypeScriptCompilerVersionPanel.getKey("", null));
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerVersionPanel", "lambda$updateVersionAsync$1"));
            }
            if (this.readVersion(path, oldData)) {
                application.invokeLater(() -> {
                    this.myLabel.setText(this.getVersionTitle(this.myVersionType, true));
                    this.myLabel.invalidate();
                }, ModalityState.any());
            }
        });
    }

    private boolean readVersion(@NotNull VirtualFile saveTo, @Nullable Pair<Long, String> oldData) {
        if (saveTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveTo", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerVersionPanel", "readVersion"));
        }
        VirtualFile parent = saveTo.getParent();
        if (parent == null || !TYPESCRIPT_FOLDER_NAME.equals(parent.getName())) {
            saveTo.putUserData(VERSION_TEXT, TypeScriptCompilerVersionPanel.getKey("", null));
            return false;
        }
        VirtualFile packageJson = parent.findChild("package.json");
        if (packageJson == null || packageJson.getCanonicalPath() == null) {
            saveTo.putUserData(VERSION_TEXT, TypeScriptCompilerVersionPanel.getKey("", null));
            return false;
        }
        String canonicalPath = packageJson.getCanonicalPath();
        File file = new File(canonicalPath);
        if (oldData != null && oldData.first != null && packageJson.getCanonicalPath() != null && file.exists() && file.lastModified() == ((Long)oldData.first).longValue()) {
            return false;
        }
        JsonReader jsonReader = null;
        try {
            char[] chars = FileUtilRt.loadFileText((File)file, (Charset)packageJson.getCharset());
            CharArrayReader reader = new CharArrayReader(chars);
            jsonReader = new JsonReader((Reader)reader);
            String versionText = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"version");
            if (!StringUtil.isEmpty((String)versionText)) {
                saveTo.putUserData(VERSION_TEXT, TypeScriptCompilerVersionPanel.getKey(versionText, file.lastModified()));
                return true;
            }
            saveTo.putUserData(VERSION_TEXT, TypeScriptCompilerVersionPanel.getKey("", file.lastModified()));
        }
        catch (Exception e) {
            IOUtils.closeQuietly(jsonReader);
        }
        return false;
    }

    private static Pair<Long, String> getKey(String value, @Nullable VirtualFile file) {
        return TypeScriptCompilerVersionPanel.getKey(value, TypeScriptCompilerVersionPanel.getFileStamp(file));
    }

    private static Pair<Long, String> getKey(String value, long stamp) {
        return Pair.create((Object)stamp, (Object)value);
    }

    private static long getFileStamp(@Nullable VirtualFile file) {
        return file == null ? -1L : file.getTimeStamp();
    }
}

